/*
 * Decompiled with CFR 0.152.
 */
package com.google.javascript.jscomp.newtypes;

import com.google.common.collect.HashMultimap;
import com.google.common.collect.SetMultimap;
import com.google.javascript.jscomp.newtypes.JSType;
import com.google.javascript.jscomp.newtypes.UniqueNameGenerator;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;

public class ToStringContext {
    static final ToStringContext TO_STRING = new ToStringContext();
    static final ToStringContext FOR_ANNOTATION = new ToStringContext(){

        @Override
        boolean forAnnotation() {
            return true;
        }
    };

    public static ToStringContext disambiguateTypeVars(JSType ... types) {
        DisambiguateTypeVars ctx = new DisambiguateTypeVars();
        StringBuilder sb = new StringBuilder();
        for (JSType type : types) {
            type.appendTo(sb, ctx);
        }
        ctx.freeze();
        return ctx;
    }

    private ToStringContext() {
    }

    String formatTypeVar(String typeVar) {
        return UniqueNameGenerator.getOriginalName(typeVar);
    }

    boolean forAnnotation() {
        return false;
    }

    private static class DisambiguateTypeVars
    extends ToStringContext {
        final SetMultimap<String, String> simpleToUnique = HashMultimap.create();
        final Map<String, String> renamings = new HashMap<String, String>();

        private DisambiguateTypeVars() {
        }

        @Override
        String formatTypeVar(String typeVar) {
            String result = this.renamings.get(typeVar);
            if (result != null) {
                return result;
            }
            String simple = super.formatTypeVar(typeVar);
            this.simpleToUnique.put((Object)simple, (Object)typeVar);
            result = simple + "#" + this.simpleToUnique.get((Object)simple).size();
            this.renamings.put(typeVar, result);
            return result;
        }

        void freeze() {
            for (Map.Entry entry : this.simpleToUnique.asMap().entrySet()) {
                if (((Collection)entry.getValue()).size() != 1) continue;
                this.renamings.put((String)((Collection)entry.getValue()).iterator().next(), (String)entry.getKey());
            }
        }
    }
}

