/*
 * Decompiled with CFR 0.152.
 */
package com.google.javascript.rhino.jstype;

import com.google.javascript.rhino.jstype.BooleanLiteralSet;
import com.google.javascript.rhino.jstype.JSType;
import com.google.javascript.rhino.jstype.JSTypeNative;
import com.google.javascript.rhino.jstype.JSTypeRegistry;
import com.google.javascript.rhino.jstype.TernaryValue;
import com.google.javascript.rhino.jstype.ValueType;
import com.google.javascript.rhino.jstype.Visitor;

public final class StringType
extends ValueType {
    private static final long serialVersionUID = 1L;

    StringType(JSTypeRegistry registry) {
        super(registry);
    }

    @Override
    public TernaryValue testForEquality(JSType that) {
        TernaryValue result = super.testForEquality(that);
        if (result != null) {
            return result;
        }
        if (that.isUnknownType() || that.isSubtypeOf(this.getNativeType(JSTypeNative.OBJECT_NUMBER_STRING_BOOLEAN))) {
            return TernaryValue.UNKNOWN;
        }
        return TernaryValue.FALSE;
    }

    @Override
    public boolean isStringValueType() {
        return true;
    }

    @Override
    public boolean matchesNumberContext() {
        return true;
    }

    @Override
    public boolean matchesStringContext() {
        return true;
    }

    @Override
    public boolean matchesObjectContext() {
        return true;
    }

    @Override
    StringBuilder appendTo(StringBuilder sb, boolean forAnnotations) {
        return sb.append(this.getDisplayName());
    }

    @Override
    public String getDisplayName() {
        return "string";
    }

    @Override
    public JSType autoboxesTo() {
        return this.getNativeType(JSTypeNative.STRING_OBJECT_TYPE);
    }

    @Override
    public BooleanLiteralSet getPossibleToBooleanOutcomes() {
        return BooleanLiteralSet.BOTH;
    }

    @Override
    public <T> T visit(Visitor<T> visitor) {
        return visitor.caseStringType();
    }

    @Override
    public int hashCode() {
        return System.identityHashCode(this);
    }
}

