/*
 * Decompiled with CFR 0.152.
 */
package com.google.javascript.rhino.jstype;

import com.google.common.base.Joiner;
import com.google.common.base.Predicate;
import com.google.common.collect.ImmutableList;
import com.google.javascript.rhino.ErrorReporter;
import com.google.javascript.rhino.jstype.BooleanLiteralSet;
import com.google.javascript.rhino.jstype.EquivalenceMethod;
import com.google.javascript.rhino.jstype.JSType;
import com.google.javascript.rhino.jstype.JSTypeNative;
import com.google.javascript.rhino.jstype.JSTypeRegistry;
import com.google.javascript.rhino.jstype.ObjectType;
import com.google.javascript.rhino.jstype.RelationshipVisitor;
import com.google.javascript.rhino.jstype.StaticTypedScope;
import com.google.javascript.rhino.jstype.TernaryValue;
import com.google.javascript.rhino.jstype.UnionTypeBuilder;
import com.google.javascript.rhino.jstype.Visitor;
import java.util.ArrayList;
import java.util.Collection;
import java.util.TreeSet;

public class UnionType
extends JSType {
    private static final long serialVersionUID = 1L;
    ImmutableList<JSType> alternatesWithoutStucturalTyping;
    ImmutableList<JSType> alternates;
    private int hashcode;

    UnionType(JSTypeRegistry registry, ImmutableList<JSType> alternatesWithoutStructuralTyping) {
        super(registry);
        this.alternatesWithoutStucturalTyping = alternatesWithoutStructuralTyping;
        UnionTypeBuilder builder = new UnionTypeBuilder(registry);
        for (JSType alternate : alternatesWithoutStructuralTyping) {
            builder.addAlternate(alternate, true);
        }
        this.alternates = builder.getAlternates();
        this.hashcode = this.alternatesWithoutStucturalTyping.hashCode();
    }

    public Collection<JSType> getAlternates() {
        return this.getAlternatesList();
    }

    ImmutableList<JSType> getAlternatesList() {
        for (int i = 0; i < this.alternatesWithoutStucturalTyping.size(); ++i) {
            JSType t = (JSType)this.alternatesWithoutStucturalTyping.get(i);
            if (!t.isUnionType()) continue;
            this.rebuildAlternates();
            break;
        }
        return this.alternates;
    }

    public Collection<JSType> getAlternatesWithoutStructuralTyping() {
        return this.getAlternatesWithoutStructuralTypingList();
    }

    ImmutableList<JSType> getAlternatesWithoutStructuralTypingList() {
        for (int i = 0; i < this.alternatesWithoutStucturalTyping.size(); ++i) {
            JSType t = (JSType)this.alternatesWithoutStucturalTyping.get(i);
            if (!t.isUnionType()) continue;
            this.rebuildAlternates();
            break;
        }
        return this.alternatesWithoutStucturalTyping;
    }

    private void rebuildAlternates() {
        UnionTypeBuilder builder = new UnionTypeBuilder(this.registry);
        for (JSType alternate : this.alternatesWithoutStucturalTyping) {
            builder.addAlternate(alternate);
        }
        this.alternatesWithoutStucturalTyping = builder.getAlternates();
        builder = new UnionTypeBuilder(this.registry);
        for (JSType alternate : this.alternatesWithoutStucturalTyping) {
            builder.addAlternate(alternate, true);
        }
        this.alternates = builder.getAlternates();
        this.hashcode = this.alternatesWithoutStucturalTyping.hashCode();
    }

    @Override
    public boolean matchesNumberContext() {
        for (JSType t : this.alternatesWithoutStucturalTyping) {
            if (!t.matchesNumberContext()) continue;
            return true;
        }
        return false;
    }

    @Override
    public boolean matchesStringContext() {
        for (JSType t : this.alternatesWithoutStucturalTyping) {
            if (!t.matchesStringContext()) continue;
            return true;
        }
        return false;
    }

    @Override
    public boolean matchesSymbolContext() {
        for (JSType t : this.alternatesWithoutStucturalTyping) {
            if (!t.matchesSymbolContext()) continue;
            return true;
        }
        return false;
    }

    @Override
    public boolean matchesObjectContext() {
        for (JSType t : this.alternatesWithoutStucturalTyping) {
            if (!t.matchesObjectContext()) continue;
            return true;
        }
        return false;
    }

    @Override
    public JSType findPropertyType(String propertyName) {
        JSType propertyType = null;
        for (JSType alternate : this.getAlternates()) {
            JSType altPropertyType;
            if (alternate.isNullType() || alternate.isVoidType() || (altPropertyType = alternate.findPropertyType(propertyName)) == null) continue;
            if (propertyType == null) {
                propertyType = altPropertyType;
                continue;
            }
            propertyType = propertyType.getLeastSupertype(altPropertyType);
        }
        return propertyType;
    }

    @Override
    public boolean canBeCalled() {
        for (int i = 0; i < this.alternatesWithoutStucturalTyping.size(); ++i) {
            JSType t = (JSType)this.alternatesWithoutStucturalTyping.get(i);
            if (t.canBeCalled()) continue;
            return false;
        }
        return true;
    }

    @Override
    public JSType autobox() {
        UnionTypeBuilder restricted = new UnionTypeBuilder(this.registry);
        for (int i = 0; i < this.alternatesWithoutStucturalTyping.size(); ++i) {
            JSType t = (JSType)this.alternatesWithoutStucturalTyping.get(i);
            restricted.addAlternate(t.autobox());
        }
        return restricted.build();
    }

    @Override
    public JSType restrictByNotNullOrUndefined() {
        UnionTypeBuilder restricted = new UnionTypeBuilder(this.registry);
        for (int i = 0; i < this.alternatesWithoutStucturalTyping.size(); ++i) {
            JSType t = (JSType)this.alternatesWithoutStucturalTyping.get(i);
            restricted.addAlternate(t.restrictByNotNullOrUndefined());
        }
        return restricted.build();
    }

    @Override
    public TernaryValue testForEquality(JSType that) {
        TernaryValue result = null;
        for (int i = 0; i < this.alternatesWithoutStucturalTyping.size(); ++i) {
            JSType t = (JSType)this.alternatesWithoutStucturalTyping.get(i);
            TernaryValue test = t.testForEquality(that);
            if (result == null) {
                result = test;
                continue;
            }
            if (result.equals((Object)test)) continue;
            return TernaryValue.UNKNOWN;
        }
        return result;
    }

    @Override
    public boolean isNullable() {
        for (int i = 0; i < this.alternatesWithoutStucturalTyping.size(); ++i) {
            JSType t = (JSType)this.alternatesWithoutStucturalTyping.get(i);
            if (!t.isNullable()) continue;
            return true;
        }
        return false;
    }

    @Override
    public boolean isVoidable() {
        for (int i = 0; i < this.alternatesWithoutStucturalTyping.size(); ++i) {
            JSType t = (JSType)this.alternatesWithoutStucturalTyping.get(i);
            if (!t.isVoidable()) continue;
            return true;
        }
        return false;
    }

    @Override
    public boolean isExplicitlyVoidable() {
        for (int i = 0; i < this.alternatesWithoutStucturalTyping.size(); ++i) {
            JSType t = (JSType)this.alternatesWithoutStucturalTyping.get(i);
            if (!t.isExplicitlyVoidable()) continue;
            return true;
        }
        return false;
    }

    @Override
    public boolean isUnknownType() {
        for (int i = 0; i < this.alternatesWithoutStucturalTyping.size(); ++i) {
            JSType t = (JSType)this.alternatesWithoutStucturalTyping.get(i);
            if (!t.isUnknownType()) continue;
            return true;
        }
        return false;
    }

    @Override
    public boolean isStruct() {
        ImmutableList<JSType> alternates = this.getAlternatesList();
        for (int i = 0; i < alternates.size(); ++i) {
            JSType typ = (JSType)alternates.get(i);
            if (!typ.isStruct()) continue;
            return true;
        }
        return false;
    }

    @Override
    public boolean isDict() {
        ImmutableList<JSType> alternates = this.getAlternatesList();
        for (int i = 0; i < alternates.size(); ++i) {
            JSType typ = (JSType)alternates.get(i);
            if (!typ.isDict()) continue;
            return true;
        }
        return false;
    }

    @Override
    public JSType getLeastSupertype(JSType that) {
        if (!that.isUnknownType() && !that.isUnionType()) {
            for (int i = 0; i < this.alternatesWithoutStucturalTyping.size(); ++i) {
                JSType alternate = (JSType)this.alternatesWithoutStucturalTyping.get(i);
                if (alternate.isUnknownType() || !that.isSubtypeOf(alternate)) continue;
                return this;
            }
        }
        return JSType.getLeastSupertype(this, that);
    }

    JSType meet(JSType that) {
        JSType result;
        UnionTypeBuilder builder = new UnionTypeBuilder(this.registry);
        for (int i = 0; i < this.alternatesWithoutStucturalTyping.size(); ++i) {
            JSType alternate = (JSType)this.alternatesWithoutStucturalTyping.get(i);
            if (!alternate.isSubtypeOf(that)) continue;
            builder.addAlternate(alternate);
        }
        if (that.isUnionType()) {
            ImmutableList<JSType> thoseAlternatesWithoutStucturalTyping = that.toMaybeUnionType().alternatesWithoutStucturalTyping;
            for (int i = 0; i < thoseAlternatesWithoutStucturalTyping.size(); ++i) {
                JSType otherAlternate = (JSType)thoseAlternatesWithoutStucturalTyping.get(i);
                if (!otherAlternate.isSubtypeOf(this)) continue;
                builder.addAlternate(otherAlternate);
            }
        } else if (that.isSubtypeOf(this)) {
            builder.addAlternate(that);
        }
        if (!(result = builder.build()).isNoType()) {
            return result;
        }
        if (this.isObject() && that.isObject() && !that.isNoType()) {
            return this.getNativeType(JSTypeNative.NO_OBJECT_TYPE);
        }
        return this.getNativeType(JSTypeNative.NO_TYPE);
    }

    boolean checkUnionEquivalenceHelper(UnionType that, EquivalenceMethod eqMethod, JSType.EqCache eqCache) {
        ImmutableList<JSType> thatAlternates = that.getAlternatesWithoutStructuralTypingList();
        if (eqMethod == EquivalenceMethod.IDENTITY && this.getAlternatesWithoutStructuralTyping().size() != thatAlternates.size()) {
            return false;
        }
        for (int i = 0; i < thatAlternates.size(); ++i) {
            JSType thatAlternate = (JSType)thatAlternates.get(i);
            if (this.hasAlternate(thatAlternate, eqMethod, eqCache)) continue;
            return false;
        }
        return true;
    }

    private boolean hasAlternate(JSType type, EquivalenceMethod eqMethod, JSType.EqCache eqCache) {
        ImmutableList<JSType> alternatesWithoutStructuralTyping = this.getAlternatesWithoutStructuralTypingList();
        for (int i = 0; i < alternatesWithoutStructuralTyping.size(); ++i) {
            JSType alternate = (JSType)alternatesWithoutStructuralTyping.get(i);
            if (!alternate.checkEquivalenceHelper(type, eqMethod, eqCache)) continue;
            return true;
        }
        return false;
    }

    @Override
    public JSType.HasPropertyKind getPropertyKind(String pname, boolean autobox) {
        boolean found = false;
        boolean always = true;
        for (int i = 0; i < this.alternatesWithoutStucturalTyping.size(); ++i) {
            JSType alternate = (JSType)this.alternatesWithoutStucturalTyping.get(i);
            if (alternate.isNullType() || alternate.isVoidType()) continue;
            switch (alternate.getPropertyKind(pname, autobox)) {
                case KNOWN_PRESENT: {
                    found = true;
                    break;
                }
                case ABSENT: {
                    always = false;
                    break;
                }
                case MAYBE_PRESENT: {
                    found = true;
                    always = false;
                }
            }
            if (found && !always) break;
        }
        return found ? (always ? JSType.HasPropertyKind.KNOWN_PRESENT : JSType.HasPropertyKind.MAYBE_PRESENT) : JSType.HasPropertyKind.ABSENT;
    }

    @Override
    public int hashCode() {
        return this.hashcode;
    }

    @Override
    public UnionType toMaybeUnionType() {
        return this;
    }

    @Override
    public boolean isObject() {
        for (int i = 0; i < this.alternatesWithoutStucturalTyping.size(); ++i) {
            JSType alternate = (JSType)this.alternatesWithoutStucturalTyping.get(i);
            if (alternate.isObject()) continue;
            return false;
        }
        return true;
    }

    public boolean contains(JSType type) {
        for (int i = 0; i < this.alternatesWithoutStucturalTyping.size(); ++i) {
            JSType alt = (JSType)this.alternatesWithoutStucturalTyping.get(i);
            if (!alt.isEquivalentTo(type)) continue;
            return true;
        }
        return false;
    }

    public JSType getRestrictedUnion(JSType type) {
        UnionTypeBuilder restricted = new UnionTypeBuilder(this.registry);
        for (int i = 0; i < this.alternatesWithoutStucturalTyping.size(); ++i) {
            JSType t = (JSType)this.alternatesWithoutStucturalTyping.get(i);
            if (!t.isUnknownType() && !t.isNoResolvedType() && t.isSubtypeOf(type)) continue;
            restricted.addAlternate(t);
        }
        return restricted.build();
    }

    @Override
    StringBuilder appendTo(StringBuilder sb, boolean forAnnotations) {
        boolean firstAlternate = true;
        sb.append("(");
        TreeSet<JSType> sorted = new TreeSet<JSType>(ALPHA);
        sorted.addAll((Collection<JSType>)this.alternatesWithoutStucturalTyping);
        for (JSType t : sorted) {
            if (!firstAlternate) {
                sb.append("|");
            }
            t.appendTo(sb, forAnnotations);
            firstAlternate = false;
        }
        return sb.append(")");
    }

    @Override
    public boolean isSubtype(JSType that) {
        return this.isSubtype(that, JSType.ImplCache.create(), JSType.SubtypingMode.NORMAL);
    }

    @Override
    protected boolean isSubtype(JSType that, JSType.ImplCache implicitImplCache, JSType.SubtypingMode subtypingMode) {
        if (that.isUnknownType() || this.isUnknownType()) {
            return true;
        }
        if (that.isAllType()) {
            return true;
        }
        for (int i = 0; i < this.alternatesWithoutStucturalTyping.size(); ++i) {
            JSType element = (JSType)this.alternatesWithoutStucturalTyping.get(i);
            if (subtypingMode == JSType.SubtypingMode.IGNORE_NULL_UNDEFINED && (element.isNullType() || element.isVoidType()) || element.isSubtype(that, implicitImplCache, subtypingMode)) continue;
            return false;
        }
        return true;
    }

    @Override
    public JSType getRestrictedTypeGivenToBooleanOutcome(boolean outcome) {
        UnionTypeBuilder restricted = new UnionTypeBuilder(this.registry);
        for (int i = 0; i < this.alternatesWithoutStucturalTyping.size(); ++i) {
            JSType element = (JSType)this.alternatesWithoutStucturalTyping.get(i);
            restricted.addAlternate(element.getRestrictedTypeGivenToBooleanOutcome(outcome));
        }
        return restricted.build();
    }

    @Override
    public BooleanLiteralSet getPossibleToBooleanOutcomes() {
        JSType element;
        BooleanLiteralSet literals = BooleanLiteralSet.EMPTY;
        for (int i = 0; i < this.alternatesWithoutStucturalTyping.size() && (literals = literals.union((element = (JSType)this.alternatesWithoutStucturalTyping.get(i)).getPossibleToBooleanOutcomes())) != BooleanLiteralSet.BOTH; ++i) {
        }
        return literals;
    }

    @Override
    public JSType.TypePair getTypesUnderEquality(JSType that) {
        UnionTypeBuilder thisRestricted = new UnionTypeBuilder(this.registry);
        UnionTypeBuilder thatRestricted = new UnionTypeBuilder(this.registry);
        for (int i = 0; i < this.alternatesWithoutStucturalTyping.size(); ++i) {
            JSType element = (JSType)this.alternatesWithoutStucturalTyping.get(i);
            JSType.TypePair p = element.getTypesUnderEquality(that);
            if (p.typeA != null) {
                thisRestricted.addAlternate(p.typeA);
            }
            if (p.typeB == null) continue;
            thatRestricted.addAlternate(p.typeB);
        }
        return new JSType.TypePair(thisRestricted.build(), thatRestricted.build());
    }

    @Override
    public JSType.TypePair getTypesUnderInequality(JSType that) {
        UnionTypeBuilder thisRestricted = new UnionTypeBuilder(this.registry);
        UnionTypeBuilder thatRestricted = new UnionTypeBuilder(this.registry);
        for (int i = 0; i < this.alternatesWithoutStucturalTyping.size(); ++i) {
            JSType element = (JSType)this.alternatesWithoutStucturalTyping.get(i);
            JSType.TypePair p = element.getTypesUnderInequality(that);
            if (p.typeA != null) {
                thisRestricted.addAlternate(p.typeA);
            }
            if (p.typeB == null) continue;
            thatRestricted.addAlternate(p.typeB);
        }
        return new JSType.TypePair(thisRestricted.build(), thatRestricted.build());
    }

    @Override
    public JSType.TypePair getTypesUnderShallowInequality(JSType that) {
        UnionTypeBuilder thisRestricted = new UnionTypeBuilder(this.registry);
        UnionTypeBuilder thatRestricted = new UnionTypeBuilder(this.registry);
        for (int i = 0; i < this.alternatesWithoutStucturalTyping.size(); ++i) {
            JSType element = (JSType)this.alternatesWithoutStucturalTyping.get(i);
            JSType.TypePair p = element.getTypesUnderShallowInequality(that);
            if (p.typeA != null) {
                thisRestricted.addAlternate(p.typeA);
            }
            if (p.typeB == null) continue;
            thatRestricted.addAlternate(p.typeB);
        }
        return new JSType.TypePair(thisRestricted.build(), thatRestricted.build());
    }

    @Override
    public <T> T visit(Visitor<T> visitor) {
        return visitor.caseUnionType(this);
    }

    @Override
    <T> T visit(RelationshipVisitor<T> visitor, JSType that) {
        return visitor.caseUnionType(this, that);
    }

    @Override
    JSType resolveInternal(ErrorReporter reporter, StaticTypedScope<JSType> scope) {
        this.setResolvedTypeInternal(this);
        for (int i = 0; i < this.alternatesWithoutStucturalTyping.size(); ++i) {
            JSType alternate = (JSType)this.alternatesWithoutStucturalTyping.get(i);
            alternate.resolve(reporter, scope);
        }
        this.rebuildAlternates();
        return this;
    }

    @Override
    public String toDebugHashCodeString() {
        ArrayList<String> hashCodes = new ArrayList<String>();
        for (JSType a : this.alternatesWithoutStucturalTyping) {
            hashCodes.add(a.toDebugHashCodeString());
        }
        return "{(" + Joiner.on((String)",").join(hashCodes) + ")}";
    }

    @Override
    public boolean setValidator(Predicate<JSType> validator) {
        for (int i = 0; i < this.alternatesWithoutStucturalTyping.size(); ++i) {
            JSType a = (JSType)this.alternatesWithoutStucturalTyping.get(i);
            a.setValidator(validator);
        }
        return true;
    }

    @Override
    public JSType collapseUnion() {
        JSType currentValue = null;
        ObjectType currentCommonSuper = null;
        for (int i = 0; i < this.alternatesWithoutStucturalTyping.size(); ++i) {
            JSType a = (JSType)this.alternatesWithoutStucturalTyping.get(i);
            if (a.isUnknownType()) {
                return this.getNativeType(JSTypeNative.UNKNOWN_TYPE);
            }
            ObjectType obj = a.toObjectType();
            if (obj == null) {
                if (currentValue == null && currentCommonSuper == null) {
                    currentValue = a;
                    continue;
                }
                return this.getNativeType(JSTypeNative.ALL_TYPE);
            }
            if (currentValue != null) {
                return this.getNativeType(JSTypeNative.ALL_TYPE);
            }
            currentCommonSuper = currentCommonSuper == null ? obj : this.registry.findCommonSuperObject(currentCommonSuper, obj);
        }
        return currentCommonSuper;
    }

    @Override
    public void matchConstraint(JSType constraint) {
        for (int i = 0; i < this.alternatesWithoutStucturalTyping.size(); ++i) {
            JSType alternate = (JSType)this.alternatesWithoutStucturalTyping.get(i);
            alternate.matchConstraint(constraint);
        }
    }

    @Override
    public boolean hasAnyTemplateTypesInternal() {
        for (int i = 0; i < this.alternatesWithoutStucturalTyping.size(); ++i) {
            JSType alternate = (JSType)this.alternatesWithoutStucturalTyping.get(i);
            if (!alternate.hasAnyTemplateTypes()) continue;
            return true;
        }
        return false;
    }
}

