/*
 * Decompiled with CFR 0.152.
 */
package org.ametys.core.datasource;

import java.sql.Connection;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.Map;
import javax.sql.DataSource;
import org.ametys.core.datasource.AbstractDataSourceManager;
import org.ametys.core.datasource.SQLDataSourceManager;
import org.apache.avalon.framework.activity.Disposable;
import org.apache.avalon.framework.component.Component;
import org.apache.avalon.framework.service.ServiceException;
import org.apache.avalon.framework.service.ServiceManager;
import org.apache.avalon.framework.service.Serviceable;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class ConnectionHelper
implements Component,
Serviceable,
Disposable {
    public static final String ROLE = ConnectionHelper.class.getName();
    public static final String DATABASE_UNKNOWN = "";
    public static final String DATABASE_MYSQL = "mysql";
    public static final String DATABASE_ORACLE = "oracle";
    public static final String DATABASE_POSTGRES = "postgresql";
    public static final String DATABASE_DERBY = "derby";
    public static final String DATABASE_HSQLDB = "hsqldb";
    private static Logger _logger = LoggerFactory.getLogger((String)ConnectionHelper.class.getName());
    private static SQLDataSourceManager _sqlDataSourceManager;
    private static ServiceManager _manager;

    public void service(ServiceManager serviceManager) throws ServiceException {
        _manager = serviceManager;
    }

    public void dispose() {
        _sqlDataSourceManager = null;
    }

    private static SQLDataSourceManager getSQLDataSourceManager() {
        if (_sqlDataSourceManager == null) {
            try {
                _sqlDataSourceManager = (SQLDataSourceManager)_manager.lookup(SQLDataSourceManager.ROLE);
            }
            catch (ServiceException e) {
                throw new RuntimeException(e);
            }
        }
        return _sqlDataSourceManager;
    }

    public static Connection getInternalSQLDataSourceConnection() {
        return ConnectionHelper.getSQLDataSourceManager().getInternalSQLDataSourceConnection();
    }

    public static Connection getConnection(String id) {
        Connection connection = null;
        if (ConnectionHelper.getSQLDataSourceManager() == null) {
            throw new RuntimeException("ConnectionHelper cannot be used statically during or before components initialization");
        }
        try {
            DataSource dataSource = ConnectionHelper.getSQLDataSourceManager().getSQLDataSource(id);
            connection = dataSource.getConnection();
        }
        catch (SQLException e) {
            throw new RuntimeException("Unable to get Connection from pool " + id, e);
        }
        return connection;
    }

    public static void cleanup(Connection con) {
        if (con != null) {
            try {
                if (!con.getAutoCommit()) {
                    con.commit();
                }
            }
            catch (SQLException s) {
                _logger.error("Error while closing database", (Throwable)s);
            }
            try {
                con.close();
            }
            catch (SQLException s) {
                _logger.error("Error while closing database", (Throwable)s);
            }
        }
    }

    public static void cleanup(Statement stmt) {
        if (stmt != null) {
            try {
                stmt.close();
            }
            catch (SQLException s) {
                _logger.error("Error while closing statement", (Throwable)s);
            }
        }
    }

    public static void cleanup(ResultSet rs) {
        if (rs != null) {
            try {
                rs.close();
            }
            catch (SQLException s) {
                _logger.error("Error while closing statement", (Throwable)s);
            }
        }
    }

    public static String getDatabaseType(Connection connection) {
        try {
            return ConnectionHelper.getDatabaseType(connection.getMetaData().getURL());
        }
        catch (SQLException e) {
            LoggerFactory.getLogger(ConnectionHelper.class).error("Cannot determine database type", (Throwable)e);
            return DATABASE_UNKNOWN;
        }
    }

    public static String getDatabaseType(String jdbcURL) {
        String jdbcURLWithoutParams = StringUtils.substringBefore((String)jdbcURL, (String)";");
        Map<String, AbstractDataSourceManager.DataSourceDefinition> dataSourceDefinitions = ConnectionHelper.getSQLDataSourceManager().getDataSourceDefinitions(true, true, false);
        for (AbstractDataSourceManager.DataSourceDefinition definition : dataSourceDefinitions.values()) {
            String url = StringUtils.substringBefore((String)((String)definition.getParameters().get("url")), (String)";");
            if (!StringUtils.equals((CharSequence)url, (CharSequence)jdbcURLWithoutParams)) continue;
            return (String)definition.getParameters().get("dbtype");
        }
        return DATABASE_UNKNOWN;
    }

    public static AbstractDataSourceManager.DataSourceDefinition getDataSourceDefinition(String id) {
        return ConnectionHelper.getSQLDataSourceManager().getDataSourceDefinition(id);
    }
}

