/*
 * Decompiled with CFR 0.152.
 */
package org.ametys.core.datasource;

import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import org.ametys.core.datasource.AbstractDataSourceManager;
import org.ametys.plugins.core.impl.checker.LDAPConnectionChecker;
import org.ametys.runtime.i18n.I18nizableText;
import org.ametys.runtime.model.checker.ItemCheckerTestFailureException;
import org.ametys.runtime.util.AmetysHomeHelper;
import org.apache.avalon.framework.configuration.Configuration;
import org.apache.avalon.framework.configuration.ConfigurationException;
import org.apache.avalon.framework.configuration.DefaultConfigurationBuilder;
import org.apache.commons.collections.MapUtils;
import org.xml.sax.SAXException;

public class LDAPDataSourceManager
extends AbstractDataSourceManager {
    public static final String ROLE = LDAPDataSourceManager.class.getName();
    public static final String PARAM_BASE_URL = "baseURL";
    public static final String PARAM_BASE_DN = "baseDN";
    public static final String PARAM_USE_SSL = "useSSL";
    public static final String PARAM_ALIAS_DEREFERENCING = "aliasDereferencing";
    public static final String PARAM_FOLLOW_REFERRALS = "followReferrals";
    public static final String PARAM_AUTHENTICATION_METHOD = "authenticationMethod";
    public static final String PARAM_ADMIN_DN = "adminDN";
    public static final String PARAM_ADMIN_PASSWORD = "adminPassword";
    public static final String LDAP_DATASOURCE_PREFIX = "LDAP-";
    private static String __filename;

    public static void setFilename(String filename) {
        __filename = filename;
    }

    @Override
    public File getFileConfiguration() {
        if (__filename != null) {
            return new File(__filename);
        }
        return new File(AmetysHomeHelper.getAmetysHomeConfig(), "datasources-ldap.xml");
    }

    @Override
    protected String getDataSourcePrefixId() {
        return LDAP_DATASOURCE_PREFIX;
    }

    @Override
    protected Map<String, AbstractDataSourceManager.DataSourceDefinition> doReadConfiguration(File file) {
        HashMap<String, AbstractDataSourceManager.DataSourceDefinition> definitions = new HashMap<String, AbstractDataSourceManager.DataSourceDefinition>();
        try {
            if (file.exists()) {
                Configuration configuration = new DefaultConfigurationBuilder().buildFromFile(file);
                for (Configuration dsConfig : configuration.getChildren("datasource")) {
                    Configuration[] paramsConfig;
                    String id = dsConfig.getAttribute("id");
                    I18nizableText name = I18nizableText.parseI18nizableText(dsConfig.getChild("name"), "plugin.core");
                    I18nizableText description = I18nizableText.parseI18nizableText(dsConfig.getChild("description"), "plugin.core", "");
                    boolean isPrivate = dsConfig.getAttributeAsBoolean("private", false);
                    boolean isDefault = dsConfig.getAttributeAsBoolean("default", false);
                    HashMap<String, Object> parameters = new HashMap<String, Object>();
                    for (Configuration paramConfig : paramsConfig = dsConfig.getChild("parameters").getChildren()) {
                        String paramName = paramConfig.getName();
                        Object value = paramName.equals(PARAM_USE_SSL) || paramName.equals(PARAM_FOLLOW_REFERRALS) ? Boolean.valueOf(paramConfig.getValueAsBoolean(false)) : paramConfig.getValue("");
                        parameters.put(paramConfig.getName(), value);
                    }
                    AbstractDataSourceManager.DataSourceDefinition dataSource = new AbstractDataSourceManager.DataSourceDefinition(id, name, description, parameters, isPrivate, isDefault);
                    definitions.put(id, dataSource);
                }
            }
            return definitions;
        }
        catch (IOException | ConfigurationException | SAXException e) {
            throw new RuntimeException("Unable to parse datasource configuration file.", e);
        }
    }

    @Override
    public void checkParameters(Map<String, Object> parameters) throws ItemCheckerTestFailureException {
        ArrayList<String> values = new ArrayList<String>();
        values.add(parameters.get(PARAM_BASE_URL).toString());
        values.add(parameters.get(PARAM_AUTHENTICATION_METHOD).toString());
        values.add(parameters.get(PARAM_ADMIN_DN).toString());
        values.add(parameters.get(PARAM_ADMIN_PASSWORD).toString());
        values.add(parameters.get(PARAM_USE_SSL).toString());
        values.add(parameters.get(PARAM_FOLLOW_REFERRALS).toString());
        values.add(parameters.get(PARAM_BASE_DN).toString());
        LDAPConnectionChecker paramChecker = new LDAPConnectionChecker();
        paramChecker.check(values);
    }

    @Override
    protected void createDataSource(AbstractDataSourceManager.DataSourceDefinition dataSource) {
    }

    @Override
    protected void deleteDataSource(AbstractDataSourceManager.DataSourceDefinition dataSource) {
    }

    @Override
    protected void editDataSource(AbstractDataSourceManager.DataSourceDefinition dataSource) {
    }

    @Override
    protected void internalSetDefaultDataSource() {
        if (MapUtils.isNotEmpty((Map)this._dataSourcesDef)) {
            AbstractDataSourceManager.DataSourceDefinition defaultDataSourceDef = (AbstractDataSourceManager.DataSourceDefinition)this._dataSourcesDef.values().iterator().next();
            defaultDataSourceDef.setDefault(true);
            this._dataSourcesDef.put(defaultDataSourceDef.getId(), defaultDataSourceDef);
            this.saveConfiguration();
            this.editDataSource(defaultDataSourceDef);
        }
    }
}

