/*
 * Decompiled with CFR 0.152.
 */
package org.ametys.core.datasource;

import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.regex.Pattern;
import org.ametys.core.datasource.AbstractDataSourceManager;
import org.ametys.core.datasource.SQLDataSourceManager;
import org.ametys.runtime.i18n.I18nizableText;
import org.ametys.runtime.parameter.DefaultValidator;
import org.ametys.runtime.parameter.Errors;
import org.apache.avalon.framework.configuration.Configuration;
import org.apache.avalon.framework.configuration.ConfigurationException;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.StringUtils;

public class SQLDatabaseTypeValidator
extends DefaultValidator {
    private Set<String> _allowedDbTypes;

    @Override
    public void configure(Configuration configuration) throws ConfigurationException {
        Configuration dbtypesConfig;
        Configuration textConfig;
        this._allowedDbTypes = new HashSet<String>();
        Configuration validatorConfig = configuration.getChild("validation").getChild("custom-validator");
        this._isMandatory = validatorConfig.getChild("mandatory", false) != null;
        String regexp = validatorConfig.getChild("regexp").getValue(null);
        if (regexp != null) {
            this._regexp = Pattern.compile(regexp);
        }
        if ((textConfig = validatorConfig.getChild("invalidText", false)) != null) {
            this._invalidText = I18nizableText.parseI18nizableText(textConfig, "plugin." + this._pluginName);
        }
        if ((dbtypesConfig = validatorConfig.getChild("allowed-dbtypes", false)) != null) {
            String[] dbtypes;
            for (String dbtype : dbtypes = dbtypesConfig.getValue().split(",")) {
                CollectionUtils.addIgnoreNull(this._allowedDbTypes, (Object)StringUtils.trimToNull((String)dbtype));
            }
        }
    }

    @Override
    protected void validateSingleValue(Object value, Errors errors) {
        super.validateSingleValue(value, errors);
        if (this._allowedDbTypes.size() > 0 && value != null && value.toString().length() > 0) {
            String dataSourceId = value.toString();
            this._validateDataSource(dataSourceId, errors);
        }
    }

    @Override
    protected void validateArrayValues(Object[] values, Errors errors) {
        if (this._allowedDbTypes.size() > 0 && values != null && values.length > 0) {
            for (Object value : values) {
                String dataSourceId = value.toString();
                this._validateDataSource(dataSourceId, errors);
            }
        }
    }

    private void _validateDataSource(String dataSourceId, Errors errors) {
        if (!this._isValidDatasource(dataSourceId)) {
            if (this.getLogger().isDebugEnabled()) {
                this.getLogger().debug("The type of datasource of id '" + dataSourceId + "' is not an authorized database type.");
            }
            errors.addError(new I18nizableText("plugin.core", "PLUGINS_CORE_SQL_DATASOURCETYPE_VALIDATOR_FAILED"));
        }
    }

    private boolean _isValidDatasource(String dataSourceId) {
        Map<String, AbstractDataSourceManager.DataSourceDefinition> dsDefinitions = SQLDataSourceManager.readDataSourceDefinition(SQLDataSourceManager.getStaticFileConfiguration());
        boolean findDefault = false;
        for (AbstractDataSourceManager.DataSourceDefinition dsDefinition : dsDefinitions.values()) {
            if (!dsDefinition.isDefault()) continue;
            dsDefinitions.put("SQL-default-datasource", dsDefinition.duplicate());
            findDefault = true;
            break;
        }
        AbstractDataSourceManager.DataSourceDefinition internalDsDefinition = SQLDataSourceManager.getInternalDataSourceDefinition();
        dsDefinitions.put(internalDsDefinition.getId(), internalDsDefinition);
        if (!findDefault) {
            dsDefinitions.put("SQL-default-datasource", internalDsDefinition.duplicate());
        }
        if (dsDefinitions.containsKey(dataSourceId)) {
            String dbtype = (String)dsDefinitions.get(dataSourceId).getParameters().get("dbtype");
            return this._allowedDbTypes.contains(dbtype);
        }
        return false;
    }

    @Override
    public Map<String, Object> getConfiguration() {
        Map<String, Object> configuration = super.getConfiguration();
        configuration.put("allowedDbTypes", this._allowedDbTypes);
        return configuration;
    }
}

