/*
 * Decompiled with CFR 0.152.
 */
package org.ametys.core.devmode;

import java.util.Collections;
import java.util.List;
import java.util.Map;
import org.ametys.core.DevMode;
import org.ametys.core.ui.ClientSideElement;
import org.ametys.core.ui.ClientSideElementHelper;
import org.ametys.core.ui.SimpleMenu;
import org.ametys.runtime.i18n.I18nizableText;
import org.apache.avalon.framework.context.Context;
import org.apache.avalon.framework.context.ContextException;
import org.apache.avalon.framework.context.Contextualizable;
import org.apache.cocoon.components.ContextHelper;
import org.apache.cocoon.environment.Request;

public class DevModeClientSideElement
extends SimpleMenu
implements Contextualizable {
    private Context _context;

    public void contextualize(Context context) throws ContextException {
        this._context = context;
    }

    @Override
    public List<ClientSideElement.Script> getScripts(boolean ignoreRights, Map<String, Object> contextParameters) {
        List<ClientSideElement.Script> scripts = super.getScripts(ignoreRights, contextParameters);
        if (!scripts.isEmpty()) {
            if (scripts.size() != 1) {
                throw new IllegalStateException(this.getId() + " cannot return more than 1 script");
            }
            ClientSideElement.Script script = ClientSideElementHelper.cloneScript(scripts.get(0));
            Request request = ContextHelper.getRequest((Context)this._context);
            DevMode.DEVMODE devMode = DevMode.getDeveloperMode(request);
            boolean toggle = false;
            I18nizableText description = null;
            String decorator = null;
            switch (devMode) {
                case DEVELOPMENT: {
                    toggle = true;
                    description = new I18nizableText("plugin.core-ui", "PLUGINS_CORE_UI_TOOLS_DEVMODE_DEVELOPMENT_MODE_DESCRIPTION");
                    break;
                }
                case SUPER_DEVELOPPMENT: {
                    toggle = true;
                    description = new I18nizableText("plugin.core-ui", "PLUGINS_CORE_UI_TOOLS_DEVMODE_SUPER_DEV_MODE_DESCRIPTION");
                    decorator = "decorator-ametysicon-bugs3";
                    break;
                }
                default: {
                    description = new I18nizableText("plugin.core-ui", "PLUGINS_CORE_UI_TOOLS_DEVMODE_PRODUCTION_MODE_DESCRIPTION");
                }
            }
            Map<String, Object> parameters = script.getParameters();
            parameters.put("description", description);
            parameters.put("toggle-state", toggle);
            if (decorator != null) {
                parameters.put("icon-decorator", decorator);
            }
            return Collections.singletonList(script);
        }
        return scripts;
    }
}

