/*
 * Decompiled with CFR 0.152.
 */
package org.ametys.core.group;

import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;
import org.ametys.core.datasource.ConnectionHelper;
import org.ametys.core.group.GroupDirectoryDAO;
import org.ametys.core.ui.Callable;
import org.ametys.runtime.config.Config;
import org.ametys.runtime.plugin.component.AbstractLogEnabled;
import org.apache.avalon.framework.component.Component;
import org.apache.avalon.framework.service.ServiceException;
import org.apache.avalon.framework.service.ServiceManager;
import org.apache.avalon.framework.service.Serviceable;

public class GroupDirectoryContextHelper
extends AbstractLogEnabled
implements Component,
Serviceable {
    public static final String ROLE = GroupDirectoryContextHelper.class.getName();
    public static final String ADMIN_CONTEXT = "/admin";
    private static final String __GROUP_DIRECTORIES_TABLE = "GroupDirectoriesByContext";
    private GroupDirectoryDAO _groupDirectoryDAO;

    public void service(ServiceManager manager) throws ServiceException {
        this._groupDirectoryDAO = (GroupDirectoryDAO)manager.lookup(GroupDirectoryDAO.ROLE);
    }

    protected Connection getSQLConnection() {
        String datasourceId = (String)Config.getInstance().getValue("runtime.assignments.groups");
        return ConnectionHelper.getConnection(datasourceId);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Callable
    public List<String> link(String context, List<String> ids) {
        ArrayList<String> result = new ArrayList<String>();
        result.addAll(this.getGroupDirectoriesOnContext(context));
        Connection connection = null;
        PreparedStatement stmt = null;
        try {
            connection = this.getSQLConnection();
            String sql = "DELETE FROM GroupDirectoriesByContext WHERE Context=?";
            stmt = connection.prepareStatement(sql);
            stmt.setString(1, context);
            stmt.executeUpdate();
            this.getLogger().info("{}\n[{}]", (Object)sql, (Object)context);
            sql = "INSERT INTO GroupDirectoriesByContext (Context, GroupDirectory_Id) VALUES(?, ?)";
            stmt = connection.prepareStatement(sql);
            for (String id : ids) {
                if (this._groupDirectoryDAO.getGroupDirectory(id) != null) {
                    stmt.setString(1, context);
                    stmt.setString(2, id);
                    stmt.executeUpdate();
                    this.getLogger().info("{}\n[{}, {}]", new Object[]{sql, context, id});
                    if (result.contains(id)) {
                        result.remove(id);
                        continue;
                    }
                    result.add(id);
                    continue;
                }
                this.getLogger().warn("The GroupDirectory with id '{}' does not exist. It will not be linked.", (Object)id);
            }
        }
        catch (SQLException e) {
            try {
                this.getLogger().error("Error in sql query", (Throwable)e);
            }
            catch (Throwable throwable) {
                ConnectionHelper.cleanup(connection);
                ConnectionHelper.cleanup(stmt);
                throw throwable;
            }
            ConnectionHelper.cleanup(connection);
            ConnectionHelper.cleanup(stmt);
        }
        ConnectionHelper.cleanup(connection);
        ConnectionHelper.cleanup(stmt);
        return result;
    }

    @Callable
    public Set<String> getGroupDirectoriesOnContext(String context) {
        if (ADMIN_CONTEXT.equals(context)) {
            return this._groupDirectoryDAO.getGroupDirectoriesIds();
        }
        return this._getDirectorieOnContextFromDatabase(context);
    }

    @Callable
    public Set<String> getGroupDirectoriesOnContexts(Set<String> contexts) {
        return contexts.stream().map(this::getGroupDirectoriesOnContext).flatMap(Collection::stream).collect(Collectors.toSet());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Set<String> _getDirectorieOnContextFromDatabase(String context) {
        HashSet<String> result = new HashSet<String>();
        Connection connection = null;
        PreparedStatement stmt = null;
        ResultSet rs = null;
        try {
            connection = this.getSQLConnection();
            String sql = "SELECT Context, GroupDirectory_Id FROM GroupDirectoriesByContext WHERE Context=?";
            stmt = connection.prepareStatement(sql);
            stmt.setString(1, context);
            rs = stmt.executeQuery();
            this.getLogger().info("{}\n[{}]", (Object)sql, (Object)context);
            while (rs.next()) {
                String groupDirectoryId = rs.getString(2);
                if (this._groupDirectoryDAO.getGroupDirectory(groupDirectoryId) == null) continue;
                result.add(groupDirectoryId);
            }
        }
        catch (SQLException e) {
            try {
                this.getLogger().error("Error in sql query", (Throwable)e);
            }
            catch (Throwable throwable) {
                ConnectionHelper.cleanup(connection);
                ConnectionHelper.cleanup(stmt);
                ConnectionHelper.cleanup(rs);
                throw throwable;
            }
            ConnectionHelper.cleanup(connection);
            ConnectionHelper.cleanup(stmt);
            ConnectionHelper.cleanup(rs);
        }
        ConnectionHelper.cleanup(connection);
        ConnectionHelper.cleanup(stmt);
        ConnectionHelper.cleanup(rs);
        return result;
    }
}

