/*
 * Decompiled with CFR 0.152.
 */
package org.ametys.core.model.type;

import java.util.List;
import org.ametys.core.model.type.AbstractElementType;
import org.ametys.runtime.model.BadItemTypeException;
import org.apache.commons.lang3.StringUtils;

public abstract class AbstractBooleanElementType
extends AbstractElementType<Boolean> {
    public static final String TYPE_ID = "boolean";

    @Override
    public Boolean castValue(String value) throws BadItemTypeException {
        if (StringUtils.isEmpty((CharSequence)value)) {
            return null;
        }
        return Boolean.valueOf(value);
    }

    @Override
    public Object fromJSONForClient(Object json) {
        if (json == null || json instanceof Boolean) {
            return json;
        }
        if (json instanceof List) {
            List jsonList = (List)json;
            return jsonList.toArray(new Boolean[jsonList.size()]);
        }
        throw new IllegalArgumentException("Try to convert the non Boolean JSON object '" + json + "' into a Boolean");
    }

    @Override
    public boolean isSimple() {
        return true;
    }
}

