/*
 * Decompiled with CFR 0.152.
 */
package org.ametys.core.resources;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.ametys.core.resources.AbstractResourceHandler;
import org.ametys.core.util.ImageHelper;
import org.apache.avalon.framework.component.Component;
import org.apache.avalon.framework.parameters.Parameters;
import org.apache.cocoon.ProcessingException;
import org.apache.cocoon.ResourceNotFoundException;
import org.apache.commons.lang.StringUtils;
import org.apache.excalibur.source.Source;
import org.apache.excalibur.source.SourceException;

public class ImageResourceHandler
extends AbstractResourceHandler
implements Component {
    private static final Pattern _SIZE_PATTERN = Pattern.compile("^(.*)(?:_(max)?([0-9]+)x([0-9]+))(\\.[^./]+)$");
    private static final Collection<String> __ALLOWED_FORMATS = Arrays.asList("png", "gif", "jpg", "jpeg");

    @Override
    public Source setup(String location, Map objectModel, Parameters par, Map<String, Object> additionalParameters) throws IOException, ProcessingException {
        Source source = null;
        try {
            source = this._resolver.resolveURI(location);
        }
        catch (SourceException sourceException) {
            // empty catch block
        }
        if (source == null || !source.exists()) {
            Matcher sizeMatcher = _SIZE_PATTERN.matcher(location);
            if (sizeMatcher.matches()) {
                String computedLocation = sizeMatcher.group(1) + sizeMatcher.group(5);
                source = this._resolver.resolveURI(computedLocation);
                if (!source.exists()) {
                    throw new ResourceNotFoundException("Resource not found for URI : " + source.getURI());
                }
                boolean isMaxSize = sizeMatcher.group(2) != null;
                String height = sizeMatcher.group(3);
                String width = sizeMatcher.group(4);
                additionalParameters.put("height", isMaxSize ? 0 : Integer.parseInt(height));
                additionalParameters.put("width", isMaxSize ? 0 : Integer.parseInt(width));
                additionalParameters.put("maxHeight", isMaxSize ? Integer.parseInt(height) : 0);
                additionalParameters.put("maxWidth", isMaxSize ? Integer.parseInt(width) : 0);
            } else {
                throw new ResourceNotFoundException("Resource not found for URI : " + location);
            }
        }
        return source;
    }

    @Override
    public void generateResource(Source source, OutputStream out, Map objectModel, Parameters parameters, Map<String, Object> additionalParameters) throws IOException, ProcessingException {
        String format = StringUtils.substringAfterLast((String)source.getURI(), (String)".").toLowerCase();
        format = __ALLOWED_FORMATS.contains(format) ? format : "png";
        int width = (Integer)additionalParameters.getOrDefault("width", 0);
        int height = (Integer)additionalParameters.getOrDefault("height", 0);
        int maxWidth = (Integer)additionalParameters.getOrDefault("maxWidth", 0);
        int maxHeight = (Integer)additionalParameters.getOrDefault("maxHeight", 0);
        try (InputStream is = source.getInputStream();){
            ImageHelper.generateThumbnail(is, out, format, height, width, maxHeight, maxWidth);
        }
    }

    @Override
    public Serializable getKey(Source source, Map objectModel, Parameters parameters, Map<String, Object> additionalParameters) {
        int width = parameters.getParameterAsInteger("width", 0);
        int height = parameters.getParameterAsInteger("height", 0);
        int maxWidth = parameters.getParameterAsInteger("maxWidth", 0);
        int maxHeight = parameters.getParameterAsInteger("maxHeight", 0);
        return source.getURI() + "###" + width + "x" + height + "x" + maxWidth + "x" + maxHeight;
    }
}

