/*
 * Decompiled with CFR 0.152.
 */
package org.ametys.core.right;

import java.util.Collections;
import java.util.HashSet;
import java.util.Set;
import java.util.stream.Collectors;
import org.ametys.core.group.Group;
import org.ametys.core.group.GroupIdentity;
import org.ametys.core.group.GroupManager;
import org.ametys.core.user.User;
import org.ametys.core.user.UserIdentity;
import org.ametys.core.user.UserManager;
import org.apache.commons.collections4.CollectionUtils;

public class AllowedUsers {
    private boolean _anonymousAllowed;
    private boolean _anyConnectedUserAllowed;
    private Set<UserIdentity> _allowedUsers;
    private Set<UserIdentity> _deniedUsers;
    private Set<GroupIdentity> _allowedGroups;
    private Set<GroupIdentity> _deniedGroups;
    private UserManager _userManager;
    private Set<String> _populationContexts;
    private GroupManager _groupManager;

    AllowedUsers(boolean anonymousAllowed, boolean anyConnectedUserAllowed, Set<UserIdentity> allowedUsers, Set<UserIdentity> deniedUsers, Set<GroupIdentity> allowedGroups, Set<GroupIdentity> deniedGroups, UserManager userManager, GroupManager groupManager, Set<String> populationContexts) {
        this._anonymousAllowed = anonymousAllowed;
        this._anyConnectedUserAllowed = anyConnectedUserAllowed;
        this._allowedUsers = allowedUsers;
        this._deniedUsers = deniedUsers;
        this._allowedGroups = allowedGroups;
        this._deniedGroups = deniedGroups;
        this._userManager = userManager;
        this._groupManager = groupManager;
        this._populationContexts = populationContexts;
    }

    public boolean isAnonymousAllowed() {
        return this._anonymousAllowed;
    }

    public boolean isAnyConnectedUserAllowed() {
        return !this._anonymousAllowed && this._anyConnectedUserAllowed;
    }

    public Set<UserIdentity> getAllowedUsers() {
        return this._allowedUsers;
    }

    public Set<UserIdentity> getDeniedUsers() {
        return this._deniedUsers;
    }

    public Set<GroupIdentity> getAllowedGroups() {
        return this._allowedGroups;
    }

    public Set<GroupIdentity> getDeniedGroups() {
        return this._deniedGroups;
    }

    public Set<UserIdentity> resolveAllowedUsers(boolean returnAll) {
        Set<UserIdentity> groupUsers;
        Group group;
        if (this._anonymousAllowed || this._anyConnectedUserAllowed && !returnAll) {
            return Collections.EMPTY_SET;
        }
        if (this._anyConnectedUserAllowed) {
            Set allowedUsers = this._userManager.getUsersByContext(this._populationContexts, false).stream().map(User::getIdentity).collect(Collectors.toSet());
            HashSet<UserIdentity> resolvedDeniedUsers = new HashSet<UserIdentity>();
            resolvedDeniedUsers.addAll(this._deniedUsers);
            for (GroupIdentity deniedGroup : this._deniedGroups) {
                Set<UserIdentity> groupUsers2 = this._groupManager.getGroup(deniedGroup).getUsers();
                for (UserIdentity groupUser : groupUsers2) {
                    if (this._allowedUsers.contains(groupUser)) continue;
                    resolvedDeniedUsers.add(groupUser);
                }
            }
            return new HashSet<UserIdentity>(CollectionUtils.removeAll(allowedUsers, resolvedDeniedUsers));
        }
        HashSet<UserIdentity> resolvedAllowedUsers = new HashSet<UserIdentity>();
        for (GroupIdentity allowedGroup : this._allowedGroups) {
            group = this._groupManager.getGroup(allowedGroup);
            if (group == null) continue;
            groupUsers = group.getUsers();
            resolvedAllowedUsers.addAll(groupUsers);
        }
        for (GroupIdentity deniedGroup : this._deniedGroups) {
            group = this._groupManager.getGroup(deniedGroup);
            if (group == null) continue;
            groupUsers = group.getUsers();
            resolvedAllowedUsers.removeAll(groupUsers);
        }
        resolvedAllowedUsers.addAll(this._allowedUsers);
        resolvedAllowedUsers.removeAll(this._deniedUsers);
        return resolvedAllowedUsers;
    }
}

