/*
 * Decompiled with CFR 0.152.
 */
package org.ametys.core.right;

import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;
import org.ametys.core.group.GroupIdentity;
import org.ametys.core.right.AccessController;
import org.ametys.core.right.ModifiableProfileAssignmentStorage;
import org.ametys.core.right.ProfileAssignmentStorage;
import org.ametys.core.user.UserIdentity;
import org.ametys.runtime.plugin.component.AbstractThreadSafeComponentExtensionPoint;
import org.apache.commons.collections.CollectionUtils;

public class ProfileAssignmentStorageExtensionPoint
extends AbstractThreadSafeComponentExtensionPoint<ProfileAssignmentStorage> {
    public static final String ROLE = ProfileAssignmentStorageExtensionPoint.class.getName();

    public Map<String, AccessController.AccessResult> getPermissions(UserIdentity user, Set<GroupIdentity> userGroups, Set<String> profileIds, Object object) {
        this.getLogger().debug("Try to determine permissions for user '{}' and groups {} on context {} for profiles [{}]", new Object[]{user, userGroups, object, profileIds});
        HashMap<String, AccessController.AccessResult> results = new HashMap<String, AccessController.AccessResult>();
        Collection<String> unknownProfiles = new HashSet<String>(profileIds);
        this._fillAllowedProfilesForAnonymous(results, user, userGroups, unknownProfiles, object);
        if (results.size() == profileIds.size()) {
            return results;
        }
        unknownProfiles = CollectionUtils.removeAll(unknownProfiles, results.keySet());
        this._fillDeniedProfilesForUser(results, user, userGroups, unknownProfiles, object);
        if (results.size() == profileIds.size()) {
            return results;
        }
        unknownProfiles = CollectionUtils.removeAll(unknownProfiles, results.keySet());
        this._fillAllowedProfilesForUser(results, user, userGroups, unknownProfiles, object);
        if (results.size() == profileIds.size()) {
            return results;
        }
        unknownProfiles = CollectionUtils.removeAll(unknownProfiles, results.keySet());
        this._fillDeniedProfilesForGroups(results, user, userGroups, unknownProfiles, object);
        if (results.size() == profileIds.size()) {
            return results;
        }
        unknownProfiles = CollectionUtils.removeAll(unknownProfiles, results.keySet());
        this._fillAllowedProfilesForGroups(results, user, userGroups, unknownProfiles, object);
        if (results.size() == profileIds.size()) {
            return results;
        }
        unknownProfiles = CollectionUtils.removeAll(unknownProfiles, results.keySet());
        this._fillDeniedProfilesAnyConnectedUser(results, user, userGroups, unknownProfiles, object);
        if (results.size() == profileIds.size()) {
            return results;
        }
        unknownProfiles = CollectionUtils.removeAll(unknownProfiles, results.keySet());
        this._fillAllowedProfilesAnyConnectedUser(results, user, userGroups, unknownProfiles, object);
        if (results.size() == profileIds.size()) {
            return results;
        }
        unknownProfiles = CollectionUtils.removeAll(unknownProfiles, results.keySet());
        this._fillDeniedProfilesForAnonymous(results, user, userGroups, unknownProfiles, object);
        if (results.size() == profileIds.size()) {
            return results;
        }
        unknownProfiles = CollectionUtils.removeAll(unknownProfiles, results.keySet());
        for (String profileId : CollectionUtils.removeAll(profileIds, results.keySet())) {
            this._logResult(user, userGroups, profileId, object, AccessController.AccessResult.UNKNOWN);
            results.put(profileId, AccessController.AccessResult.UNKNOWN);
        }
        return results;
    }

    private void _fillAllowedProfilesForAnonymous(Map<String, AccessController.AccessResult> results, UserIdentity user, Set<GroupIdentity> userGroups, Collection<String> profileIds, Object object) {
        Set<String> allowedProfilesForAnonymous = this.getAllowedProfilesForAnonymous(object);
        for (String profileId : CollectionUtils.retainAll(profileIds, allowedProfilesForAnonymous)) {
            if (results.containsKey(profileId)) continue;
            this._logResult(user, userGroups, profileId, object, AccessController.AccessResult.ANONYMOUS_ALLOWED);
            results.put(profileId, AccessController.AccessResult.ANONYMOUS_ALLOWED);
        }
    }

    private void _fillDeniedProfilesForAnonymous(Map<String, AccessController.AccessResult> results, UserIdentity user, Set<GroupIdentity> userGroups, Collection<String> profileIds, Object object) {
        Set<String> deniedProfilesForAnonymous = this.getDeniedProfilesForAnonymous(object);
        for (String profileId : CollectionUtils.retainAll(profileIds, deniedProfilesForAnonymous)) {
            if (results.containsKey(profileId)) continue;
            this._logResult(user, userGroups, profileId, object, AccessController.AccessResult.ANONYMOUS_DENIED);
            results.put(profileId, AccessController.AccessResult.ANONYMOUS_DENIED);
        }
    }

    private void _fillDeniedProfilesForUser(Map<String, AccessController.AccessResult> results, UserIdentity user, Set<GroupIdentity> userGroups, Collection<String> profileIds, Object object) {
        Set<String> deniedProfilesForUser = this.getDeniedProfilesForUser(object, user);
        for (String profileId : CollectionUtils.retainAll(profileIds, deniedProfilesForUser)) {
            if (results.containsKey(profileId)) continue;
            this._logResult(user, userGroups, profileId, object, AccessController.AccessResult.USER_DENIED);
            results.put(profileId, AccessController.AccessResult.USER_DENIED);
        }
    }

    private void _fillAllowedProfilesForUser(Map<String, AccessController.AccessResult> results, UserIdentity user, Set<GroupIdentity> userGroups, Collection<String> profileIds, Object object) {
        Set<String> allowedProfilesForUser = this.getAllowedProfilesForUser(object, user);
        for (String profileId : CollectionUtils.retainAll(profileIds, allowedProfilesForUser)) {
            if (results.containsKey(profileId)) continue;
            this._logResult(user, userGroups, profileId, object, AccessController.AccessResult.USER_ALLOWED);
            results.put(profileId, AccessController.AccessResult.USER_ALLOWED);
        }
    }

    private void _fillDeniedProfilesAnyConnectedUser(Map<String, AccessController.AccessResult> results, UserIdentity user, Set<GroupIdentity> userGroups, Collection<String> profileIds, Object object) {
        Set<String> deniedProfilesForAnyConnectedUser = this.getDeniedProfilesForAnyConnectedUser(object);
        for (String profileId : CollectionUtils.retainAll(profileIds, deniedProfilesForAnyConnectedUser)) {
            if (results.containsKey(profileId)) continue;
            this._logResult(user, userGroups, profileId, object, AccessController.AccessResult.ANY_CONNECTED_DENIED);
            results.put(profileId, AccessController.AccessResult.ANY_CONNECTED_DENIED);
        }
    }

    private void _fillAllowedProfilesAnyConnectedUser(Map<String, AccessController.AccessResult> results, UserIdentity user, Set<GroupIdentity> userGroups, Collection<String> profileIds, Object object) {
        Set<String> allowedProfilesForAnyConnectedUser = this.getAllowedProfilesForAnyConnectedUser(object);
        for (String profileId : CollectionUtils.retainAll(profileIds, allowedProfilesForAnyConnectedUser)) {
            if (results.containsKey(profileId)) continue;
            this._logResult(user, userGroups, profileId, object, AccessController.AccessResult.ANY_CONNECTED_ALLOWED);
            results.put(profileId, AccessController.AccessResult.ANY_CONNECTED_ALLOWED);
        }
    }

    private void _fillDeniedProfilesForGroups(Map<String, AccessController.AccessResult> results, UserIdentity user, Set<GroupIdentity> userGroups, Collection<String> profileIds, Object object) {
        HashMap deniedGroups = new HashMap();
        for (GroupIdentity userGroup : userGroups) {
            Set<String> deniedProfilesForGroup = this.getDeniedProfilesForGroup(object, userGroup);
            for (String profileId : CollectionUtils.retainAll(profileIds, deniedProfilesForGroup)) {
                if (results.containsKey(profileId)) continue;
                if (!deniedGroups.containsKey(profileId)) {
                    deniedGroups.put(profileId, new HashSet());
                }
                ((Set)deniedGroups.get(profileId)).add(userGroup);
            }
        }
        if (deniedGroups.size() > 0) {
            for (String profileId : deniedGroups.keySet()) {
                this._logResult(user, userGroups, profileId, object, AccessController.AccessResult.GROUP_DENIED);
                results.put(profileId, AccessController.AccessResult.GROUP_DENIED);
            }
        }
    }

    private void _fillAllowedProfilesForGroups(Map<String, AccessController.AccessResult> results, UserIdentity user, Set<GroupIdentity> userGroups, Collection<String> profileIds, Object object) {
        HashMap allowedGroups = new HashMap();
        for (GroupIdentity userGroup : userGroups) {
            Set<String> allowedProfilesForGroup = this.getAllowedProfilesForGroup(object, userGroup);
            for (String profileId : CollectionUtils.retainAll(profileIds, allowedProfilesForGroup)) {
                if (results.containsKey(profileId)) continue;
                if (!allowedGroups.containsKey(profileId)) {
                    allowedGroups.put(profileId, new HashSet());
                }
                ((Set)allowedGroups.get(profileId)).add(userGroup);
            }
        }
        if (allowedGroups.size() > 0) {
            for (String profileId : allowedGroups.keySet()) {
                this._logResult(user, userGroups, profileId, object, AccessController.AccessResult.GROUP_ALLOWED);
                results.put(profileId, AccessController.AccessResult.GROUP_ALLOWED);
            }
        }
    }

    private void _logResult(UserIdentity user, Set<GroupIdentity> userGroups, String profileId, Object object, AccessController.AccessResult result) {
        this.getLogger().debug("Access result found is {} for user '{}' and groups {} on context {} with the single profile '{}'", new Object[]{result, user, userGroups, object, profileId});
    }

    public boolean hasUserAnyPermission(Set<? extends Object> rootContexts, UserIdentity user, Set<GroupIdentity> userGroups, Set<String> profileIds) {
        this.getLogger().debug("Try to determine permissions on any context for user '{}' and groups {} with profiles {}", new Object[]{user, userGroups, profileIds});
        List sortedPas = this.getExtensionsIds().stream().map(this::getExtension).sorted(Comparator.comparing(ProfileAssignmentStorage::getPriority)).collect(Collectors.toList());
        HashSet<? extends Object> remainingRootsToTest = new HashSet<Object>(rootContexts);
        for (ProfileAssignmentStorage profileAssignmentStorage : sortedPas) {
            if (remainingRootsToTest.isEmpty()) continue;
            Set filteredContexts = remainingRootsToTest.stream().filter(profileAssignmentStorage::isRootContextSupported).collect(Collectors.toSet());
            if (!filteredContexts.isEmpty() && this._hasUserAnyPermission(profileAssignmentStorage, filteredContexts, user, userGroups, profileIds)) {
                this.getLogger().debug("Find permission on any context for user '{}' and groups {} with profiles {}", new Object[]{user, userGroups, profileIds});
                return true;
            }
            remainingRootsToTest.removeAll(filteredContexts);
        }
        this.getLogger().debug("Find no permission on any context for user '{}' and groups {} with profiles {}", new Object[]{user, userGroups, profileIds});
        return false;
    }

    private boolean _hasUserAnyPermission(ProfileAssignmentStorage profileAssignmentStorage, Set<? extends Object> rootContexts, UserIdentity user, Set<GroupIdentity> userGroups, Set<String> profileIds) {
        if (profileIds.isEmpty() || rootContexts.isEmpty()) {
            return false;
        }
        if (profileAssignmentStorage.hasAnonymousAllowedProfile(rootContexts, profileIds)) {
            return true;
        }
        if (profileAssignmentStorage.hasUserAllowedProfile(rootContexts, user, profileIds)) {
            return true;
        }
        for (GroupIdentity group : userGroups) {
            if (!profileAssignmentStorage.hasGroupAllowedProfile(rootContexts, group, profileIds)) continue;
            return true;
        }
        return profileAssignmentStorage.hasAnyConnectedAllowedProfile(rootContexts, profileIds);
    }

    public boolean hasAnonymousAnyPermission(Set<? extends Object> rootContexts, Set<String> profileIds) {
        this.getLogger().debug("Try to determine permissions on any context for anonymous with profiles {}", profileIds);
        List sortedPas = this.getExtensionsIds().stream().map(this::getExtension).sorted(Comparator.comparing(ProfileAssignmentStorage::getPriority)).collect(Collectors.toList());
        HashSet<? extends Object> remainingRootsToTest = new HashSet<Object>(rootContexts);
        for (ProfileAssignmentStorage profileAssignmentStorage : sortedPas) {
            if (remainingRootsToTest.isEmpty()) continue;
            Set filteredContexts = remainingRootsToTest.stream().filter(profileAssignmentStorage::isRootContextSupported).collect(Collectors.toSet());
            if (!filteredContexts.isEmpty() && this._hasAnonymousAnyPermission(profileAssignmentStorage, filteredContexts, profileIds)) {
                this.getLogger().debug("Find permission on any context for anonymous with profiles {}", profileIds);
                return true;
            }
            remainingRootsToTest.removeAll(filteredContexts);
        }
        this.getLogger().debug("Find no permission on any context for anonymous with profiles {}", profileIds);
        return false;
    }

    private boolean _hasAnonymousAnyPermission(ProfileAssignmentStorage profileAssignmentStorage, Set<? extends Object> rootContexts, Set<String> profileIds) {
        if (profileIds.isEmpty() || rootContexts.isEmpty()) {
            return false;
        }
        return profileAssignmentStorage.hasAnonymousAllowedProfile(rootContexts, profileIds);
    }

    public boolean hasAnyConnectedUserAnyPermission(Set<? extends Object> rootContexts, Set<String> profileIds) {
        this.getLogger().debug("Try to determine permissions on any context for any connected user with profiles {}", profileIds);
        List sortedPas = this.getExtensionsIds().stream().map(this::getExtension).sorted(Comparator.comparing(ProfileAssignmentStorage::getPriority)).collect(Collectors.toList());
        HashSet<? extends Object> remainingRootsToTest = new HashSet<Object>(rootContexts);
        for (ProfileAssignmentStorage profileAssignmentStorage : sortedPas) {
            if (remainingRootsToTest.isEmpty()) continue;
            Set filteredContexts = remainingRootsToTest.stream().filter(profileAssignmentStorage::isRootContextSupported).collect(Collectors.toSet());
            if (!filteredContexts.isEmpty() && this._hasAnyConnectedUserAnyPermission(profileAssignmentStorage, filteredContexts, profileIds)) {
                this.getLogger().debug("Find permission on any context for any connected user with profiles {}", profileIds);
                return true;
            }
            remainingRootsToTest.removeAll(filteredContexts);
        }
        this.getLogger().debug("Find no permission on any context for any connected user with profiles {}", profileIds);
        return false;
    }

    private boolean _hasAnyConnectedUserAnyPermission(ProfileAssignmentStorage profileAssignmentStorage, Set<? extends Object> rootContexts, Set<String> profileIds) {
        if (profileIds.isEmpty() || rootContexts.isEmpty()) {
            return false;
        }
        if (profileAssignmentStorage.hasAnonymousAllowedProfile(rootContexts, profileIds)) {
            return true;
        }
        return profileAssignmentStorage.hasAnyConnectedAllowedProfile(rootContexts, profileIds);
    }

    public Map<String, AccessController.AccessResult> getPermissionsByProfile(UserIdentity user, Set<GroupIdentity> userGroups, Object object) {
        this.getLogger().debug("Try to determine permissions for each profile on context {} for user '{}' and groups {}", new Object[]{object, user, userGroups});
        HashMap<String, AccessController.AccessResult> result = new HashMap<String, AccessController.AccessResult>();
        Set<String> allowedProfilesForAnonymous = this.getAllowedProfilesForAnonymous(object);
        this._updatePermissionsMap(result, allowedProfilesForAnonymous, AccessController.AccessResult.ANONYMOUS_ALLOWED);
        Set<String> deniedProfilesForUser = this.getDeniedProfilesForUser(object, user);
        this._updatePermissionsMap(result, deniedProfilesForUser, AccessController.AccessResult.USER_DENIED);
        Set<String> allowedProfilesForUser = this.getAllowedProfilesForUser(object, user);
        this._updatePermissionsMap(result, allowedProfilesForUser, AccessController.AccessResult.USER_ALLOWED);
        for (GroupIdentity group : userGroups) {
            Set<String> deniedProfilesForGroup = this.getDeniedProfilesForGroup(object, group);
            this._updatePermissionsMap(result, deniedProfilesForGroup, AccessController.AccessResult.GROUP_DENIED);
        }
        for (GroupIdentity group : userGroups) {
            Set<String> allowedProfilesForGroup = this.getAllowedProfilesForGroup(object, group);
            this._updatePermissionsMap(result, allowedProfilesForGroup, AccessController.AccessResult.GROUP_ALLOWED);
        }
        Set<String> deniedProfilesForAnyConnectedUser = this.getDeniedProfilesForAnyConnectedUser(object);
        this._updatePermissionsMap(result, deniedProfilesForAnyConnectedUser, AccessController.AccessResult.ANY_CONNECTED_DENIED);
        Set<String> allowedProfilesForAnyConnectedUser = this.getAllowedProfilesForAnyConnectedUser(object);
        this._updatePermissionsMap(result, allowedProfilesForAnyConnectedUser, AccessController.AccessResult.ANY_CONNECTED_ALLOWED);
        Set<String> deniedProfilesForAnonymous = this.getDeniedProfilesForAnonymous(object);
        this._updatePermissionsMap(result, deniedProfilesForAnonymous, AccessController.AccessResult.ANONYMOUS_DENIED);
        this.getLogger().debug("The permissions by profile on context {} for user '{}' and groups {} are : {}", new Object[]{object, user, userGroups, result});
        return result;
    }

    private void _updatePermissionsMap(Map<String, AccessController.AccessResult> permissionsMap, Set<String> keys, AccessController.AccessResult value) {
        for (String key : keys) {
            if (permissionsMap.containsKey(key)) continue;
            permissionsMap.put(key, value);
        }
    }

    public AccessController.AccessResult getPermissionForAnonymous(Set<String> profileIds, Object object) {
        this.getLogger().debug("Try to determine permission for Anonymous on context {} and profiles {}", object, profileIds);
        AccessController.AccessResult result = AccessController.AccessResult.UNKNOWN;
        for (String profileId : profileIds) {
            Set<String> allowedProfiles = this.getAllowedProfilesForAnonymous(object);
            Set<String> deniedProfiles = this.getDeniedProfilesForAnonymous(object);
            if (deniedProfiles.contains(profileId)) {
                return AccessController.AccessResult.ANONYMOUS_DENIED;
            }
            if (!allowedProfiles.contains(profileId)) continue;
            result = AccessController.AccessResult.ANONYMOUS_ALLOWED;
        }
        return result;
    }

    public AccessController.AccessResult getPermissionForAnyConnectedUser(Set<String> profileIds, Object object) {
        this.getLogger().debug("Try to determine permission for AnyConnectedUser on context {} and profiles {}", object, profileIds);
        AccessController.AccessResult result = AccessController.AccessResult.UNKNOWN;
        for (String profileId : profileIds) {
            Set<String> allowedProfiles = this.getAllowedProfilesForAnyConnectedUser(object);
            Set<String> deniedProfiles = this.getDeniedProfilesForAnyConnectedUser(object);
            if (deniedProfiles.contains(profileId)) {
                return AccessController.AccessResult.ANY_CONNECTED_DENIED;
            }
            if (!allowedProfiles.contains(profileId)) continue;
            result = AccessController.AccessResult.ANY_CONNECTED_ALLOWED;
        }
        return result;
    }

    public Map<UserIdentity, AccessController.AccessResult> getPermissionsByUser(Set<String> profileIds, Object object) {
        this.getLogger().debug("Try to determine permissions by users on context {} and profiles {}", object, profileIds);
        HashMap<UserIdentity, AccessController.AccessResult> result = new HashMap<UserIdentity, AccessController.AccessResult>();
        for (String profileId : profileIds) {
            for (UserIdentity user : this.getAllowedUsers(object, profileId)) {
                if (result.containsKey(user)) continue;
                result.put(user, AccessController.AccessResult.USER_ALLOWED);
            }
            for (UserIdentity user : this.getDeniedUsers(object, profileId)) {
                result.put(user, AccessController.AccessResult.USER_DENIED);
            }
        }
        this.getLogger().debug("The permissions by users on context {} and profiles {} are: {}", new Object[]{object, profileIds, result});
        return result;
    }

    public Map<GroupIdentity, AccessController.AccessResult> getPermissionsByGroup(Set<String> profileIds, Object object) {
        this.getLogger().debug("Try to determine permissions by groups on context {} and profiles {}", object, profileIds);
        HashMap<GroupIdentity, AccessController.AccessResult> result = new HashMap<GroupIdentity, AccessController.AccessResult>();
        for (String profileId : profileIds) {
            for (GroupIdentity group : this.getAllowedGroups(object, profileId)) {
                if (result.containsKey(group)) continue;
                result.put(group, AccessController.AccessResult.GROUP_ALLOWED);
            }
            for (GroupIdentity group : this.getDeniedGroups(object, profileId)) {
                result.put(group, AccessController.AccessResult.GROUP_DENIED);
            }
        }
        this.getLogger().debug("The permissions by groups on context {} and profiles {} are: ", new Object[]{object, profileIds, result});
        return result;
    }

    public Set<String> getAllowedProfilesForAnyConnectedUser(Object context) {
        return this._getFirstProfileAssignmentStorage(context).map(pas -> pas.getAllowedProfilesForAnyConnectedUser(context)).orElse(Collections.EMPTY_SET);
    }

    public Set<String> getDeniedProfilesForAnyConnectedUser(Object context) {
        return this._getFirstProfileAssignmentStorage(context).map(pas -> pas.getDeniedProfilesForAnyConnectedUser(context)).orElse(Collections.EMPTY_SET);
    }

    public void allowProfileToAnyConnectedUser(String profileId, Object context) {
        this._getFirstModifiableProfileAssignmentStorage(context).ifPresent(pas -> pas.addAllowedProfilesForAnyConnectedUser(context, Collections.singleton(profileId)));
    }

    public void denyProfileToAnyConnectedUser(String profileId, Object context) {
        this._getFirstModifiableProfileAssignmentStorage(context).ifPresent(pas -> pas.addDeniedProfilesForAnyConnectedUser(context, Collections.singleton(profileId)));
    }

    public void removeAllowedProfileFromAnyConnectedUser(String profileId, Object context) {
        this._getFirstModifiableProfileAssignmentStorage(context).ifPresent(pas -> pas.removeAllowedProfilesForAnyConnectedUser(context, Collections.singleton(profileId)));
    }

    public void removeDeniedProfileFromAnyConnectedUser(String profileId, Object context) {
        this._getFirstModifiableProfileAssignmentStorage(context).ifPresent(pas -> pas.removeDeniedProfilesForAnyConnectedUser(context, Collections.singleton(profileId)));
    }

    public Set<String> getAllowedProfilesForAnonymous(Object context) {
        Set allowedProfiles = this._getFirstProfileAssignmentStorage(context).map(pas -> pas.getAllowedProfilesForAnonymous(context)).orElse(Collections.EMPTY_SET);
        Set<String> deniedProfiles = this.getDeniedProfilesForAnonymous(context);
        return new HashSet<String>(CollectionUtils.removeAll((Collection)allowedProfiles, deniedProfiles));
    }

    public Set<String> getDeniedProfilesForAnonymous(Object context) {
        return this._getFirstProfileAssignmentStorage(context).map(pas -> pas.getDeniedProfilesForAnonymous(context)).orElse(Collections.EMPTY_SET);
    }

    public void allowProfileToAnonymous(String profileId, Object context) {
        this._getFirstModifiableProfileAssignmentStorage(context).ifPresent(pas -> pas.addAllowedProfilesForAnonymous(context, Collections.singleton(profileId)));
    }

    public void denyProfileToAnonymous(String profileId, Object context) {
        this._getFirstModifiableProfileAssignmentStorage(context).ifPresent(pas -> pas.addDeniedProfilesForAnonymous(context, Collections.singleton(profileId)));
    }

    public void removeAllowedProfileFromAnonymous(String profileId, Object context) {
        this._getFirstModifiableProfileAssignmentStorage(context).ifPresent(pas -> pas.removeAllowedProfilesForAnonymous(context, Collections.singleton(profileId)));
    }

    public void removeDeniedProfileFromAnonymous(String profileId, Object context) {
        this._getFirstModifiableProfileAssignmentStorage(context).ifPresent(pas -> pas.removeDeniedProfilesForAnonymous(context, Collections.singleton(profileId)));
    }

    public Set<UserIdentity> getAllowedUsers(Object object, String profileId) {
        return this._getFirstProfileAssignmentStorage(object).map(pas -> pas.getAllowedUsers(object, profileId)).orElse(Collections.EMPTY_SET);
    }

    public Set<UserIdentity> getDeniedUsers(Object object, String profileId) {
        return this._getFirstProfileAssignmentStorage(object).map(pas -> pas.getDeniedUsers(object, profileId)).orElse(Collections.EMPTY_SET);
    }

    public Set<String> getAllowedProfilesForUser(Object object, UserIdentity user) {
        return this._getFirstProfileAssignmentStorage(object).map(pas -> pas.getAllowedProfilesForUser(user, object)).orElse(Collections.EMPTY_SET);
    }

    public Set<String> getDeniedProfilesForUser(Object object, UserIdentity user) {
        return this._getFirstProfileAssignmentStorage(object).map(pas -> pas.getDeniedProfilesForUser(user, object)).orElse(Collections.EMPTY_SET);
    }

    public Map<UserIdentity, Set<String>> getAllowedProfilesForUsers(Object object) {
        return this._getFirstProfileAssignmentStorage(object).map(pas -> pas.getAllowedProfilesForUsers(object)).orElse(Collections.EMPTY_MAP);
    }

    public Map<UserIdentity, Set<String>> getDeniedProfilesForUsers(Object object) {
        return this._getFirstProfileAssignmentStorage(object).map(pas -> pas.getDeniedProfilesForUsers(object)).orElse(Collections.EMPTY_MAP);
    }

    public void allowProfileToUser(UserIdentity user, String profileId, Object context) {
        this._getFirstModifiableProfileAssignmentStorage(context).ifPresent(pas -> pas.addAllowedUsers(Collections.singleton(user), context, profileId));
    }

    public void denyProfileToUser(UserIdentity user, String profileId, Object context) {
        this._getFirstModifiableProfileAssignmentStorage(context).ifPresent(pas -> pas.addDeniedUsers(Collections.singleton(user), context, profileId));
    }

    public void removeAllowedProfileFromUser(UserIdentity user, String profileId, Object context) {
        this._getFirstModifiableProfileAssignmentStorage(context).ifPresent(pas -> pas.removeAllowedUsers(Collections.singleton(user), context, profileId));
    }

    public void removeDeniedProfileFromUser(UserIdentity user, String profileId, Object context) {
        this._getFirstModifiableProfileAssignmentStorage(context).ifPresent(pas -> pas.removeDeniedUsers(Collections.singleton(user), context, profileId));
    }

    public Set<GroupIdentity> getAllowedGroups(Object object, String profileId) {
        return this._getFirstProfileAssignmentStorage(object).map(pas -> pas.getAllowedGroups(object, profileId)).orElse(Collections.EMPTY_SET);
    }

    public Set<GroupIdentity> getDeniedGroups(Object object, String profileId) {
        return this._getFirstProfileAssignmentStorage(object).map(pas -> pas.getDeniedGroups(object, profileId)).orElse(Collections.EMPTY_SET);
    }

    public Set<String> getAllowedProfilesForGroup(Object object, GroupIdentity group) {
        return this._getFirstProfileAssignmentStorage(object).map(pas -> pas.getAllowedProfilesForGroups(object).get(group)).orElse(Collections.EMPTY_SET);
    }

    public Set<String> getDeniedProfilesForGroup(Object object, GroupIdentity group) {
        return this._getFirstProfileAssignmentStorage(object).map(pas -> pas.getDeniedProfilesForGroups(object).get(group)).orElse(Collections.EMPTY_SET);
    }

    public Map<GroupIdentity, Set<String>> getAllowedProfilesForGroups(Object object) {
        return this._getFirstProfileAssignmentStorage(object).map(pas -> pas.getAllowedProfilesForGroups(object)).orElse(Collections.EMPTY_MAP);
    }

    public Map<GroupIdentity, Set<String>> getDeniedProfilesForGroups(Object context) {
        return this._getFirstProfileAssignmentStorage(context).map(pas -> pas.getDeniedProfilesForGroups(context)).orElse(Collections.EMPTY_MAP);
    }

    public void allowProfileToGroup(GroupIdentity group, String profileId, Object context) {
        this._getFirstModifiableProfileAssignmentStorage(context).ifPresent(pas -> pas.addAllowedGroups(Collections.singleton(group), context, profileId));
    }

    public void denyProfileToGroup(GroupIdentity group, String profileId, Object context) {
        this._getFirstModifiableProfileAssignmentStorage(context).ifPresent(pas -> pas.addDeniedGroups(Collections.singleton(group), context, profileId));
    }

    public void removeAllowedProfileFromGroup(GroupIdentity group, String profileId, Object context) {
        this._getFirstModifiableProfileAssignmentStorage(context).ifPresent(pas -> pas.removeAllowedGroups(Collections.singleton(group), context, profileId));
    }

    public void removeDeniedProfileFromGroup(GroupIdentity group, String profileId, Object context) {
        this._getFirstModifiableProfileAssignmentStorage(context).ifPresent(pas -> pas.removeDeniedGroups(Collections.singleton(group), context, profileId));
    }

    private Optional<ProfileAssignmentStorage> _getFirstProfileAssignmentStorage(Object object) {
        return this.getExtensionsIds().stream().map(this::getExtension).filter(pas -> pas.isSupported(object)).sorted(Comparator.comparing(ProfileAssignmentStorage::getPriority)).findFirst();
    }

    private Optional<ModifiableProfileAssignmentStorage> _getFirstModifiableProfileAssignmentStorage(Object object) {
        return this.getExtensionsIds().stream().map(this::getExtension).filter(pas -> pas.isSupported(object) && pas instanceof ModifiableProfileAssignmentStorage).map(ModifiableProfileAssignmentStorage.class::cast).sorted(Comparator.comparing(ProfileAssignmentStorage::getPriority)).findFirst();
    }
}

