/*
 * Decompiled with CFR 0.152.
 */
package org.ametys.core.right;

import java.io.InputStream;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;
import org.ametys.core.group.GroupDirectoryDAO;
import org.ametys.core.group.GroupIdentity;
import org.ametys.core.group.GroupManager;
import org.ametys.core.right.AccessController;
import org.ametys.core.right.AccessControllerExtensionPoint;
import org.ametys.core.right.AllowedUsers;
import org.ametys.core.right.RightContextConvertorExtensionPoint;
import org.ametys.core.right.RightProfilesDAO;
import org.ametys.core.right.RightsException;
import org.ametys.core.right.RightsExtensionPoint;
import org.ametys.core.user.CurrentUserProvider;
import org.ametys.core.user.UserIdentity;
import org.ametys.core.user.UserManager;
import org.ametys.core.user.population.UserPopulationDAO;
import org.ametys.runtime.i18n.I18nizableText;
import org.ametys.runtime.plugin.component.AbstractLogEnabled;
import org.apache.avalon.framework.CascadingRuntimeException;
import org.apache.avalon.framework.component.Component;
import org.apache.avalon.framework.configuration.Configurable;
import org.apache.avalon.framework.configuration.Configuration;
import org.apache.avalon.framework.configuration.ConfigurationException;
import org.apache.avalon.framework.configuration.DefaultConfigurationBuilder;
import org.apache.avalon.framework.context.Context;
import org.apache.avalon.framework.context.ContextException;
import org.apache.avalon.framework.context.Contextualizable;
import org.apache.avalon.framework.service.ServiceException;
import org.apache.avalon.framework.service.ServiceManager;
import org.apache.avalon.framework.service.Serviceable;
import org.apache.avalon.framework.thread.ThreadSafe;
import org.apache.cocoon.components.ContextHelper;
import org.apache.cocoon.environment.Request;
import org.apache.commons.lang3.StringUtils;
import org.apache.excalibur.source.Source;
import org.apache.excalibur.source.SourceResolver;

public class RightManager
extends AbstractLogEnabled
implements Serviceable,
Configurable,
ThreadSafe,
Component,
Contextualizable {
    public static final String ROLE = RightManager.class.getName();
    public static final String READER_PROFILE_ID = "READER";
    public static final String CACHE_REQUEST_ATTRIBUTE_NAME = RightManager.class.getName() + "$Cache";
    protected static final UserIdentity __ANONYMOUS_USER_IDENTITY = null;
    protected static final UserIdentity __ANY_CONTECTED_USER_IDENTITY = new UserIdentity(null, null);
    private static final String CACHE_1 = RightManager.class.getName() + "$Cache-1";
    private static final String CACHE_2 = RightManager.class.getName() + "$Cache-2";
    protected ServiceManager _manager;
    protected SourceResolver _resolver;
    protected RightsExtensionPoint _rightsEP;
    protected RightContextConvertorExtensionPoint _rightContextConvertorEP;
    protected AccessControllerExtensionPoint _accessControllerEP;
    protected UserManager _userManager;
    protected GroupManager _groupManager;
    protected UserPopulationDAO _userPopulationDAO;
    protected GroupDirectoryDAO _groupDirectoryDAO;
    protected CurrentUserProvider _currentUserProvider;
    protected RightProfilesDAO _profilesDAO;
    private Context _context;

    public void contextualize(Context context) throws ContextException {
        this._context = context;
    }

    public void service(ServiceManager manager) throws ServiceException {
        this._manager = manager;
        this._userManager = (UserManager)manager.lookup(UserManager.ROLE);
        this._groupManager = (GroupManager)manager.lookup(GroupManager.ROLE);
        this._userPopulationDAO = (UserPopulationDAO)manager.lookup(UserPopulationDAO.ROLE);
        this._groupDirectoryDAO = (GroupDirectoryDAO)manager.lookup(GroupDirectoryDAO.ROLE);
        this._rightsEP = (RightsExtensionPoint)manager.lookup(RightsExtensionPoint.ROLE);
        this._rightContextConvertorEP = (RightContextConvertorExtensionPoint)manager.lookup(RightContextConvertorExtensionPoint.ROLE);
        this._accessControllerEP = (AccessControllerExtensionPoint)manager.lookup(AccessControllerExtensionPoint.ROLE);
        this._resolver = (SourceResolver)this._manager.lookup(SourceResolver.ROLE);
        this._currentUserProvider = (CurrentUserProvider)this._manager.lookup(CurrentUserProvider.ROLE);
    }

    protected RightProfilesDAO _getProfileDAO() {
        try {
            if (this._profilesDAO == null) {
                this._profilesDAO = (RightProfilesDAO)this._manager.lookup(RightProfilesDAO.ROLE);
            }
            return this._profilesDAO;
        }
        catch (ServiceException e) {
            throw new RuntimeException("Failed to retrieve the DAO for profiles", e);
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public void configure(Configuration configuration) throws ConfigurationException {
        Configuration rightsConfiguration = configuration.getChild("rights");
        String externalFile = rightsConfiguration.getAttribute("config", null);
        if (externalFile != null) {
            Source source = null;
            try {
                source = this._resolver.resolveURI("context://" + externalFile);
                if (source.exists()) {
                    Configuration externalConfiguration;
                    try (InputStream is = source.getInputStream();){
                        externalConfiguration = new DefaultConfigurationBuilder().build(is);
                    }
                    this.configureRights(externalConfiguration);
                } else if (this.getLogger().isInfoEnabled()) {
                    this.getLogger().info("The optional external rights file '" + externalFile + "' is missing.");
                }
                if (source == null) return;
            }
            catch (Exception e) {
                try {
                    String message = "An error occured while retriving external file '" + externalFile + "'";
                    this.getLogger().error(message, (Throwable)e);
                    throw new ConfigurationException(message, configuration, (Throwable)e);
                }
                catch (Throwable throwable) {
                    if (source == null) throw throwable;
                    this._resolver.release(source);
                    throw throwable;
                }
            }
            this._resolver.release(source);
            return;
        }
        this.configureRights(rightsConfiguration);
    }

    private void configureRights(Configuration configuration) throws ConfigurationException {
        Configuration[] rights;
        for (Configuration rightConf : rights = configuration.getChildren("right")) {
            String id = rightConf.getAttribute("id", "");
            String label = rightConf.getChild("label").getValue("");
            I18nizableText i18nLabel = new I18nizableText("application", label);
            String description = rightConf.getChild("description").getValue("");
            I18nizableText i18nDescription = new I18nizableText("application", description);
            String category = rightConf.getChild("category").getValue("");
            I18nizableText i18nCategory = new I18nizableText("application", category);
            if (id.length() == 0 || label.length() == 0 || description.length() == 0 || category.length() == 0) {
                String message = "Error in " + RightManager.class.getName() + " configuration: attribute 'id' and elements 'label', 'description' and 'category' are mandatory.";
                this.getLogger().error(message);
                throw new ConfigurationException(message, configuration);
            }
            this._rightsEP.addRight(id, i18nLabel, i18nDescription, i18nCategory);
        }
    }

    public RightResult currentUserHasRight(String rightId, Object object) throws RightsException {
        return this.hasRight(this._currentUserProvider.getUser(), rightId, object);
    }

    public RightResult hasRight(UserIdentity userIdentity, String rightId, Object object) throws RightsException {
        UserIdentity objectUserIdentity = userIdentity == null ? __ANONYMOUS_USER_IDENTITY : userIdentity;
        return this._hasRight(objectUserIdentity, rightId, object);
    }

    public RightResult hasAnonymousRight(String rightId, Object object) {
        return this._hasRight(__ANONYMOUS_USER_IDENTITY, rightId, object);
    }

    public RightResult hasAnyConnectedUserRight(String rightId, Object object) {
        return this._hasRight(__ANY_CONTECTED_USER_IDENTITY, rightId, object);
    }

    private RightResult _hasRight(UserIdentity userIdentity, String rightId, Object object) {
        this.getLogger().debug("Try to determine if user {} has the right '{}' on the object context {}", new Object[]{userIdentity, rightId, object});
        if (StringUtils.isBlank((CharSequence)rightId)) {
            throw new RightsException("The rightId cannot be null");
        }
        return this._hasRightOrRead(userIdentity, rightId, object);
    }

    private RightResult _hasRightOrRead(UserIdentity userIdentity, String rightId, Object object) {
        if (object == null) {
            return this._hasRightOrRead(userIdentity, rightId);
        }
        RightResult cacheResult = this._hasRightResultInFirstCache(userIdentity, rightId, object);
        if (cacheResult != null) {
            return cacheResult;
        }
        Set<GroupIdentity> groups = this._getGroups(userIdentity);
        Set<Object> objects = this._getConvertedObjects(object, new HashSet<Object>());
        Set<AccessController.AccessResult> accessResults = this._getAccessResults(userIdentity, groups, rightId, objects);
        AccessController.AccessResult access = AccessController.AccessResult.merge(accessResults);
        RightResult rightResult = access.toRightResult();
        this._putInFirstCache(userIdentity, rightId, object, rightResult);
        return rightResult;
    }

    private RightResult _hasRightOrRead(UserIdentity userIdentity, String rightId) {
        Set<Object> workspacesContexts = this._getConvertedObjects("/${WorkspaceName}", new HashSet<Object>());
        RightResult cacheResult = this._hasRightResultInSecondCache(workspacesContexts, userIdentity, rightId);
        if (cacheResult != null) {
            return cacheResult;
        }
        Set<GroupIdentity> groups = this._getGroups(userIdentity);
        RightResult rightResult = RightResult.RIGHT_UNKNOWN;
        for (String controllerId : this._accessControllerEP.getExtensionsIds()) {
            AccessController accessController = (AccessController)this._accessControllerEP.getExtension(controllerId);
            try {
                if (!(userIdentity == __ANONYMOUS_USER_IDENTITY && (rightId != null ? accessController.hasAnonymousAnyPermissionOnWorkspace(workspacesContexts, rightId) : accessController.hasAnonymousAnyReadAccessPermissionOnWorkspace(workspacesContexts)) || userIdentity == __ANY_CONTECTED_USER_IDENTITY && (rightId != null ? accessController.hasAnyConnectedUserAnyPermissionOnWorkspace(workspacesContexts, rightId) : accessController.hasAnyConnectedUserAnyReadAccessPermissionOnWorkspace(workspacesContexts))) && !(rightId == null ? accessController.hasUserAnyReadAccessPermissionOnWorkspace(workspacesContexts, userIdentity, groups) : accessController.hasUserAnyPermissionOnWorkspace(workspacesContexts, userIdentity, groups, rightId))) continue;
                rightResult = RightResult.RIGHT_ALLOW;
                break;
            }
            catch (Exception e) {
                this.getLogger().error("An error occured with controller '{}'. Thus, this controller will be ignored.", (Object)controllerId, (Object)e);
            }
        }
        this.getLogger().debug("Right result found for [{}, {}, {}] => {}", new Object[]{workspacesContexts, userIdentity, rightId, rightResult});
        this._putInSecondCache(workspacesContexts, userIdentity, rightId, rightResult);
        return rightResult;
    }

    private Set<AccessController.AccessResult> _getAccessResults(UserIdentity userIdentity, Set<GroupIdentity> groups, String rightId, Set<Object> objects) {
        HashSet<AccessController.AccessResult> accessResults = new HashSet<AccessController.AccessResult>();
        for (Object obj : objects) {
            for (String controllerId : this._accessControllerEP.getExtensionsIds()) {
                AccessController accessController = (AccessController)this._accessControllerEP.getExtension(controllerId);
                try {
                    if (accessController.isSupported(obj)) {
                        if (userIdentity == __ANONYMOUS_USER_IDENTITY) {
                            accessResults.add(rightId == null ? accessController.getReadAccessPermissionForAnonymous(obj) : accessController.getPermissionForAnonymous(rightId, obj));
                            continue;
                        }
                        if (userIdentity == __ANY_CONTECTED_USER_IDENTITY) {
                            accessResults.add(rightId == null ? accessController.getReadAccessPermissionForAnyConnectedUser(obj) : accessController.getPermissionForAnyConnectedUser(rightId, obj));
                            continue;
                        }
                        accessResults.add(rightId == null ? accessController.getReadAccessPermission(userIdentity, groups, obj) : accessController.getPermission(userIdentity, groups, rightId, obj));
                        continue;
                    }
                    accessResults.add(AccessController.AccessResult.UNKNOWN);
                }
                catch (Exception e) {
                    this.getLogger().error("An error occured with controller '{}' for object {}. Thus, this controller will be ignored.", new Object[]{controllerId, obj, e});
                }
            }
        }
        return accessResults;
    }

    public boolean currentUserHasReadAccess(Object object) {
        return this.hasReadAccess(this._currentUserProvider.getUser(), object);
    }

    public boolean hasReadAccess(UserIdentity userIdentity, Object object) {
        UserIdentity objectUserIdentity = userIdentity == null ? __ANONYMOUS_USER_IDENTITY : userIdentity;
        return this._hasRightOrRead(objectUserIdentity, null, object) == RightResult.RIGHT_ALLOW;
    }

    public boolean hasAnonymousReadAccess(Object object) {
        return this._hasRightOrRead(__ANONYMOUS_USER_IDENTITY, null, object) == RightResult.RIGHT_ALLOW;
    }

    public boolean hasAnyConnectedUserReadAccess(Object object) {
        return this._hasRightOrRead(__ANY_CONTECTED_USER_IDENTITY, null, object) == RightResult.RIGHT_ALLOW;
    }

    public AllowedUsers getAllowedUsers(String rightId, Object object) {
        if (StringUtils.isBlank((CharSequence)rightId)) {
            throw new RightsException("The rightId cannot be null");
        }
        return this._getAllowedUsers(rightId, object);
    }

    public AllowedUsers getReadAccessAllowedUsers(Object object) {
        return this._getAllowedUsers(null, object);
    }

    private AllowedUsers _getAllowedUsers(String rightId, Object object) {
        Optional.ofNullable(object).orElseThrow(() -> new RightsException("The object cannot be null"));
        Set<Object> objects = this._getConvertedObjects(object, new HashSet<Object>());
        Boolean isAnyConnectedAllowed = null;
        HashSet<UserIdentity> allAllowedUsers = new HashSet<UserIdentity>();
        HashSet<UserIdentity> allDeniedUsers = new HashSet<UserIdentity>();
        HashSet<GroupIdentity> allAllowedGroups = new HashSet<GroupIdentity>();
        HashSet<GroupIdentity> allDeniedGroups = new HashSet<GroupIdentity>();
        for (Object obj : objects) {
            for (String controllerId : this._accessControllerEP.getExtensionsIds()) {
                AccessController accessController = (AccessController)this._accessControllerEP.getExtension(controllerId);
                try {
                    AccessController.AccessResult permissionForAnyConnectedUser;
                    if (!accessController.isSupported(obj)) continue;
                    if ((rightId == null ? accessController.getReadAccessPermissionForAnonymous(obj) : accessController.getPermissionForAnonymous(rightId, obj)) == AccessController.AccessResult.ANONYMOUS_ALLOWED) {
                        return new AllowedUsers(true, false, null, null, null, null, this._userManager, this._groupManager, null);
                    }
                    AccessController.AccessResult accessResult = permissionForAnyConnectedUser = rightId == null ? accessController.getReadAccessPermissionForAnyConnectedUser(obj) : accessController.getPermissionForAnyConnectedUser(rightId, obj);
                    if (permissionForAnyConnectedUser == AccessController.AccessResult.ANY_CONNECTED_DENIED) {
                        isAnyConnectedAllowed = Boolean.FALSE;
                    } else if (isAnyConnectedAllowed == null && permissionForAnyConnectedUser == AccessController.AccessResult.ANY_CONNECTED_ALLOWED) {
                        isAnyConnectedAllowed = Boolean.TRUE;
                    }
                    Map<UserIdentity, AccessController.AccessResult> permissionsByUser = rightId == null ? accessController.getReadAccessPermissionByUser(obj) : accessController.getPermissionByUser(rightId, obj);
                    Set allowedUsersOnObj = permissionsByUser.entrySet().stream().filter(entry -> AccessController.AccessResult.USER_ALLOWED.equals(entry.getValue())).map(Map.Entry::getKey).collect(Collectors.toSet());
                    allAllowedUsers.addAll(allowedUsersOnObj);
                    Set deniedUsersOnObj = permissionsByUser.entrySet().stream().filter(entry -> AccessController.AccessResult.USER_DENIED.equals(entry.getValue())).map(Map.Entry::getKey).collect(Collectors.toSet());
                    allDeniedUsers.addAll(deniedUsersOnObj);
                    Map<GroupIdentity, AccessController.AccessResult> permissionsByGroup = rightId == null ? accessController.getReadAccessPermissionByGroup(obj) : accessController.getPermissionByGroup(rightId, obj);
                    Set allowedGroupsOnObj = permissionsByGroup.entrySet().stream().filter(entry -> AccessController.AccessResult.GROUP_ALLOWED.equals(entry.getValue())).map(Map.Entry::getKey).collect(Collectors.toSet());
                    allAllowedGroups.addAll(allowedGroupsOnObj);
                    Set deniedGroupsOnObj = permissionsByGroup.entrySet().stream().filter(entry -> AccessController.AccessResult.GROUP_DENIED.equals(entry.getValue())).map(Map.Entry::getKey).collect(Collectors.toSet());
                    allDeniedGroups.addAll(deniedGroupsOnObj);
                }
                catch (Exception e) {
                    this.getLogger().error("An error occured with controller '{}' for object {}. Thus, this controller will be ignored.", new Object[]{controllerId, obj, e});
                }
            }
        }
        Request request = ContextHelper.getRequest((Context)this._context);
        List populationContexts = (List)request.getAttribute("populationContexts");
        return new AllowedUsers(false, isAnyConnectedAllowed != null && isAnyConnectedAllowed != false, allAllowedUsers, allDeniedUsers, allAllowedGroups, allDeniedGroups, this._userManager, this._groupManager, populationContexts != null ? new HashSet<String>(populationContexts) : new HashSet());
    }

    public Set<String> getUserRights(UserIdentity userIdentity, Object object) throws RightsException {
        if (userIdentity == null) {
            throw new RightsException("The userIdentity cannot be null");
        }
        if (object == null) {
            throw new RightsException("The object cannot be null");
        }
        Set<Object> objects = this._getConvertedObjects(object, new HashSet<Object>());
        Set<GroupIdentity> groups = this._groupManager.getUserGroups(userIdentity);
        Map<String, AccessController.AccessResult> accessResultsByRight = this._getAccessResultByRight(userIdentity, groups, objects);
        Set<String> allowedRights = accessResultsByRight.entrySet().stream().filter(entry -> ((AccessController.AccessResult)((Object)((Object)entry.getValue()))).toRightResult() == RightResult.RIGHT_ALLOW).map(entry -> (String)entry.getKey()).collect(Collectors.toSet());
        return allowedRights;
    }

    private Map<String, AccessController.AccessResult> _getAccessResultByRight(UserIdentity userIdentity, Set<GroupIdentity> groups, Set<Object> objects) {
        HashMap<String, AccessController.AccessResult> result = new HashMap<String, AccessController.AccessResult>();
        for (Object obj : objects) {
            for (String controllerId : this._accessControllerEP.getExtensionsIds()) {
                AccessController accessController = (AccessController)this._accessControllerEP.getExtension(controllerId);
                try {
                    if (!accessController.isSupported(obj)) continue;
                    Map<String, AccessController.AccessResult> permissionsByRight = accessController.getPermissionByRight(userIdentity, groups, obj);
                    for (String rightId : permissionsByRight.keySet()) {
                        result.put(rightId, AccessController.AccessResult.merge((AccessController.AccessResult)((Object)result.get(rightId)), permissionsByRight.get(rightId)));
                    }
                }
                catch (Exception e) {
                    this.getLogger().error("An error occured with controller '{}' for object {}. Thus, this controller will be ignored.", new Object[]{controllerId, obj, e});
                }
            }
        }
        return result;
    }

    private Set<Object> _getConvertedObjects(Object object, Set<Object> alreadyHandledObjects) {
        HashSet<Object> finalObjects = new HashSet<Object>();
        if (!alreadyHandledObjects.contains(object)) {
            alreadyHandledObjects.add(object);
            Set objects = this._rightContextConvertorEP.getExtensionsIds().stream().map(this._rightContextConvertorEP::getExtension).flatMap(convertor -> convertor.convert(object).stream()).collect(Collectors.toSet());
            finalObjects.addAll(objects);
            finalObjects.add(object);
            for (Object convertedObject : objects) {
                finalObjects.addAll(this._getConvertedObjects(convertedObject, alreadyHandledObjects));
            }
        }
        return finalObjects;
    }

    private Set<GroupIdentity> _getGroups(UserIdentity userIdentity) {
        if (userIdentity == __ANONYMOUS_USER_IDENTITY || userIdentity == __ANY_CONTECTED_USER_IDENTITY) {
            return Collections.EMPTY_SET;
        }
        Set<GroupIdentity> userGroups = this._groupManager.getUserGroups(userIdentity);
        return userGroups;
    }

    private RightResult _hasRightResultInFirstCache(UserIdentity userIdentity, String rightId, Object object) {
        Map mapContext;
        Map mapRight;
        Map mapCache = this.getCache(CACHE_1, false);
        if (mapCache != null && mapCache.containsKey(userIdentity) && (mapRight = (Map)mapCache.get(userIdentity)).containsKey(rightId) && (mapContext = (Map)mapRight.get(rightId)).containsKey(object)) {
            RightResult cacheResult = (RightResult)((Object)mapContext.get(object));
            this.getLogger().debug("Find entry in cache for [{}, {}, {}] => {}", new Object[]{userIdentity, rightId, object, cacheResult});
            return cacheResult;
        }
        this.getLogger().debug("Did not find entry in cache for [{}, {}, {}]", new Object[]{userIdentity, rightId, object});
        return null;
    }

    private void _putInFirstCache(UserIdentity userIdentity, String rightId, Object object, RightResult rightResult) {
        Map mapCache = this.getCache(CACHE_1, true);
        if (mapCache != null) {
            Map mapRight;
            if (!mapCache.containsKey(userIdentity)) {
                mapCache.put(userIdentity, new HashMap());
            }
            if (!(mapRight = (Map)mapCache.get(userIdentity)).containsKey(rightId)) {
                mapRight.put(rightId, new HashMap());
            }
            Map mapContext = (Map)mapRight.get(rightId);
            mapContext.put(object, rightResult);
        }
    }

    private RightResult _hasRightResultInSecondCache(Set<Object> workspacesContexts, UserIdentity userIdentity, String rightId) {
        Map resultPerContext;
        Map mapRight;
        Map mapCache = this.getCache(CACHE_2, false);
        if (mapCache != null && mapCache.containsKey(userIdentity) && (mapRight = (Map)mapCache.get(userIdentity)).containsKey(rightId) && (resultPerContext = (Map)mapRight.get(rightId)).containsKey(workspacesContexts)) {
            RightResult cacheResult = (RightResult)((Object)resultPerContext.get(workspacesContexts));
            this.getLogger().debug("Find entry in cache2 for [{}, {}, {}] => {}", new Object[]{workspacesContexts, userIdentity, rightId, cacheResult});
            return cacheResult;
        }
        this.getLogger().debug("Did not find entry in cache2 for [{}, {}, {}]", new Object[]{workspacesContexts, userIdentity, rightId});
        return null;
    }

    private void _putInSecondCache(Set<Object> workspacesContexts, UserIdentity userIdentity, String rightId, RightResult rightResult) {
        Map mapCache = this.getCache(CACHE_2, true);
        if (mapCache != null) {
            Map mapRights;
            if (!mapCache.containsKey(userIdentity)) {
                mapCache.put(userIdentity, new HashMap());
            }
            if (!(mapRights = (Map)mapCache.get(userIdentity)).containsKey(rightId)) {
                mapRights.put(rightId, new HashMap());
            }
            Map mapResult = (Map)mapRights.get(rightId);
            mapResult.put(workspacesContexts, rightResult);
        }
    }

    public Map getCache(String cacheKey, boolean createIfUnexisting) {
        HashMap mapCache;
        Request request;
        try {
            request = ContextHelper.getRequest((Context)this._context);
        }
        catch (CascadingRuntimeException e) {
            return null;
        }
        if (request == null) {
            return null;
        }
        HashMap cache = (HashMap)request.getAttribute(CACHE_REQUEST_ATTRIBUTE_NAME);
        if (cache == null) {
            if (!createIfUnexisting) {
                return null;
            }
            cache = new HashMap();
            request.setAttribute(CACHE_REQUEST_ATTRIBUTE_NAME, cache);
        }
        if ((mapCache = (HashMap)cache.get(cacheKey)) == null && createIfUnexisting) {
            mapCache = new HashMap();
            cache.put(cacheKey, mapCache);
        }
        return mapCache;
    }

    public static enum RightResult {
        RIGHT_ALLOW,
        RIGHT_DENY,
        RIGHT_UNKNOWN;

    }
}

