/*
 * Decompiled with CFR 0.152.
 */
package org.ametys.core.right;

import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.ametys.core.datasource.AbstractMyBatisDAO;
import org.ametys.core.observation.Event;
import org.ametys.core.observation.ObservationManager;
import org.ametys.core.right.Profile;
import org.ametys.core.right.RightManager;
import org.ametys.core.user.CurrentUserProvider;
import org.apache.avalon.framework.service.ServiceException;
import org.apache.avalon.framework.service.ServiceManager;
import org.apache.commons.lang3.StringUtils;
import org.apache.ibatis.session.SqlSession;

public class RightProfilesDAO
extends AbstractMyBatisDAO {
    public static final String ROLE = RightProfilesDAO.class.getName();
    private final String _cache = this.getClass().getName() + "$Cache";
    private ServiceManager _smanager;
    private ObservationManager _observationManager;
    private CurrentUserProvider _currentUserProvider;
    private RightManager _rightManager;

    @Override
    public void service(ServiceManager smanager) throws ServiceException {
        this._smanager = smanager;
        super.service(smanager);
    }

    private RightManager _getRightManager() {
        if (this._rightManager == null) {
            try {
                this._rightManager = (RightManager)this._smanager.lookup(RightManager.ROLE);
            }
            catch (ServiceException e) {
                throw new IllegalStateException("Cannot get RightManager for RightProfilesDAO", e);
            }
        }
        return this._rightManager;
    }

    public List<Profile> getProfiles() {
        try (SqlSession session = this.getSession();){
            List list = session.selectList("Profiles.getProfiles");
            return list;
        }
    }

    public List<Profile> getProfiles(String context) {
        try (SqlSession session = this.getSession();){
            if (context == null) {
                List list = session.selectList("Profiles.getProfilesWithNullContext");
                return list;
            }
            List list = session.selectList("Profiles.getProfilesByContext");
            return list;
        }
    }

    public Profile getProfile(String id) {
        try (SqlSession session = this.getSession();){
            Profile profile = (Profile)session.selectOne("Profiles.getProfile", (Object)id);
            return profile;
        }
    }

    public Set<String> getProfilesWithRight(String rightId) {
        Map<String, HashSet<Object>> cache = this._getRightManager().getCache(this._cache, false);
        if (cache == null) {
            cache = this._getRightManager().getCache(this._cache, true);
            if (cache == null) {
                cache = new HashMap();
            }
            try (SqlSession session = this.getSession();){
                List profileRights = session.selectList("Profiles.getProfileRights");
                for (Map profileRight : profileRights) {
                    String currentProfileId = (String)profileRight.get("profileId");
                    String currentRightId = (String)profileRight.get("rightId");
                    if (cache.containsKey(currentRightId)) {
                        ((Set)cache.get(currentRightId)).add(currentProfileId);
                        continue;
                    }
                    HashSet<String> profiles = new HashSet<String>();
                    profiles.add(currentProfileId);
                    cache.put(currentRightId, profiles);
                }
            }
        }
        if (cache.containsKey(rightId)) {
            return (Set)cache.get(rightId);
        }
        return Collections.EMPTY_SET;
    }

    public Profile addProfile(String label) {
        return this.addProfile(label, null);
    }

    public Profile addProfile(String label, String context) {
        String id = this._generateUniqueId(label);
        Profile profile = new Profile(id, label, context);
        this.addProfile(profile);
        return profile;
    }

    private String _generateUniqueId(String label) {
        String value = label.toLowerCase().trim().replaceAll("[\\W_]", "-").replaceAll("-+", "-").replaceAll("^-", "");
        int i = 2;
        String suffixedValue = value;
        while (this.getProfile(suffixedValue) != null) {
            suffixedValue = value + i;
            ++i;
        }
        return suffixedValue;
    }

    public Profile addProfile(String id, String label, String context) {
        Profile profile = new Profile(id, label, context);
        this.addProfile(profile);
        return profile;
    }

    public void addProfile(Profile profile, boolean silent) {
        try (SqlSession session = this.getSession(true);){
            session.insert("Profiles.addProfile", (Object)profile);
            if (!silent) {
                this._notifyEvent(profile, "profile.added");
            }
        }
    }

    public void addProfile(Profile profile) {
        this.addProfile(profile, false);
    }

    public void renameProfile(Profile profile, String newLabel) {
        this.renameProfile(profile, newLabel, false);
    }

    public void renameProfile(Profile profile, String newLabel, boolean silent) {
        try (SqlSession session = this.getSession(true);){
            HashMap<String, String> params = new HashMap<String, String>();
            params.put("id", profile.getId());
            params.put("label", newLabel);
            session.update("Profiles.renameProfile", params);
            if (!silent) {
                this._notifyEvent(profile, "profile.updated");
            }
        }
    }

    public List<String> getRights(String profileId) {
        if (StringUtils.isEmpty((CharSequence)profileId)) {
            return Collections.EMPTY_LIST;
        }
        try (SqlSession session = this.getSession();){
            List list = session.selectList("Profiles.getRights", (Object)profileId);
            return list;
        }
    }

    public List<String> getRights(Profile profile) {
        if (profile == null) {
            return Collections.EMPTY_LIST;
        }
        return this.getRights(profile.getId());
    }

    public void addRight(Profile profile, String rightId) {
        try (SqlSession session = this.getSession(true);){
            this._addRight(session, profile, rightId);
        }
    }

    public void addRights(Profile profile, List<String> rightIds) {
        try (SqlSession session = this.getSession();){
            for (String rightId : rightIds) {
                this._addRight(session, profile, rightId);
            }
            session.commit();
        }
    }

    public void updateRights(Profile profile, List<String> rights) {
        this.updateRights(profile, rights, false);
    }

    public void updateRights(Profile profile, List<String> rights, boolean silent) {
        try (SqlSession session = this.getSession();){
            session.delete("Profiles.deleteProfileRights", (Object)profile.getId());
            if (rights != null) {
                for (String rightId : rights) {
                    this._addRight(session, profile, rightId);
                }
            }
            session.commit();
            if (!silent) {
                this._notifyEvent(profile, "profile.updated");
            }
        }
    }

    private void _addRight(SqlSession session, Profile profile, String rightId) {
        HashMap<String, String> params = new HashMap<String, String>();
        params.put("profileId", profile.getId());
        params.put("rightId", rightId);
        session.insert("Profiles.addRight", params);
    }

    public void removeRights(Profile profile) {
        this.removeRights(profile, false);
    }

    public void removeRights(Profile profile, boolean silent) {
        try (SqlSession session = this.getSession(true);){
            session.delete("Profiles.deleteProfileRights", (Object)profile.getId());
            if (!silent) {
                this._notifyEvent(profile, "profile.updated");
            }
        }
    }

    public void deleteProfile(Profile profile) {
        this.deleteProfile(profile, false);
    }

    public void deleteProfile(Profile profile, boolean silent) {
        try (SqlSession session = this.getSession();){
            session.delete("Profiles.deleteProfile", (Object)profile.getId());
            session.delete("Profiles.deleteProfileRights", (Object)profile.getId());
            session.commit();
            if (!silent) {
                this._notifyEvent(profile, "profile.deleted");
            }
        }
    }

    private void _notifyEvent(Profile profile, String eventId) {
        try {
            if (this._observationManager == null) {
                this._observationManager = (ObservationManager)((Object)this._smanager.lookup(ObservationManager.ROLE));
            }
            if (this._currentUserProvider == null) {
                this._currentUserProvider = (CurrentUserProvider)this._smanager.lookup(CurrentUserProvider.ROLE);
            }
            HashMap<String, Object> eventParams = new HashMap<String, Object>();
            eventParams.put("profile", profile);
            this._observationManager.notify(new Event(eventId, this._currentUserProvider.getUser(), eventParams));
        }
        catch (ServiceException e) {
            this.getLogger().error("Fail to notify observers for event '" + eventId + "'", (Throwable)e);
        }
    }
}

