/*
 * Decompiled with CFR 0.152.
 */
package org.ametys.core.ui.ribbonconfiguration;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.slf4j.Logger;

public class RibbonElementsInjectionHelper<T> {
    protected List<T> _elements;
    protected Logger _logger;
    private Map<Integer, ObjectOrderMapping> _mapping = new HashMap<Integer, ObjectOrderMapping>();

    public RibbonElementsInjectionHelper(List<T> elements, Logger logger) {
        this._logger = logger;
        this._elements = elements;
        if (elements.size() > 0) {
            for (T element : elements) {
                this._mapping.put(elements.indexOf(element) + 1, new ObjectOrderMapping(element));
            }
        } else {
            this._mapping.put(1, new ObjectOrderMapping(null));
        }
    }

    public void injectElements(T inject, String order) {
        Integer secondaryOrder;
        int indexOfDot = order.indexOf(".");
        int primaryOrder = Integer.valueOf(indexOfDot > 0 ? order.substring(0, indexOfDot) : order);
        Integer n = secondaryOrder = indexOfDot > 0 ? Integer.valueOf(order.substring(indexOfDot + 1)) : null;
        if (primaryOrder > 0) {
            if (primaryOrder > this._mapping.size() || !this._mapping.containsKey(primaryOrder)) {
                if (this._logger.isDebugEnabled()) {
                    this._logger.debug("TabOverrideHelper : injecting element '" + inject.toString() + "' with order '" + primaryOrder + "', but that order is out of bound. The element is injected at the end, after element '" + this._mapping.get(this._mapping.size()).getInitialObject() + "'");
                }
                this._mapping.get(this._mapping.size()).injectObjectAfter(inject, null);
            } else {
                this._mapping.get(primaryOrder).injectObjectBefore(inject, secondaryOrder);
                if (this._logger.isDebugEnabled()) {
                    this._logger.debug("TabOverrideHelper : injecting element '" + inject.toString() + "' with order '" + primaryOrder + "' before element '" + this._mapping.get(primaryOrder).getInitialObject() + "'");
                }
            }
        } else {
            int relativeOrder = this._mapping.size() + primaryOrder;
            if (relativeOrder < 0 || !this._mapping.containsKey(relativeOrder)) {
                if (this._logger.isDebugEnabled()) {
                    this._logger.debug("TabOverrideHelper : injecting element '" + inject.toString() + "' with order '" + primaryOrder + "', but that order is out of bound. The element is injected at the start, before element '" + this._mapping.get(1).getInitialObject() + "'");
                }
                this._mapping.get(1).injectObjectBefore(inject, 0);
            } else {
                if (this._logger.isDebugEnabled()) {
                    this._logger.debug("TabOverrideHelper : injecting element '" + inject.toString() + "' with order '" + primaryOrder + "' after element '" + this._mapping.get(relativeOrder).getInitialObject() + "'");
                }
                this._mapping.get(relativeOrder).injectObjectAfter(inject, secondaryOrder);
            }
        }
    }

    private class ObjectOrderMapping {
        private T _initialObject;
        private int _initialObjectIndex;
        private List<T> _objectsBefore = new ArrayList();
        private Map<T, Integer> _objectsBeforeOrder = new HashMap();
        private List<T> _objectsAfter = new ArrayList();
        private Map<T, Integer> _objectsAfterOrder = new HashMap();

        public ObjectOrderMapping(T initialObject) {
            this._initialObject = initialObject;
            this._initialObjectIndex = this._initialObject != null ? RibbonElementsInjectionHelper.this._elements.indexOf(this._initialObject) : 0;
        }

        public void injectObjectBefore(T object, Integer order) {
            if (this._objectsBefore.size() == 0) {
                this._objectsBefore.add(object);
                if (order != null) {
                    this._objectsBeforeOrder.put(object, order);
                }
                RibbonElementsInjectionHelper.this._elements.add(this._initialObject != null ? RibbonElementsInjectionHelper.this._elements.indexOf(this._initialObject) : 0, object);
            } else {
                this._inject(object, order, this._objectsBefore, this._objectsBeforeOrder);
            }
            ++this._initialObjectIndex;
        }

        public void injectObjectAfter(T object, Integer order) {
            if (this._objectsAfter.size() == 0) {
                this._objectsAfter.add(object);
                if (order != null) {
                    this._objectsAfterOrder.put(object, order);
                }
                RibbonElementsInjectionHelper.this._elements.add(this._initialObject != null ? RibbonElementsInjectionHelper.this._elements.indexOf(this._initialObject) + 1 : RibbonElementsInjectionHelper.this._elements.size(), object);
            } else {
                this._inject(object, order, this._objectsAfter, this._objectsAfterOrder);
            }
        }

        private void _inject(T object, Integer order, List<T> objects, Map<T, Integer> objectsOrder) {
            if (order == null) {
                Object lastObject = objects.get(objects.size() - 1);
                RibbonElementsInjectionHelper.this._elements.add(RibbonElementsInjectionHelper.this._elements.indexOf(lastObject) + 1, object);
                objects.add(object);
                return;
            }
            Object previous = null;
            for (int i = 0; i < objects.size() && objectsOrder.containsKey(objects.get(i)) && objectsOrder.get(objects.get(i)) <= order; ++i) {
                previous = objects.get(i);
            }
            objectsOrder.put(object, order);
            if (previous == null) {
                Object firstObject = objects.get(0);
                RibbonElementsInjectionHelper.this._elements.add(RibbonElementsInjectionHelper.this._elements.indexOf(firstObject), object);
                objects.add(0, object);
            } else {
                RibbonElementsInjectionHelper.this._elements.add(RibbonElementsInjectionHelper.this._elements.indexOf(previous) + 1, object);
                objects.add(objects.indexOf(previous) + 1, object);
            }
        }

        public T getInitialObject() {
            return this._initialObject;
        }
    }
}

