/*
 * Decompiled with CFR 0.152.
 */
package org.ametys.core.user;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import org.ametys.core.user.User;
import org.ametys.core.user.UserIdentity;
import org.ametys.core.user.directory.NotUniqueUserException;
import org.ametys.core.user.directory.UserDirectory;
import org.ametys.core.user.population.PopulationContextHelper;
import org.ametys.core.user.population.UserPopulation;
import org.ametys.core.user.population.UserPopulationDAO;
import org.ametys.runtime.plugin.component.AbstractLogEnabled;
import org.apache.avalon.framework.component.Component;
import org.apache.avalon.framework.service.ServiceException;
import org.apache.avalon.framework.service.ServiceManager;
import org.apache.avalon.framework.service.Serviceable;

public class UserManager
extends AbstractLogEnabled
implements Component,
Serviceable {
    public static final String ROLE = UserManager.class.getName();
    protected UserPopulationDAO _userPopulationDAO;
    protected PopulationContextHelper _populationContextHelper;

    public void service(ServiceManager manager) throws ServiceException {
        this._userPopulationDAO = (UserPopulationDAO)manager.lookup(UserPopulationDAO.ROLE);
        this._populationContextHelper = (PopulationContextHelper)manager.lookup(PopulationContextHelper.ROLE);
    }

    public Collection<User> getUsersByContext(Set<String> contexts, boolean checkRight) {
        List<UserPopulation> userPopulations = this._populationContextHelper.getUserPopulationsOnContexts(contexts, false, checkRight).stream().map(upId -> this._userPopulationDAO.getUserPopulation((String)upId)).collect(Collectors.toList());
        return this.getUsersByPopulations(userPopulations);
    }

    public Collection<User> getUsersByPopulationIds(List<String> userPopulationIds) {
        ArrayList<User> users = new ArrayList<User>();
        for (String id : userPopulationIds) {
            UserPopulation userPopulation = this._userPopulationDAO.getUserPopulation(id);
            if (userPopulation == null) continue;
            for (User user : this.getUsers(userPopulation)) {
                if (users.contains(user)) continue;
                users.add(user);
            }
        }
        return users;
    }

    public Collection<User> getUsersByPopulations(List<UserPopulation> userPopulations) {
        ArrayList<User> users = new ArrayList<User>();
        for (UserPopulation userPopulation : userPopulations) {
            for (User user : this.getUsers(userPopulation)) {
                if (users.contains(user)) continue;
                users.add(user);
            }
        }
        return users;
    }

    public Collection<User> getUsers(String userPopulationId) {
        UserPopulation userPopulation = this._userPopulationDAO.getUserPopulation(userPopulationId);
        if (userPopulation != null) {
            return this.getUsers(userPopulation);
        }
        return Collections.EMPTY_LIST;
    }

    public Collection<User> getUsers(UserPopulation userPopulation) {
        ArrayList<User> users = new ArrayList<User>();
        for (UserDirectory ud : userPopulation.getUserDirectories()) {
            for (User user : ud.getUsers()) {
                if (users.contains(user)) continue;
                users.add(user);
            }
        }
        return users;
    }

    public List<User> getUsersByContext(Set<String> contexts, int count, int offset, Map<String, Object> parameters, boolean checkRight) {
        List<UserPopulation> userPopulations = this._populationContextHelper.getUserPopulationsOnContexts(contexts, false, checkRight).stream().map(upId -> this._userPopulationDAO.getUserPopulation((String)upId)).collect(Collectors.toList());
        return this.getUsers(userPopulations, count, offset, parameters);
    }

    public List<User> getUsers(List<UserPopulation> userPopulations, int count, int offset, Map<String, Object> parameters) {
        ArrayList<User> users = new ArrayList<User>();
        for (UserPopulation userPopulation : userPopulations) {
            for (User user : this.getUsers(userPopulation, -1, 0, parameters)) {
                if (users.contains(user)) continue;
                users.add(user);
            }
        }
        int boundedCount = count >= 0 ? count : Integer.MAX_VALUE;
        int boundedOffset = offset >= 0 ? offset : 0;
        int toIndex = boundedOffset + boundedCount >= 0 ? Math.min(boundedOffset + boundedCount, users.size()) : users.size();
        return users.subList(boundedOffset, toIndex);
    }

    public Collection<User> getUsers(String userPopulationId, int count, int offset, Map<String, Object> parameters) {
        UserPopulation userPopulation = this._userPopulationDAO.getUserPopulation(userPopulationId);
        if (userPopulation != null) {
            return this.getUsers(userPopulation, count, offset, parameters);
        }
        return Collections.EMPTY_LIST;
    }

    public Collection<User> getUsersByDirectory(String userPopulationId, String userDirectoryId, int count, int offset, Map<String, Object> parameters) {
        UserPopulation userPopulation = this._userPopulationDAO.getUserPopulation(userPopulationId);
        if (userPopulation == null) {
            return Collections.EMPTY_LIST;
        }
        UserDirectory ud = userPopulation.getUserDirectory(userDirectoryId);
        if (ud == null) {
            throw new IllegalArgumentException("In the population '" + userPopulationId + "' the directory '" + userDirectoryId + "' was referenced but does not exists");
        }
        return ud.getUsers(count, offset, parameters);
    }

    public Collection<User> getUsers(UserPopulation userPopulation, int count, int offset, Map<String, Object> parameters) {
        ArrayList<User> users = new ArrayList<User>();
        for (UserDirectory ud : userPopulation.getUserDirectories()) {
            for (User user : ud.getUsers(-1, 0, parameters)) {
                if (users.contains(user)) continue;
                users.add(user);
            }
        }
        int boundedCount = count >= 0 ? count : Integer.MAX_VALUE;
        int boundedOffset = offset >= 0 ? offset : 0;
        int toIndex = boundedOffset + boundedCount >= 0 ? Math.min(boundedOffset + boundedCount, users.size()) : users.size();
        return users.subList(boundedOffset, toIndex);
    }

    public Collection<User> getUsersByDirectory(UserPopulation userPopulation, String userDirectoryId, int count, int offset, Map<String, Object> parameters) {
        UserDirectory ud = userPopulation.getUserDirectory(userDirectoryId);
        return ud.getUsers(count, offset, parameters);
    }

    public User getUserByContext(Set<String> contexts, String login, boolean checkRight) {
        Set<String> upIds = this._populationContextHelper.getUserPopulationsOnContexts(contexts, false, checkRight);
        for (String upId : upIds) {
            UserPopulation userPopulation = this._userPopulationDAO.getUserPopulation(upId);
            User user = this.getUser(userPopulation, login);
            if (user == null) continue;
            return user;
        }
        return null;
    }

    public User getUser(UserIdentity userIdentity) {
        return this.getUser(userIdentity.getPopulationId(), userIdentity.getLogin());
    }

    public User getUser(String userPopulationId, String login) {
        UserPopulation userPopulation = this._userPopulationDAO.getUserPopulation(userPopulationId);
        if (userPopulation != null) {
            return this.getUser(userPopulation, login);
        }
        return null;
    }

    public User getUserByEmail(String userPopulationId, String email) throws NotUniqueUserException {
        UserPopulation userPopulation = this._userPopulationDAO.getUserPopulation(userPopulationId);
        if (userPopulation != null) {
            return this.getUserByEmail(userPopulation, email);
        }
        return null;
    }

    public User getUserByDirectory(String userPopulationId, String userDirectoryId, String login) {
        UserPopulation userPopulation = this._userPopulationDAO.getUserPopulation(userPopulationId);
        if (userPopulation != null) {
            return this.getUserByDirectory(userPopulation, userDirectoryId, login);
        }
        return null;
    }

    public User getUser(UserPopulation userPopulation, String login) {
        for (UserDirectory ud : userPopulation.getUserDirectories()) {
            User user = ud.getUser(login);
            if (user == null) continue;
            return user;
        }
        return null;
    }

    public User getUserByEmail(UserPopulation userPopulation, String email) throws NotUniqueUserException {
        for (UserDirectory ud : userPopulation.getUserDirectories()) {
            User user = ud.getUserByEmail(email);
            if (user == null) continue;
            return user;
        }
        return null;
    }

    public User getUserByDirectory(UserPopulation userPopulation, String userDirectoryId, String login) {
        UserDirectory ud = userPopulation.getUserDirectory(userDirectoryId);
        User user = ud.getUser(login);
        if (user != null) {
            return user;
        }
        return null;
    }

    public UserDirectory getUserDirectory(String userPopulationId, String login) {
        UserPopulation userPopulation = this._userPopulationDAO.getUserPopulation(userPopulationId);
        if (userPopulation == null) {
            return null;
        }
        for (UserDirectory ud : userPopulation.getUserDirectories()) {
            User user = ud.getUser(login);
            if (user == null) continue;
            return ud;
        }
        return null;
    }
}

