/*
 * Decompiled with CFR 0.152.
 */
package org.ametys.core.user.population;

import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import org.ametys.core.authentication.CredentialProvider;
import org.ametys.core.user.directory.UserDirectory;
import org.ametys.runtime.i18n.I18nizableText;
import org.apache.cocoon.components.LifecycleHelper;
import org.apache.commons.lang3.StringUtils;

public class UserPopulation {
    protected String _id;
    protected I18nizableText _label;
    protected boolean _enabled = true;
    protected List<UserDirectory> _userDirectories = new ArrayList<UserDirectory>();
    protected List<CredentialProvider> _credentialProviders = new ArrayList<CredentialProvider>();

    public I18nizableText getLabel() {
        return this._label;
    }

    public void setLabel(I18nizableText label) {
        this._label = label;
    }

    public boolean isEnabled() {
        return this._enabled;
    }

    public void enable(boolean enabled) {
        this._enabled = enabled;
    }

    public String getId() {
        return this._id;
    }

    public void setId(String id) {
        this._id = id;
    }

    public List<UserDirectory> getUserDirectories() {
        return this._userDirectories;
    }

    public UserDirectory getUserDirectory(String id) {
        Optional<UserDirectory> findAny = this._userDirectories.stream().filter(ud -> StringUtils.equals((CharSequence)ud.getId(), (CharSequence)id)).findAny();
        if (findAny.isPresent()) {
            return findAny.get();
        }
        return null;
    }

    public void setUserDirectories(List<UserDirectory> userDirectories) {
        this.resetUserDirectories();
        this._userDirectories = userDirectories;
    }

    public void resetUserDirectories() {
        this._userDirectories.clear();
    }

    public List<CredentialProvider> getCredentialProviders() {
        return this._credentialProviders;
    }

    public CredentialProvider getCredentialProvider(String id) {
        Optional<CredentialProvider> findAny = this._credentialProviders.stream().filter(cp -> StringUtils.equals((CharSequence)cp.getId(), (CharSequence)id)).findAny();
        if (findAny.isPresent()) {
            return findAny.get();
        }
        return null;
    }

    public void setCredentialProviders(List<CredentialProvider> credentialProviders) {
        this.resetCredentialProviders();
        this._credentialProviders = credentialProviders;
    }

    public void resetCredentialProviders() {
        this._credentialProviders.clear();
    }

    public void dispose() {
        for (UserDirectory ud : this._userDirectories) {
            LifecycleHelper.dispose((Object)ud);
        }
        this.resetUserDirectories();
        for (CredentialProvider cp : this._credentialProviders) {
            LifecycleHelper.dispose((Object)cp);
        }
        this.resetCredentialProviders();
    }

    public String toString() {
        return super.toString() + "[" + this._id + "]";
    }
}

