/*
 * Decompiled with CFR 0.152.
 */
package org.ametys.core.util.dom;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.ametys.core.util.dom.AbstractAmetysElement;
import org.ametys.core.util.dom.AmetysAttribute;
import org.ametys.core.util.dom.AmetysNodeList;
import org.ametys.core.util.dom.StringElement;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class MapElement
extends AbstractAmetysElement {
    private Map<String, ? extends Object> _values;
    private Map<String, String> _attributes;

    public MapElement(String tagName, Map<String, ? extends Object> values) {
        this(tagName, Collections.emptyMap(), values);
    }

    public MapElement(String tagName, Map<String, String> attributes, Map<String, ? extends Object> values) {
        super(tagName);
        this._values = values;
        this._attributes = attributes;
    }

    public MapElement(String tagName, Map<String, ? extends Object> values, Element parent) {
        super(tagName, parent);
        this._values = values;
    }

    public MapElement(String tagName, Map<String, String> attributes, Map<String, ? extends Object> values, Element parent) {
        super(tagName, parent);
        this._values = values;
        this._attributes = attributes;
    }

    @Override
    protected Map<String, AmetysAttribute> _lookupAttributes() {
        HashMap<String, AmetysAttribute> attrs = new HashMap<String, AmetysAttribute>();
        if (this._attributes != null) {
            for (String name : this._attributes.keySet()) {
                attrs.put(name, new AmetysAttribute(name, name, null, this._attributes.get(name), this));
            }
        }
        return attrs;
    }

    @Override
    public Node getFirstChild() {
        NodeList list = this.getChildNodes();
        if (list.getLength() == 0) {
            return null;
        }
        return list.item(0);
    }

    @Override
    protected NodeList _getChildNodes() {
        ArrayList<AbstractAmetysElement> list = new ArrayList<AbstractAmetysElement>();
        if (this._values != null) {
            for (Map.Entry<String, ? extends Object> entry : this._values.entrySet()) {
                Object rawValue = entry.getValue();
                ArrayList<Object> values = new ArrayList<Object>();
                if (rawValue instanceof List) {
                    values.addAll((List)rawValue);
                } else {
                    values.add(rawValue);
                }
                Iterator iterator = values.iterator();
                while (iterator.hasNext()) {
                    Object value;
                    Object realValue = value = iterator.next();
                    Map<String, String> attributes = null;
                    if (value instanceof MapNode) {
                        realValue = ((MapNode)value).getValue();
                        attributes = ((MapNode)value).getAttributes();
                    }
                    if (realValue == null) {
                        list.add(new StringElement(entry.getKey(), attributes, "", (Element)this));
                        continue;
                    }
                    if (realValue instanceof String) {
                        list.add(new StringElement(entry.getKey(), attributes, (String)realValue, (Element)this));
                        continue;
                    }
                    if (realValue instanceof Map) {
                        list.add(new MapElement(entry.getKey(), attributes, (Map)realValue, this));
                        continue;
                    }
                    throw new IllegalArgumentException("MapElement only handles String, List<Object> or Map<String, Object> recursively");
                }
            }
        }
        return new AmetysNodeList(list);
    }

    public static class MapNode {
        private Object _value;
        private Map<String, String> _attrs;

        public MapNode(Object value, Map<String, String> attributes) {
            this._value = value;
            this._attrs = attributes;
        }

        public Map<String, String> getAttributes() {
            return this._attrs;
        }

        public Object getValue() {
            return this._value;
        }
    }
}

