/*
 * Decompiled with CFR 0.152.
 */
package org.ametys.plugins.core.impl.group.directory.jdbc;

import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.ametys.core.datasource.ConnectionHelper;
import org.ametys.core.group.Group;
import org.ametys.core.group.GroupIdentity;
import org.ametys.core.group.InvalidModificationException;
import org.ametys.core.group.ModifiableGroup;
import org.ametys.core.group.directory.GroupDirectory;
import org.ametys.core.group.directory.ModifiableGroupDirectory;
import org.ametys.core.observation.Event;
import org.ametys.core.observation.ObservationManager;
import org.ametys.core.script.SQLScriptHelper;
import org.ametys.core.user.CurrentUserProvider;
import org.ametys.core.user.UserIdentity;
import org.ametys.core.util.CachingComponent;
import org.ametys.runtime.i18n.I18nizableText;
import org.apache.avalon.framework.service.ServiceException;
import org.apache.avalon.framework.service.ServiceManager;
import org.apache.avalon.framework.service.Serviceable;
import org.apache.commons.lang3.ArrayUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.excalibur.source.SourceResolver;

public class JdbcGroupDirectory
extends CachingComponent<UserIdentity, Set<String>>
implements ModifiableGroupDirectory,
Serviceable {
    private static final String __DATASOURCE_PARAM_NAME = "runtime.groups.jdbc.datasource";
    private static final String __GROUPS_LIST_TABLE_PARAM_NAME = "runtime.groups.jdbc.list.table";
    private static final String __GROUPS_COMPOSITION_TABLE_PARAM_NAME = "runtime.groups.jdbc.composition.table";
    private static final String __GROUPS_LIST_COLUMN_ID = "Id";
    private static final String __GROUPS_LIST_COLUMN_LABEL = "Label";
    private static final String __GROUPS_COMPOSITION_COLUMN_GROUPID = "Group_Id";
    private static final String __GROUPS_COMPOSITION_COLUMN_LOGIN = "Login";
    private static final String __GROUPS_COMPOSITION_COLUMN_POPULATIONID = "UserPopulation_Id";
    protected ObservationManager _observationManager;
    protected CurrentUserProvider _currentUserProvider;
    protected SourceResolver _sourceResolver;
    protected String _dataSourceId;
    protected String _groupsListTableName;
    protected String _groupsCompositionTableName;
    protected String _id;
    protected I18nizableText _label;
    private String _groupDirectoryModelId;
    private Map<String, Object> _paramValues;
    private boolean _lazyInitialized;

    public void service(ServiceManager manager) throws ServiceException {
        this._observationManager = (ObservationManager)((Object)manager.lookup(ObservationManager.ROLE));
        this._currentUserProvider = (CurrentUserProvider)manager.lookup(CurrentUserProvider.ROLE);
        this._sourceResolver = (SourceResolver)manager.lookup(SourceResolver.ROLE);
    }

    @Override
    public String getId() {
        return this._id;
    }

    @Override
    public I18nizableText getLabel() {
        return this._label;
    }

    @Override
    public void setId(String id) {
        this._id = id;
    }

    @Override
    public void setLabel(I18nizableText label) {
        this._label = label;
    }

    @Override
    public String getGroupDirectoryModelId() {
        return this._groupDirectoryModelId;
    }

    @Override
    public Map<String, Object> getParameterValues() {
        return this._paramValues;
    }

    @Override
    public void init(String groupDirectoryModelId, Map<String, Object> paramValues) {
        this._groupDirectoryModelId = groupDirectoryModelId;
        this._paramValues = paramValues;
        this._groupsListTableName = (String)paramValues.get(__GROUPS_LIST_TABLE_PARAM_NAME);
        this._groupsCompositionTableName = (String)paramValues.get(__GROUPS_COMPOSITION_TABLE_PARAM_NAME);
        this._dataSourceId = (String)paramValues.get(__DATASOURCE_PARAM_NAME);
    }

    protected Connection getSQLConnection() {
        Connection connection = ConnectionHelper.getConnection(this._dataSourceId);
        if (!this._lazyInitialized) {
            try {
                SQLScriptHelper.createTableIfNotExists(connection, this._groupsListTableName, "plugin:core://scripts/%s/jdbc_groups.template.sql", this._sourceResolver, (Map<String, String>)ArrayUtils.toMap((Object[])new String[][]{{"%TABLENAME%", this._groupsListTableName}, {"%TABLENAME_COMPOSITION%", this._groupsCompositionTableName}}));
            }
            catch (Exception e) {
                this.getLogger().error("The tables requires by the " + this.getClass().getName() + " could not be created. A degraded behavior will occur", (Throwable)e);
            }
            this._lazyInitialized = true;
        }
        return connection;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     */
    @Override
    public ModifiableGroup getGroup(String groupID) {
        JdbcGroup group = null;
        Connection connection = null;
        PreparedStatement stmt = null;
        ResultSet rs = null;
        try {
            connection = this.getSQLConnection();
            String sql = "SELECT Label FROM " + this._groupsListTableName + " WHERE " + __GROUPS_LIST_COLUMN_ID + " =  ?";
            stmt = connection.prepareStatement(sql);
            stmt.setInt(1, Integer.parseInt(groupID));
            if (this.getLogger().isDebugEnabled()) {
                this.getLogger().debug(sql);
            }
            if ((rs = stmt.executeQuery()).next()) {
                String label = rs.getString(__GROUPS_LIST_COLUMN_LABEL);
                group = new JdbcGroup(new GroupIdentity(groupID, this.getId()), label, this);
                this._fillGroup(group, connection);
            }
            ConnectionHelper.cleanup(rs);
        }
        catch (NumberFormatException e) {
            this.getLogger().error("Group ID must be an integer.", (Throwable)e);
            ModifiableGroup modifiableGroup = null;
            return modifiableGroup;
        }
        catch (SQLException e2) {
            this.getLogger().error("Error communication with database", (Throwable)e2);
            ModifiableGroup modifiableGroup = null;
            return modifiableGroup;
            {
                catch (Throwable throwable) {
                    throw throwable;
                }
            }
        }
        finally {
            ConnectionHelper.cleanup(rs);
            ConnectionHelper.cleanup(stmt);
            ConnectionHelper.cleanup(connection);
        }
        ConnectionHelper.cleanup(stmt);
        ConnectionHelper.cleanup(connection);
        return group;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Set<Group> getGroups() {
        LinkedHashSet<Group> groups = new LinkedHashSet<Group>();
        Connection connection = null;
        Statement stmt = null;
        ResultSet rs = null;
        try {
            connection = this.getSQLConnection();
            stmt = connection.createStatement();
            String sql = this._createGetGroupsClause();
            if (this.getLogger().isDebugEnabled()) {
                this.getLogger().debug(sql);
            }
            rs = stmt.executeQuery(sql);
            while (rs.next()) {
                String groupID = rs.getString(__GROUPS_LIST_COLUMN_ID);
                String label = rs.getString(__GROUPS_LIST_COLUMN_LABEL);
                JdbcGroup group = new JdbcGroup(new GroupIdentity(groupID, this.getId()), label, this);
                this._fillGroup(group, connection);
                groups.add(group);
            }
            ConnectionHelper.cleanup(rs);
        }
        catch (SQLException e) {
            this.getLogger().error("Error communication with database", (Throwable)e);
            Set<Group> set = Collections.emptySet();
            return set;
        }
        finally {
            ConnectionHelper.cleanup(rs);
            ConnectionHelper.cleanup(stmt);
            ConnectionHelper.cleanup(connection);
        }
        ConnectionHelper.cleanup(stmt);
        ConnectionHelper.cleanup(connection);
        return groups;
    }

    protected String _createGetGroupsClause() {
        return "SELECT Id, Label FROM " + this._groupsListTableName + " ORDER BY " + __GROUPS_LIST_COLUMN_LABEL;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void _fillGroup(JdbcGroup group, Connection connection) throws SQLException {
        PreparedStatement stmt = null;
        ResultSet rs = null;
        try {
            String sql = "SELECT Login, UserPopulation_Id FROM " + this._groupsCompositionTableName + " WHERE " + __GROUPS_COMPOSITION_COLUMN_GROUPID + " = ?";
            stmt = connection.prepareStatement(sql);
            stmt.setInt(1, Integer.parseInt(group.getIdentity().getId()));
            if (this.getLogger().isDebugEnabled()) {
                this.getLogger().debug(sql);
            }
            rs = stmt.executeQuery();
            while (rs.next()) {
                UserIdentity identity = new UserIdentity(rs.getString(__GROUPS_COMPOSITION_COLUMN_LOGIN), rs.getString(__GROUPS_COMPOSITION_COLUMN_POPULATIONID));
                group.addUser(identity);
            }
        }
        catch (Throwable throwable) {
            ConnectionHelper.cleanup(rs);
            ConnectionHelper.cleanup(stmt);
            throw throwable;
        }
        ConnectionHelper.cleanup(rs);
        ConnectionHelper.cleanup(stmt);
    }

    @Override
    public Set<String> getUserGroups(UserIdentity userIdentity) {
        Set userGroups;
        if (this.isCacheEnabled() && (userGroups = (Set)this.getObjectFromCache(userIdentity)) != null) {
            return userGroups;
        }
        userGroups = this._executeSqlForUserGroups(userIdentity);
        if (this.isCacheEnabled()) {
            this.addObjectInCache(userIdentity, userGroups);
        }
        return userGroups;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Set<String> _executeSqlForUserGroups(UserIdentity userIdentity) {
        String login = userIdentity.getLogin();
        String populationId = userIdentity.getPopulationId();
        HashSet<String> groups = new HashSet<String>();
        if (login == null) {
            return groups;
        }
        Connection connection = null;
        PreparedStatement stmt = null;
        ResultSet rs = null;
        try {
            connection = this.getSQLConnection();
            String sql = "SELECT Group_Id FROM " + this._groupsCompositionTableName + " WHERE " + __GROUPS_COMPOSITION_COLUMN_LOGIN + " = ? AND " + __GROUPS_COMPOSITION_COLUMN_POPULATIONID + " = ?";
            stmt = connection.prepareStatement(sql);
            stmt.setString(1, login);
            stmt.setString(2, populationId);
            if (this.getLogger().isDebugEnabled()) {
                this.getLogger().debug(sql);
            }
            rs = stmt.executeQuery();
            while (rs.next()) {
                String groupID = rs.getString(__GROUPS_COMPOSITION_COLUMN_GROUPID);
                groups.add(groupID);
            }
            ConnectionHelper.cleanup(rs);
        }
        catch (SQLException e) {
            this.getLogger().error("Error communication with database", (Throwable)e);
            Set<String> set = Collections.emptySet();
            return set;
        }
        finally {
            ConnectionHelper.cleanup(rs);
            ConnectionHelper.cleanup(stmt);
            ConnectionHelper.cleanup(connection);
        }
        ConnectionHelper.cleanup(stmt);
        ConnectionHelper.cleanup(connection);
        return groups;
    }

    @Override
    public List<Map<String, Object>> groups2JSON(int count, int offset, Map parameters, boolean withUsers) {
        ArrayList<Map<String, Object>> groups = new ArrayList<Map<String, Object>>();
        String pattern = (String)parameters.get("pattern");
        Iterator<Group> iterator = this.getGroups().iterator();
        int currentOffset = offset;
        while (currentOffset > 0 && iterator.hasNext()) {
            Group group = iterator.next();
            if (!StringUtils.isEmpty((CharSequence)pattern) && group.getLabel().toLowerCase().indexOf(pattern.toLowerCase()) == -1 && (group.getIdentity() == null || group.getIdentity().getId().toLowerCase().indexOf(pattern.toLowerCase()) == -1)) continue;
            --currentOffset;
        }
        int currentCount = count;
        while ((count == -1 || currentCount > 0) && iterator.hasNext()) {
            Group group = iterator.next();
            if (!StringUtils.isEmpty((CharSequence)pattern) && group.getLabel().toLowerCase().indexOf(pattern.toLowerCase()) == -1 && (group.getIdentity() == null || group.getIdentity().getId().toLowerCase().indexOf(pattern.toLowerCase()) == -1)) continue;
            groups.add(this._group2JSON(group, withUsers));
            --currentCount;
        }
        return groups;
    }

    @Override
    public Map<String, Object> group2JSON(String id, boolean withUsers) {
        ModifiableGroup group = this.getGroup(id);
        return this._group2JSON(group, withUsers);
    }

    protected Map<String, Object> _group2JSON(Group group, boolean users) {
        HashMap<String, Object> group2json = new HashMap<String, Object>();
        group2json.put("id", group.getIdentity().getId());
        group2json.put("groupDirectory", group.getIdentity().getDirectoryId());
        group2json.put("groupDirectoryLabel", group.getGroupDirectory().getLabel());
        group2json.put("label", group.getLabel());
        if (users) {
            group2json.put("users", group.getUsers());
        }
        return group2json;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public ModifiableGroup add(String name) throws InvalidModificationException {
        Connection connection = null;
        PreparedStatement statement = null;
        ResultSet rs = null;
        String id = null;
        try {
            block19: {
                connection = this.getSQLConnection();
                String dbType = ConnectionHelper.getDatabaseType(connection);
                if ("oracle".equals(dbType)) {
                    statement = connection.prepareStatement("SELECT seq_" + this._groupsListTableName + ".nextval FROM dual");
                    rs = statement.executeQuery();
                    if (rs.next()) {
                        id = rs.getString(1);
                    }
                    ConnectionHelper.cleanup(rs);
                    ConnectionHelper.cleanup(statement);
                    statement = connection.prepareStatement("INSERT INTO " + this._groupsListTableName + " (Id, Label) VALUES(?, ?)");
                    statement.setString(1, id);
                    statement.setString(2, name);
                } else {
                    statement = connection.prepareStatement("INSERT INTO " + this._groupsListTableName + " (" + __GROUPS_LIST_COLUMN_LABEL + ") VALUES (?)");
                    statement.setString(1, name);
                }
                statement.executeUpdate();
                ConnectionHelper.cleanup(statement);
                if ("mysql".equals(dbType)) {
                    statement = connection.prepareStatement("SELECT Id FROM " + this._groupsListTableName + " WHERE " + __GROUPS_LIST_COLUMN_ID + " = last_insert_id()");
                    rs = statement.executeQuery();
                    if (rs.next()) {
                        id = rs.getString(__GROUPS_LIST_COLUMN_ID);
                        break block19;
                    } else {
                        if (connection.getAutoCommit()) {
                            throw new InvalidModificationException("Cannot retrieve inserted group. Group was created but listeners not called : base may be inconsistant");
                        }
                        connection.rollback();
                        throw new InvalidModificationException("Cannot retrieve inserted group. Rolling back");
                    }
                }
                if ("derby".equals(dbType)) {
                    statement = connection.prepareStatement("VALUES IDENTITY_VAL_LOCAL ()");
                    rs = statement.executeQuery();
                    if (rs.next()) {
                        id = rs.getString(1);
                    }
                } else if ("hsqldb".equals(dbType)) {
                    statement = connection.prepareStatement("CALL IDENTITY ()");
                    rs = statement.executeQuery();
                    if (rs.next()) {
                        id = rs.getString(1);
                    }
                } else if ("postgresql".equals(dbType) && (rs = (statement = connection.prepareStatement("SELECT currval('groups_id_seq')")).executeQuery()).next()) {
                    id = rs.getString(1);
                }
            }
            if (id != null) {
                HashMap<String, Object> eventParams = new HashMap<String, Object>();
                eventParams.put("group", new GroupIdentity(id, this.getId()));
                this._observationManager.notify(new Event("group.added", this._currentUserProvider.getUser(), eventParams));
            }
        }
        catch (SQLException ex) {
            try {
                throw new RuntimeException(ex);
            }
            catch (Throwable throwable) {
                ConnectionHelper.cleanup(rs);
                ConnectionHelper.cleanup(statement);
                ConnectionHelper.cleanup(connection);
                throw throwable;
            }
        }
        ConnectionHelper.cleanup(rs);
        ConnectionHelper.cleanup(statement);
        ConnectionHelper.cleanup(connection);
        return new JdbcGroup(new GroupIdentity(id, this.getId()), name, this);
    }

    /*
     * Loose catch block
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public void update(ModifiableGroup userGroup) throws InvalidModificationException {
        Connection connection = null;
        PreparedStatement statement = null;
        try {
            connection = this.getSQLConnection();
            connection.setAutoCommit(false);
            statement = connection.prepareStatement("UPDATE " + this._groupsListTableName + " SET " + __GROUPS_LIST_COLUMN_LABEL + "=? WHERE " + __GROUPS_LIST_COLUMN_ID + " = ?");
            statement.setString(1, userGroup.getLabel());
            statement.setInt(2, Integer.parseInt(userGroup.getIdentity().getId()));
            if (statement.executeUpdate() == 0) {
                throw new InvalidModificationException("No group with id '" + userGroup.getIdentity().getId() + "' may be removed");
            }
            ConnectionHelper.cleanup(statement);
            statement = connection.prepareStatement("DELETE FROM " + this._groupsCompositionTableName + " WHERE " + __GROUPS_COMPOSITION_COLUMN_GROUPID + " = ?");
            statement.setInt(1, Integer.parseInt(userGroup.getIdentity().getId()));
            statement.executeUpdate();
            ConnectionHelper.cleanup(statement);
            if (!userGroup.getUsers().isEmpty()) {
                boolean supportsBatch = connection.getMetaData().supportsBatchUpdates();
                statement = connection.prepareStatement("INSERT INTO " + this._groupsCompositionTableName + " (" + __GROUPS_COMPOSITION_COLUMN_GROUPID + ", " + __GROUPS_COMPOSITION_COLUMN_LOGIN + ", " + __GROUPS_COMPOSITION_COLUMN_POPULATIONID + ") VALUES (?, ?, ?)");
                for (UserIdentity identity : userGroup.getUsers()) {
                    String login = identity.getLogin();
                    String populationId = identity.getPopulationId();
                    statement.setInt(1, Integer.parseInt(userGroup.getIdentity().getId()));
                    statement.setString(2, login);
                    statement.setString(3, populationId);
                    if (supportsBatch) {
                        statement.addBatch();
                        continue;
                    }
                    statement.executeUpdate();
                }
                if (supportsBatch) {
                    statement.executeBatch();
                }
            }
            ConnectionHelper.cleanup(statement);
            connection.commit();
            this.clearCache();
            HashMap<String, Object> eventParams = new HashMap<String, Object>();
            eventParams.put("group", userGroup.getIdentity());
            this._observationManager.notify(new Event("group.updated", this._currentUserProvider.getUser(), eventParams));
        }
        catch (NumberFormatException ex) {
            try {
                throw new InvalidModificationException("No group with id '" + userGroup.getIdentity().getId() + "' may be removed", ex);
                catch (SQLException ex2) {
                    throw new RuntimeException(ex2);
                }
            }
            catch (Throwable throwable) {
                ConnectionHelper.cleanup(statement);
                ConnectionHelper.cleanup(connection);
                throw throwable;
            }
        }
        ConnectionHelper.cleanup(statement);
        ConnectionHelper.cleanup(connection);
    }

    /*
     * Loose catch block
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public void remove(String groupID) throws InvalidModificationException {
        Connection connection = null;
        PreparedStatement statement = null;
        try {
            connection = this.getSQLConnection();
            statement = connection.prepareStatement("DELETE FROM " + this._groupsListTableName + " WHERE " + __GROUPS_LIST_COLUMN_ID + " = ?");
            statement.setInt(1, Integer.parseInt(groupID));
            if (statement.executeUpdate() == 0) {
                throw new InvalidModificationException("No group with id '" + groupID + "' may be removed");
            }
            ConnectionHelper.cleanup(statement);
            statement = connection.prepareStatement("DELETE FROM " + this._groupsCompositionTableName + " WHERE " + __GROUPS_COMPOSITION_COLUMN_GROUPID + " = ?");
            statement.setInt(1, Integer.parseInt(groupID));
            statement.executeUpdate();
            this.clearCache();
            HashMap<String, Object> eventParams = new HashMap<String, Object>();
            eventParams.put("group", new GroupIdentity(groupID, this.getId()));
            this._observationManager.notify(new Event("group.deleted", this._currentUserProvider.getUser(), eventParams));
        }
        catch (NumberFormatException ex) {
            try {
                throw new InvalidModificationException("No group with id '" + groupID + "' may be removed, the ID must be a number.", ex);
                catch (SQLException ex2) {
                    throw new RuntimeException(ex2);
                }
            }
            catch (Throwable throwable) {
                ConnectionHelper.cleanup(statement);
                ConnectionHelper.cleanup(connection);
                throw throwable;
            }
        }
        ConnectionHelper.cleanup(statement);
        ConnectionHelper.cleanup(connection);
    }

    private static final class JdbcGroup
    implements ModifiableGroup {
        private Set<UserIdentity> _users;
        private GroupIdentity _identity;
        private String _groupLabel;
        private GroupDirectory _groupDirectory;

        JdbcGroup(GroupIdentity identity, String label, GroupDirectory groupDirectory) {
            this._identity = identity;
            this._groupLabel = label;
            this._groupDirectory = groupDirectory;
            this._users = new HashSet<UserIdentity>();
        }

        @Override
        public GroupIdentity getIdentity() {
            return this._identity;
        }

        @Override
        public String getLabel() {
            return this._groupLabel;
        }

        @Override
        public GroupDirectory getGroupDirectory() {
            return this._groupDirectory;
        }

        @Override
        public void setLabel(String label) {
            this._groupLabel = label;
        }

        @Override
        public void addUser(UserIdentity user) {
            this._users.add(user);
        }

        @Override
        public void removeUser(UserIdentity user) {
            this._users.remove(user);
        }

        @Override
        public void removeUsers() {
            this._users.clear();
        }

        @Override
        public Set<UserIdentity> getUsers() {
            return this._users;
        }

        public String toString() {
            StringBuffer sb = new StringBuffer("UserGroup[");
            sb.append(this._identity);
            sb.append(" (");
            sb.append(this._groupLabel);
            sb.append(") => ");
            sb.append(this._users.toString());
            sb.append("]");
            return sb.toString();
        }

        public boolean equals(Object another) {
            if (another == null || !(another instanceof JdbcGroup)) {
                return false;
            }
            JdbcGroup otherGroup = (JdbcGroup)another;
            return this._identity != null && this._identity.equals(otherGroup.getIdentity());
        }

        public int hashCode() {
            return this._identity.hashCode();
        }
    }
}

