/*
 * Decompiled with CFR 0.152.
 */
package org.ametys.plugins.core.impl.right;

import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import org.ametys.core.group.GroupIdentity;
import org.ametys.core.right.AccessController;
import org.ametys.core.user.UserIdentity;
import org.ametys.plugins.core.impl.right.AbstractProfileStorageBasedAccessController;

public abstract class AbstractHierarchicalAccessController<T>
extends AbstractProfileStorageBasedAccessController {
    protected abstract Set<T> _getParents(T var1);

    @Override
    public Map<String, AccessController.AccessResult> getPermissionByRight(UserIdentity user, Set<GroupIdentity> userGroups, Object object) {
        Map<String, AccessController.AccessResult> permissions = super.getPermissionByRight(user, userGroups, object);
        Set<Object> parents = this._getParents(object);
        if (parents != null) {
            HashMap<String, AccessController.AccessResult> parentsPermissions = new HashMap<String, AccessController.AccessResult>();
            for (Object parent : parents) {
                Map<String, AccessController.AccessResult> parentPermissions = this.getPermissionByRight(user, userGroups, parent);
                for (String rightId : parentPermissions.keySet()) {
                    parentsPermissions.put(rightId, AccessController.AccessResult.merge(parentPermissions.get(rightId), (AccessController.AccessResult)((Object)parentsPermissions.get(rightId))));
                }
            }
            for (String rightId : parentsPermissions.keySet()) {
                if (permissions.containsKey(rightId) && permissions.get(rightId) != AccessController.AccessResult.UNKNOWN) continue;
                permissions.put(rightId, (AccessController.AccessResult)((Object)parentsPermissions.get(rightId)));
            }
        }
        return permissions;
    }

    @Override
    protected AccessController.AccessResult _getPermission(UserIdentity user, Set<GroupIdentity> userGroups, Set<String> profilesIds, Object object, Object convertedObject) {
        Set<Object> parents;
        Map cacheResult = (Map)this._hasRightResultInSecondCache(convertedObject, profilesIds, AbstractProfileStorageBasedAccessController.CacheKind.USER);
        if (cacheResult != null && cacheResult.containsKey(user)) {
            return (AccessController.AccessResult)((Object)cacheResult.get(user));
        }
        AccessController.AccessResult permission = super._getPermission(user, userGroups, profilesIds, object, convertedObject);
        if (permission == AccessController.AccessResult.UNKNOWN && (parents = this._getParents(object)) != null) {
            for (Object parent : parents) {
                Object convertedParentObject = this._convertContext(parent);
                AccessController.AccessResult parentResult = this._getPermission(user, userGroups, profilesIds, parent, convertedParentObject);
                permission = AccessController.AccessResult.merge(permission, parentResult);
            }
            if (permission != AccessController.AccessResult.UNKNOWN) {
                if (cacheResult == null) {
                    cacheResult = (Map)this._hasRightResultInSecondCache(convertedObject, profilesIds, AbstractProfileStorageBasedAccessController.CacheKind.USER);
                    cacheResult = cacheResult == null ? new HashMap() : cacheResult;
                }
                cacheResult.put(user, permission);
                this._putInSecondCache(profilesIds, convertedObject, cacheResult, AbstractProfileStorageBasedAccessController.CacheKind.USER);
            }
        }
        return permission;
    }

    @Override
    protected AccessController.AccessResult _getPermissionForAnonymous(Set<String> profilesIds, Object object, Object convertedObject) {
        Set<Object> parents;
        AccessController.AccessResult cacheResult = (AccessController.AccessResult)((Object)this._hasRightResultInSecondCache(convertedObject, profilesIds, AbstractProfileStorageBasedAccessController.CacheKind.ANONYMOUS));
        if (cacheResult != null) {
            return cacheResult;
        }
        AccessController.AccessResult permission = super._getPermissionForAnonymous(profilesIds, object, convertedObject);
        if (permission == AccessController.AccessResult.UNKNOWN && (parents = this._getParents(object)) != null) {
            for (Object parent : parents) {
                Object convertedParentObject = this._convertContext(parent);
                AccessController.AccessResult parentResult = this._getPermissionForAnonymous(profilesIds, parent, convertedParentObject);
                permission = AccessController.AccessResult.merge(permission, parentResult);
            }
            if (permission != AccessController.AccessResult.UNKNOWN) {
                this._putInSecondCache(profilesIds, convertedObject, (Object)permission, AbstractProfileStorageBasedAccessController.CacheKind.ANONYMOUS);
            }
        }
        return permission;
    }

    @Override
    protected AccessController.AccessResult _getPermissionForAnyConnectedUser(Set<String> profilesIds, Object object, Object convertedObject) {
        Set<Object> parents;
        AccessController.AccessResult cacheResult = (AccessController.AccessResult)((Object)this._hasRightResultInSecondCache(convertedObject, profilesIds, AbstractProfileStorageBasedAccessController.CacheKind.ANY_CONNECTED_USER));
        if (cacheResult != null) {
            return cacheResult;
        }
        AccessController.AccessResult permission = super._getPermissionForAnyConnectedUser(profilesIds, object, convertedObject);
        if (permission == AccessController.AccessResult.UNKNOWN && (parents = this._getParents(object)) != null) {
            for (Object parent : parents) {
                Object convertedParentObject = this._convertContext(parent);
                AccessController.AccessResult parentResult = this._getPermissionForAnyConnectedUser(profilesIds, parent, convertedParentObject);
                permission = AccessController.AccessResult.merge(permission, parentResult);
            }
            if (permission != AccessController.AccessResult.UNKNOWN) {
                this._putInSecondCache(profilesIds, convertedObject, (Object)permission, AbstractProfileStorageBasedAccessController.CacheKind.ANY_CONNECTED_USER);
            }
        }
        return permission;
    }

    @Override
    protected Map<UserIdentity, AccessController.AccessResult> _getPermissionByUser(Set<String> profilesIds, Object object, Object convertedObject) {
        Map cacheResult = (Map)this._hasRightResultInSecondCache(convertedObject, profilesIds, AbstractProfileStorageBasedAccessController.CacheKind.USERS);
        if (cacheResult != null) {
            return cacheResult;
        }
        Map<UserIdentity, AccessController.AccessResult> permissions = super._getPermissionByUser(profilesIds, object, convertedObject);
        Set<Object> parents = this._getParents(object);
        if (parents != null) {
            HashMap<UserIdentity, AccessController.AccessResult> parentsPermissions = new HashMap<UserIdentity, AccessController.AccessResult>();
            for (Object parent : parents) {
                Object convertedParentObject = this._convertContext(parent);
                Map<UserIdentity, AccessController.AccessResult> parentPermissions = this._getPermissionByUser(profilesIds, parent, convertedParentObject);
                for (UserIdentity user : parentPermissions.keySet()) {
                    parentsPermissions.put(user, AccessController.AccessResult.merge(parentPermissions.get(user), (AccessController.AccessResult)((Object)parentsPermissions.get(user))));
                }
            }
            for (UserIdentity user : parentsPermissions.keySet()) {
                if (permissions.containsKey(user) && permissions.get(user) != AccessController.AccessResult.UNKNOWN) continue;
                permissions.put(user, (AccessController.AccessResult)((Object)parentsPermissions.get(user)));
            }
        }
        this._putInSecondCache(profilesIds, convertedObject, permissions, AbstractProfileStorageBasedAccessController.CacheKind.USERS);
        return permissions;
    }

    @Override
    protected Map<GroupIdentity, AccessController.AccessResult> _getPermissionByGroup(Set<String> profilesIds, Object object, Object convertedObject) {
        Map cacheResult = (Map)this._hasRightResultInSecondCache(convertedObject, profilesIds, AbstractProfileStorageBasedAccessController.CacheKind.GROUPS);
        if (cacheResult != null) {
            return cacheResult;
        }
        Map<GroupIdentity, AccessController.AccessResult> permissions = super._getPermissionByGroup(profilesIds, object, convertedObject);
        Set<Object> parents = this._getParents(object);
        if (parents != null) {
            HashMap<GroupIdentity, AccessController.AccessResult> parentsPermissions = new HashMap<GroupIdentity, AccessController.AccessResult>();
            for (Object parent : parents) {
                Object convertedParentObject = this._convertContext(parent);
                Map<GroupIdentity, AccessController.AccessResult> parentPermissions = this._getPermissionByGroup(profilesIds, parent, convertedParentObject);
                for (GroupIdentity group : parentPermissions.keySet()) {
                    parentsPermissions.put(group, AccessController.AccessResult.merge(parentPermissions.get(group), (AccessController.AccessResult)((Object)parentsPermissions.get(group))));
                }
            }
            for (GroupIdentity group : parentsPermissions.keySet()) {
                if (permissions.containsKey(group) && permissions.get(group) != AccessController.AccessResult.UNKNOWN) continue;
                permissions.put(group, (AccessController.AccessResult)((Object)parentsPermissions.get(group)));
            }
        }
        this._putInSecondCache(profilesIds, convertedObject, permissions, AbstractProfileStorageBasedAccessController.CacheKind.GROUPS);
        return permissions;
    }
}

