/*
 * Decompiled with CFR 0.152.
 */
package org.ametys.plugins.core.impl.schedule;

import org.ametys.core.util.mail.SendMailHelper;
import org.ametys.plugins.core.impl.schedule.AbstractStaticSchedulable;
import org.quartz.JobDataMap;
import org.quartz.JobExecutionContext;

public class SendMailSchedulable
extends AbstractStaticSchedulable {
    public static final String SENDER_KEY = "sender";
    public static final String RECIPIENTS_KEY = "recipients";
    public static final String SUBJECT_KEY = "subject";
    public static final String BODY_KEY = "body";
    public static final String IS_HTML_BODY_KEY = "html";

    @Override
    public void execute(JobExecutionContext context) throws Exception {
        JobDataMap jobDataMap = context.getJobDetail().getJobDataMap();
        String sender = (String)jobDataMap.get((Object)"parameterValues#sender");
        String recipients = (String)jobDataMap.get((Object)"parameterValues#recipients");
        String subject = (String)jobDataMap.get((Object)"parameterValues#subject");
        String body = (String)jobDataMap.get((Object)"parameterValues#body");
        boolean isHtml = jobDataMap.getBoolean("parameterValues#html");
        StringBuilder builder = new StringBuilder();
        for (String recipient : recipients.split("\\n")) {
            if (builder.length() != 0) {
                builder.append(" ");
            }
            builder.append(recipient.trim());
        }
        if (isHtml) {
            SendMailHelper.sendMail(subject, body, null, builder.toString(), sender);
        } else {
            SendMailHelper.sendMail(subject, null, body, builder.toString(), sender);
        }
    }
}

