/*
 * Decompiled with CFR 0.152.
 */
package org.ametys.plugins.core.impl.user.population;

import java.util.ArrayList;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import org.ametys.core.authentication.CredentialProvider;
import org.ametys.core.authentication.CredentialProviderFactory;
import org.ametys.core.authentication.CredentialProviderModel;
import org.ametys.core.datasource.DataSourceConsumer;
import org.ametys.core.user.directory.UserDirectory;
import org.ametys.core.user.directory.UserDirectoryFactory;
import org.ametys.core.user.directory.UserDirectoryModel;
import org.ametys.core.user.population.UserPopulation;
import org.ametys.core.user.population.UserPopulationDAO;
import org.ametys.runtime.model.ElementDefinition;
import org.apache.avalon.framework.component.Component;
import org.apache.avalon.framework.service.ServiceException;
import org.apache.avalon.framework.service.ServiceManager;
import org.apache.avalon.framework.service.Serviceable;

public class PopulationDataSourceConsumer
implements DataSourceConsumer,
Component,
Serviceable {
    public static final String ROLE = PopulationDataSourceConsumer.class.getName();
    private UserPopulationDAO _userPopulationDAO;
    private UserDirectoryFactory _userDirectoryFactory;
    private CredentialProviderFactory _credentialProviderFactory;

    public void service(ServiceManager manager) throws ServiceException {
        this._userPopulationDAO = (UserPopulationDAO)manager.lookup(UserPopulationDAO.ROLE);
        this._userDirectoryFactory = (UserDirectoryFactory)manager.lookup(UserDirectoryFactory.ROLE);
        this._credentialProviderFactory = (CredentialProviderFactory)manager.lookup(CredentialProviderFactory.ROLE);
    }

    @Override
    public boolean isInUse(String id) {
        return "SQL-ametys-internal".equals(id) || this._isInUseByUserDirectories(id) || this._isInUseByCredentialProviders(id);
    }

    private boolean _isInUseByUserDirectories(String id) {
        for (String udModelId : this._userDirectoryFactory.getExtensionsIds()) {
            UserDirectoryModel udModel = this._userDirectoryFactory.getExtension(udModelId);
            ArrayList<String> datasourceParameters = new ArrayList<String>();
            Map<String, ? extends ElementDefinition> parameters = udModel.getParameters();
            for (String parameterId : parameters.keySet()) {
                if (!"datasource".equals(parameters.get(parameterId).getType().getId())) continue;
                datasourceParameters.add(parameterId);
            }
            for (UserPopulation population : this._userPopulationDAO.getUserPopulations(false)) {
                for (UserDirectory userDirectory : population.getUserDirectories()) {
                    if (!userDirectory.getUserDirectoryModelId().equals(udModelId)) continue;
                    for (String datasourceParameter : datasourceParameters) {
                        if (!id.equals(userDirectory.getParameterValues().get(datasourceParameter))) continue;
                        return true;
                    }
                }
            }
        }
        return false;
    }

    private boolean _isInUseByCredentialProviders(String id) {
        for (String cpModelId : this._credentialProviderFactory.getExtensionsIds()) {
            CredentialProviderModel cpModel = this._credentialProviderFactory.getExtension(cpModelId);
            ArrayList<String> datasourceParameters = new ArrayList<String>();
            Map<String, ? extends ElementDefinition> parameters = cpModel.getParameters();
            for (String parameterId : parameters.keySet()) {
                if (!"datasource".equals(parameters.get(parameterId).getType().getId())) continue;
                datasourceParameters.add(parameterId);
            }
            for (UserPopulation population : this._userPopulationDAO.getUserPopulations(false)) {
                for (CredentialProvider credentialProvider : population.getCredentialProviders()) {
                    if (!credentialProvider.getCredentialProviderModelId().equals(cpModelId)) continue;
                    for (String datasourceParameter : datasourceParameters) {
                        if (!id.equals(credentialProvider.getParameterValues().get(datasourceParameter))) continue;
                        return true;
                    }
                }
            }
        }
        return false;
    }

    @Override
    public Set<String> getUsedDataSourceIds() {
        Map<String, ? extends ElementDefinition> parameters;
        ArrayList<String> datasourceParameters;
        HashSet<String> result = new HashSet<String>();
        result.add("SQL-ametys-internal");
        for (String udModelId : this._userDirectoryFactory.getExtensionsIds()) {
            UserDirectoryModel udModel = this._userDirectoryFactory.getExtension(udModelId);
            datasourceParameters = new ArrayList<String>();
            parameters = udModel.getParameters();
            for (String parameterId : parameters.keySet()) {
                if (!"datasource".equals(parameters.get(parameterId).getType().getId())) continue;
                datasourceParameters.add(parameterId);
            }
            for (UserPopulation population : this._userPopulationDAO.getUserPopulations(false)) {
                for (UserDirectory userDirectory : population.getUserDirectories()) {
                    if (!userDirectory.getUserDirectoryModelId().equals(udModelId)) continue;
                    for (String datasourceParameter : datasourceParameters) {
                        result.add((String)userDirectory.getParameterValues().get(datasourceParameter));
                    }
                }
            }
        }
        for (String cpModelId : this._credentialProviderFactory.getExtensionsIds()) {
            CredentialProviderModel cpModel = this._credentialProviderFactory.getExtension(cpModelId);
            datasourceParameters = new ArrayList();
            parameters = cpModel.getParameters();
            for (String parameterId : parameters.keySet()) {
                if (!"datasource".equals(parameters.get(parameterId).getType().getId())) continue;
                datasourceParameters.add(parameterId);
            }
            for (UserPopulation population : this._userPopulationDAO.getUserPopulations(false)) {
                for (CredentialProvider credentialProvider : population.getCredentialProviders()) {
                    if (!credentialProvider.getCredentialProviderModelId().equals(cpModelId)) continue;
                    for (String datasourceParameter : datasourceParameters) {
                        result.add((String)credentialProvider.getParameterValues().get(datasourceParameter));
                    }
                }
            }
        }
        return result;
    }
}

