/*
 * Decompiled with CFR 0.152.
 */
package org.ametys.plugins.core.impl.userpref;

import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.Map;
import java.util.regex.Pattern;
import org.ametys.core.datasource.ConnectionHelper;
import org.ametys.core.user.UserIdentity;
import org.ametys.core.userpref.UserPreferencesException;
import org.ametys.core.userpref.UserPreferencesStorage;
import org.ametys.runtime.config.Config;
import org.ametys.runtime.parameter.ParameterHelper;
import org.apache.avalon.framework.configuration.Configurable;
import org.apache.avalon.framework.configuration.Configuration;
import org.apache.avalon.framework.configuration.ConfigurationException;
import org.apache.avalon.framework.logger.AbstractLogEnabled;
import org.apache.avalon.framework.thread.ThreadSafe;
import org.apache.commons.lang.StringUtils;

public class JdbcPlainUserPreferencesStorage
extends AbstractLogEnabled
implements UserPreferencesStorage,
ThreadSafe,
Configurable {
    protected String _dataSourceId;
    protected String _databaseTable;
    protected String _loginColumn;
    protected String _populationColumn;
    protected String _contextColumn;
    protected Pattern _columnPattern;
    protected Map<String, String> _prefIdToColumn;
    protected Map<String, String> _columnToPrefId;

    public void configure(Configuration configuration) throws ConfigurationException {
        String regex;
        Configuration dataSourceConf = configuration.getChild("datasource", false);
        if (dataSourceConf == null) {
            throw new ConfigurationException("The 'datasource' configuration node must be defined.", dataSourceConf);
        }
        String dataSourceConfParam = dataSourceConf.getValue();
        String dataSourceConfType = dataSourceConf.getAttribute("type", "config");
        this._dataSourceId = StringUtils.equals((String)dataSourceConfType, (String)"config") ? (String)Config.getInstance().getValue(dataSourceConfParam) : dataSourceConfParam;
        this._databaseTable = configuration.getChild("table").getValue();
        this._loginColumn = configuration.getChild("loginColumn").getValue("login").toLowerCase();
        this._populationColumn = configuration.getChild("populationColumn").getValue("population").toLowerCase();
        this._contextColumn = configuration.getChild("contextColumn").getValue(null);
        if (this._contextColumn != null) {
            this._contextColumn = this._contextColumn.toLowerCase();
        }
        this._columnPattern = StringUtils.isBlank((String)(regex = configuration.getChild("columnPattern").getValue(null))) ? null : Pattern.compile(regex, 2);
        this.configureMappings(configuration.getChild("mappings"));
    }

    public void configureMappings(Configuration configuration) throws ConfigurationException {
        this._prefIdToColumn = new HashMap<String, String>();
        this._columnToPrefId = new HashMap<String, String>();
        for (Configuration mappingConf : configuration.getChildren("mapping")) {
            String prefId = mappingConf.getAttribute("prefId");
            String column = mappingConf.getAttribute("column").toLowerCase();
            this._prefIdToColumn.put(prefId, column);
            this._columnToPrefId.put(column, prefId);
        }
    }

    @Override
    public Map<String, String> getUnTypedUserPrefs(UserIdentity user, String storageContext, Map<String, String> contextVars) throws UserPreferencesException {
        Object metaData;
        HashMap<String, String> prefs = new HashMap<String, String>();
        Connection connection = null;
        PreparedStatement stmt = null;
        ResultSet rs = null;
        try {
            connection = ConnectionHelper.getConnection(this._dataSourceId);
            StringBuilder query = new StringBuilder();
            query.append("SELECT * FROM ").append(this._databaseTable).append(" WHERE ").append(this._loginColumn).append(" = ? AND ").append(this._populationColumn).append(" = ?");
            if (StringUtils.isNotBlank((String)this._contextColumn)) {
                query.append(" AND ").append(this._contextColumn).append(" = ?");
            }
            stmt = connection.prepareStatement(query.toString());
            stmt.setString(1, user.getLogin());
            stmt.setString(2, user.getPopulationId());
            if (StringUtils.isNotBlank((String)this._contextColumn)) {
                stmt.setString(2, storageContext);
            }
            if ((rs = stmt.executeQuery()).next()) {
                metaData = rs.getMetaData();
                int colCount = metaData.getColumnCount();
                for (int col = 1; col <= colCount; ++col) {
                    int type;
                    String value;
                    String name = metaData.getColumnName(col).toLowerCase();
                    if (!this.isColumnValid(name) || (value = this.getPreferenceValue(rs, col, type = metaData.getColumnType(col))) == null) continue;
                    String prefId = this._columnToPrefId.containsKey(name) ? this._columnToPrefId.get(name) : name;
                    prefs.put(prefId, value);
                }
            }
            metaData = prefs;
        }
        catch (SQLException e) {
            try {
                String message = "Database error trying to access the preferences of user '" + user + "' in context '" + storageContext + "'.";
                this.getLogger().error(message, (Throwable)e);
                throw new UserPreferencesException(message, e);
            }
            catch (Throwable throwable) {
                ConnectionHelper.cleanup(rs);
                ConnectionHelper.cleanup(stmt);
                ConnectionHelper.cleanup(connection);
                throw throwable;
            }
        }
        ConnectionHelper.cleanup(rs);
        ConnectionHelper.cleanup(stmt);
        ConnectionHelper.cleanup(connection);
        return metaData;
    }

    @Override
    public void removeUserPreferences(UserIdentity user, String storageContext, Map<String, String> contextVars) throws UserPreferencesException {
        Connection connection = null;
        PreparedStatement stmt = null;
        try {
            connection = ConnectionHelper.getConnection(this._dataSourceId);
            StringBuilder query = new StringBuilder();
            query.append("DELETE FROM ").append(this._databaseTable).append(" WHERE ").append(this._loginColumn).append(" = ? AND ").append(this._populationColumn).append(" = ?");
            if (StringUtils.isNotBlank((String)this._contextColumn)) {
                query.append(" AND ").append(this._contextColumn).append(" = ?");
            }
            stmt = connection.prepareStatement(query.toString());
            stmt.setString(1, user.getLogin());
            stmt.setString(2, user.getPopulationId());
            if (StringUtils.isNotBlank((String)this._contextColumn)) {
                stmt.setString(2, storageContext);
            }
            stmt.executeUpdate();
        }
        catch (SQLException e) {
            try {
                String message = "Database error trying to remove preferences for login '" + user + "' in context '" + storageContext + "'.";
                this.getLogger().error(message, (Throwable)e);
                throw new UserPreferencesException(message, e);
            }
            catch (Throwable throwable) {
                ConnectionHelper.cleanup(stmt);
                ConnectionHelper.cleanup(connection);
                throw throwable;
            }
        }
        ConnectionHelper.cleanup(stmt);
        ConnectionHelper.cleanup(connection);
    }

    @Override
    public void setUserPreferences(UserIdentity user, String storageContext, Map<String, String> contextVars, Map<String, String> preferences) throws UserPreferencesException {
        Connection connection = null;
        try {
            connection = ConnectionHelper.getConnection(this._dataSourceId);
            if (this.dataExists(connection, user, storageContext)) {
                this.updatePreferences(connection, preferences, user, storageContext);
            } else {
                this.insertPreferences(connection, preferences, user, storageContext);
            }
        }
        catch (SQLException e) {
            String message = "Database error trying to set the preferences of user '" + user + "' in context '" + storageContext + "'.";
            this.getLogger().error(message, (Throwable)e);
            throw new UserPreferencesException(message, e);
        }
        finally {
            ConnectionHelper.cleanup(connection);
        }
    }

    @Override
    public String getUserPreferenceAsString(UserIdentity user, String storageContext, Map<String, String> contextVars, String id) throws UserPreferencesException {
        Connection connection = null;
        PreparedStatement statement = null;
        ResultSet rs = null;
        String value = null;
        try {
            String column;
            String string = column = this._prefIdToColumn.containsKey(id) ? this._prefIdToColumn.get(id) : id;
            if (this.isColumnValid(column)) {
                StringBuilder query = new StringBuilder();
                query.append("SELECT ? FROM ").append(this._databaseTable).append(" WHERE ").append(this._loginColumn).append(" = ? AND ").append(this._populationColumn).append(" = ?");
                if (StringUtils.isNotBlank((String)this._contextColumn)) {
                    query.append(" AND ").append(this._contextColumn).append(" = ?");
                }
                connection = ConnectionHelper.getConnection(this._dataSourceId);
                statement = connection.prepareStatement(query.toString());
                statement.setString(1, column);
                statement.setString(2, user.getLogin());
                statement.setString(3, user.getPopulationId());
                if (StringUtils.isNotBlank((String)this._contextColumn)) {
                    statement.setString(4, storageContext);
                }
                if ((rs = statement.executeQuery()).next()) {
                    value = rs.getString(1);
                }
            }
        }
        catch (SQLException e) {
            String message = "Database error trying to get the preferences of user '" + user + "' in context '" + storageContext + "'.";
            this.getLogger().error(message, (Throwable)e);
            throw new UserPreferencesException(message, e);
        }
        finally {
            ConnectionHelper.cleanup(rs);
            ConnectionHelper.cleanup(statement);
            ConnectionHelper.cleanup(connection);
        }
        return value;
    }

    @Override
    public Long getUserPreferenceAsLong(UserIdentity user, String storageContext, Map<String, String> contextVars, String id) throws UserPreferencesException {
        Long value = null;
        Map<String, String> values = this.getUnTypedUserPrefs(user, storageContext, contextVars);
        if (values.containsKey(id)) {
            value = (Long)ParameterHelper.castValue(values.get(id), ParameterHelper.ParameterType.LONG);
        }
        return value;
    }

    @Override
    public Date getUserPreferenceAsDate(UserIdentity user, String storageContext, Map<String, String> contextVars, String id) throws UserPreferencesException {
        Date value = null;
        Map<String, String> values = this.getUnTypedUserPrefs(user, storageContext, contextVars);
        if (values.containsKey(id)) {
            value = (Date)ParameterHelper.castValue(values.get(id), ParameterHelper.ParameterType.DATE);
        }
        return value;
    }

    @Override
    public Boolean getUserPreferenceAsBoolean(UserIdentity user, String storageContext, Map<String, String> contextVars, String id) throws UserPreferencesException {
        Boolean value = null;
        Map<String, String> values = this.getUnTypedUserPrefs(user, storageContext, contextVars);
        if (values.containsKey(id)) {
            value = (Boolean)ParameterHelper.castValue(values.get(id), ParameterHelper.ParameterType.BOOLEAN);
        }
        return value;
    }

    @Override
    public Double getUserPreferenceAsDouble(UserIdentity user, String storageContext, Map<String, String> contextVars, String id) throws UserPreferencesException {
        Double value = null;
        Map<String, String> values = this.getUnTypedUserPrefs(user, storageContext, contextVars);
        if (values.containsKey(id)) {
            value = (Double)ParameterHelper.castValue(values.get(id), ParameterHelper.ParameterType.DOUBLE);
        }
        return value;
    }

    protected boolean isColumnValid(String name) {
        return !(this._loginColumn.equalsIgnoreCase(name) || this._contextColumn != null && this._contextColumn.equalsIgnoreCase(name) || this._columnPattern != null && !this._columnPattern.matcher(name).matches());
    }

    protected String getPreferenceValue(ResultSet rs, int columnIndex, int jdbcType) throws SQLException {
        String value = null;
        switch (jdbcType) {
            case -15: 
            case -9: 
            case -6: 
            case -5: 
            case -1: 
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 12: 
            case 91: 
            case 92: 
            case 93: {
                value = rs.getString(columnIndex);
                break;
            }
        }
        return value;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected boolean dataExists(Connection connection, UserIdentity user, String storageContext) throws SQLException {
        boolean bl;
        PreparedStatement stmt = null;
        ResultSet rs = null;
        try {
            StringBuilder query = new StringBuilder();
            query.append("SELECT count(*) FROM ").append(this._databaseTable).append(" WHERE ").append(this._loginColumn).append(" = ? AND ").append(this._populationColumn).append(" = ?");
            if (StringUtils.isNotBlank((String)this._contextColumn)) {
                query.append(" AND ").append(this._contextColumn).append(" = ?");
            }
            stmt = connection.prepareStatement(query.toString());
            stmt.setString(1, user.getLogin());
            stmt.setString(2, user.getPopulationId());
            if (StringUtils.isNotBlank((String)this._contextColumn)) {
                stmt.setString(3, storageContext);
            }
            rs = stmt.executeQuery();
            rs.next();
            bl = rs.getInt(1) > 0;
        }
        catch (Throwable throwable) {
            ConnectionHelper.cleanup(rs);
            ConnectionHelper.cleanup(stmt);
            throw throwable;
        }
        ConnectionHelper.cleanup(rs);
        ConnectionHelper.cleanup(stmt);
        return bl;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void insertPreferences(Connection connection, Map<String, String> preferences, UserIdentity user, String storageContext) throws SQLException {
        PreparedStatement stmt = null;
        try {
            StringBuilder query = new StringBuilder();
            StringBuilder values = new StringBuilder();
            query.append("INSERT INTO ").append(this._databaseTable).append("(").append(this._loginColumn).append(", ").append(this._populationColumn);
            values.append("?, ?");
            if (StringUtils.isNotBlank((String)this._contextColumn)) {
                query.append(", ").append(this._contextColumn);
                values.append(", ?");
            }
            ArrayList<String> valuesToSet = new ArrayList<String>();
            int validPrefCount = 0;
            for (String prefId : preferences.keySet()) {
                String column = this._prefIdToColumn.containsKey(prefId) ? this._prefIdToColumn.get(prefId) : prefId;
                if (!this.isColumnValid(column)) continue;
                valuesToSet.add(preferences.get(prefId));
                query.append(", ").append(column);
                values.append(", ?");
                ++validPrefCount;
            }
            if (validPrefCount > 0) {
                query.append(") VALUES (").append((CharSequence)values).append(')');
                int i = 1;
                stmt = connection.prepareStatement(query.toString());
                stmt.setString(i++, user.getLogin());
                stmt.setString(i++, user.getPopulationId());
                if (StringUtils.isNotBlank((String)this._contextColumn)) {
                    stmt.setString(i++, storageContext);
                }
                for (String value : valuesToSet) {
                    stmt.setString(i, value);
                    ++i;
                }
                stmt.executeUpdate();
            }
        }
        finally {
            ConnectionHelper.cleanup(stmt);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void updatePreferences(Connection connection, Map<String, String> preferences, UserIdentity user, String storageContext) throws SQLException {
        PreparedStatement stmt = null;
        try {
            StringBuilder query = new StringBuilder();
            query.append("UPDATE ").append(this._databaseTable).append(" SET ");
            ArrayList<String> valuesToSet = new ArrayList<String>();
            int validPrefCount = 0;
            for (String prefId : preferences.keySet()) {
                String column = this._prefIdToColumn.containsKey(prefId) ? this._prefIdToColumn.get(prefId) : prefId;
                if (!this.isColumnValid(column)) continue;
                valuesToSet.add(preferences.get(prefId));
                if (validPrefCount > 0) {
                    query.append(", ");
                }
                query.append(" ").append(column).append(" = ?");
                ++validPrefCount;
            }
            query.append(" WHERE ").append(this._loginColumn).append(" = ?").append(" AND ").append(this._populationColumn).append(" = ?");
            if (StringUtils.isNotBlank((String)this._contextColumn)) {
                query.append(" AND ").append(this._contextColumn).append(" = ?");
            }
            if (validPrefCount > 0) {
                stmt = connection.prepareStatement(query.toString());
                int i = 1;
                for (String value : valuesToSet) {
                    stmt.setString(i, value);
                    ++i;
                }
                stmt.setString(i++, user.getLogin());
                stmt.setString(i++, user.getPopulationId());
                if (StringUtils.isNotBlank((String)this._contextColumn)) {
                    stmt.setString(i++, storageContext);
                }
                stmt.executeUpdate();
            }
        }
        finally {
            ConnectionHelper.cleanup(stmt);
        }
    }
}

