/*
 * Decompiled with CFR 0.152.
 */
package org.ametys.plugins.core.impl.userpref;

import java.util.Date;
import java.util.HashMap;
import java.util.Map;
import org.ametys.core.user.InvalidModificationException;
import org.ametys.core.user.User;
import org.ametys.core.user.UserIdentity;
import org.ametys.core.user.UserManager;
import org.ametys.core.user.directory.ModifiableUserDirectory;
import org.ametys.core.user.directory.UserDirectory;
import org.ametys.core.userpref.UserPreferencesException;
import org.ametys.core.userpref.UserPreferencesStorage;
import org.apache.avalon.framework.logger.AbstractLogEnabled;
import org.apache.avalon.framework.service.ServiceException;
import org.apache.avalon.framework.service.ServiceManager;
import org.apache.avalon.framework.service.Serviceable;
import org.apache.avalon.framework.thread.ThreadSafe;

public class UserManagerUserPreferenceStorage
extends AbstractLogEnabled
implements UserPreferencesStorage,
ThreadSafe,
Serviceable {
    private UserManager _userManager;

    public void service(ServiceManager smanager) throws ServiceException {
        this._userManager = (UserManager)smanager.lookup(UserManager.ROLE);
    }

    @Override
    public Map<String, String> getUnTypedUserPrefs(UserIdentity userIdentity, String storageContext, Map<String, String> contextVars) throws UserPreferencesException {
        HashMap<String, String> userPrefs = new HashMap<String, String>();
        User user = this._userManager.getUser(userIdentity);
        userPrefs.put("firstname", user.getFirstName());
        userPrefs.put("lastname", user.getLastName());
        userPrefs.put("email", user.getEmail());
        return userPrefs;
    }

    @Override
    public void removeUserPreferences(UserIdentity user, String storageContext, Map<String, String> contextVars) throws UserPreferencesException {
        throw new UserPreferencesException("The user preferences issued from the users manager can not be removed ");
    }

    @Override
    public void setUserPreferences(UserIdentity userIdentity, String storageContext, Map<String, String> contextVars, Map<String, String> preferences) throws UserPreferencesException {
        User user = this._userManager.getUser(userIdentity);
        if (!this._hasChanges(user, preferences)) {
            return;
        }
        UserDirectory userDirectory = user.getUserDirectory();
        if (userDirectory instanceof ModifiableUserDirectory) {
            try {
                preferences.put("login", userIdentity.getLogin());
                ((ModifiableUserDirectory)userDirectory).update(preferences);
            }
            catch (InvalidModificationException e) {
                throw new UserPreferencesException("Failed to update user informations", e);
            }
        } else {
            throw new UserPreferencesException("Try to update user informations on a non-modifiable user directory");
        }
    }

    private boolean _hasChanges(User user, Map<String, String> preferences) {
        return preferences.containsKey("firstname") && !preferences.get("firstname").equals(user.getFirstName()) || preferences.containsKey("lastname") && !preferences.get("lastname").equals(user.getLastName()) || preferences.containsKey("email") && !preferences.get("email").equals(user.getEmail());
    }

    @Override
    public String getUserPreferenceAsString(UserIdentity userIdentity, String storageContext, Map<String, String> contextVars, String id) throws UserPreferencesException {
        User user = this._userManager.getUser(userIdentity);
        if ("firstname".equals(id)) {
            return user.getFirstName();
        }
        if ("lastname".equals(id)) {
            return user.getLastName();
        }
        if ("email".equals(id)) {
            return user.getEmail();
        }
        return null;
    }

    @Override
    public Long getUserPreferenceAsLong(UserIdentity user, String storageContext, Map<String, String> contextVars, String id) throws UserPreferencesException {
        return null;
    }

    @Override
    public Date getUserPreferenceAsDate(UserIdentity user, String storageContext, Map<String, String> contextVars, String id) throws UserPreferencesException {
        return null;
    }

    @Override
    public Boolean getUserPreferenceAsBoolean(UserIdentity user, String storageContext, Map<String, String> contextVars, String id) throws UserPreferencesException {
        return null;
    }

    @Override
    public Double getUserPreferenceAsDouble(UserIdentity user, String storageContext, Map<String, String> contextVars, String id) throws UserPreferencesException {
        return null;
    }
}

