/*
 * Decompiled with CFR 0.152.
 */
package org.ametys.plugins.core.impl.validator;

import java.util.regex.Pattern;
import java.util.regex.PatternSyntaxException;
import org.ametys.runtime.i18n.I18nizableText;
import org.ametys.runtime.parameter.DefaultValidator;
import org.ametys.runtime.parameter.Errors;
import org.apache.avalon.framework.configuration.Configuration;
import org.apache.avalon.framework.configuration.ConfigurationException;

public class RegexpValidator
extends DefaultValidator {
    @Override
    public void configure(Configuration configuration) throws ConfigurationException {
        Configuration textConfig;
        Configuration validatorConfig = configuration.getChild("validation").getChild("custom-validator");
        this._isMandatory = validatorConfig.getChild("mandatory", false) != null;
        String regexp = validatorConfig.getChild("regexp").getValue(null);
        if (regexp != null) {
            this._regexp = Pattern.compile(regexp);
        }
        if ((textConfig = validatorConfig.getChild("invalidText", false)) != null) {
            this._invalidText = I18nizableText.parseI18nizableText(textConfig, "plugin." + this._pluginName);
        }
    }

    @Override
    protected void validateSingleValue(Object value, Errors errors) {
        super.validateSingleValue(value, errors);
        this._validateRegexp((String)value, errors);
    }

    @Override
    protected void validateArrayValues(Object[] values, Errors errors) {
        super.validateArrayValues(values, errors);
        for (Object value : values) {
            this._validateRegexp((String)value, errors);
        }
    }

    private void _validateRegexp(String regexp, Errors errors) {
        if (regexp != null) {
            try {
                Pattern.compile(regexp);
            }
            catch (PatternSyntaxException e) {
                if (this.getLogger().isDebugEnabled()) {
                    this.getLogger().debug("The regular expression '" + regexp + "' is not a valid one.");
                }
                errors.addError(new I18nizableText("plugin.core-impl", "PLUGINS_CORE_VALIDATOR_REGEXP_FAILED"));
            }
        }
    }
}

