/*
 * Decompiled with CFR 0.152.
 */
package org.ametys.plugins.core.ui.help;

import java.io.InputStream;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.ametys.core.ui.Callable;
import org.ametys.core.util.filereloader.FileReloader;
import org.ametys.core.util.filereloader.FileReloaderUtils;
import org.ametys.plugins.core.ui.help.HelpExtensionPoint;
import org.ametys.plugins.core.ui.help.HelpLink;
import org.ametys.runtime.config.Config;
import org.ametys.runtime.plugin.component.AbstractLogEnabled;
import org.apache.avalon.framework.activity.Initializable;
import org.apache.avalon.framework.component.Component;
import org.apache.avalon.framework.configuration.Configuration;
import org.apache.avalon.framework.configuration.ConfigurationException;
import org.apache.avalon.framework.configuration.DefaultConfigurationBuilder;
import org.apache.avalon.framework.service.ServiceException;
import org.apache.avalon.framework.service.ServiceManager;
import org.apache.avalon.framework.service.Serviceable;
import org.apache.commons.lang3.StringUtils;

public class HelpManager
extends AbstractLogEnabled
implements Component,
Serviceable,
FileReloader,
Initializable {
    public static final String ROLE = HelpManager.class.getName();
    private static final String DEFAULT_HELP_URL = "https://docs.ametys.org/{lang}/index.html";
    private static final String DEFAULT_SEARCH_URL = "https://docs.ametys.org/{lang}/search.html?textfield={query}&submit-form";
    protected Map<String, HelpLink> _links;
    private FileReloaderUtils _fileReloader;
    private HelpExtensionPoint _helpEP;

    public void service(ServiceManager manager) throws ServiceException {
        this._fileReloader = (FileReloaderUtils)manager.lookup(FileReloaderUtils.ROLE);
        this._helpEP = (HelpExtensionPoint)manager.lookup(HelpExtensionPoint.ROLE);
    }

    public void initialize() throws Exception {
        this._links = new HashMap<String, HelpLink>();
    }

    @Callable
    public Map<String, Object> getHelpUrl(String family, String id, String lang) throws Exception {
        HashMap<String, Object> resultMap = new HashMap<String, Object>();
        String url = this.getHelp(family, id, lang);
        resultMap.put("url", url);
        if (StringUtils.isEmpty((CharSequence)url)) {
            resultMap.put("error", "true");
            resultMap.put("error-cause", "not-found");
        }
        return resultMap;
    }

    @Callable
    public Map<String, Object> getDefaultHelpUrl() {
        HashMap<String, Object> resultMap = new HashMap<String, Object>();
        String url = null;
        if (Config.getInstance() != null) {
            url = (String)Config.getInstance().getValue("online.help.index.url");
        }
        if (StringUtils.isBlank(url)) {
            url = DEFAULT_HELP_URL;
        }
        resultMap.put("url", url);
        return resultMap;
    }

    @Callable
    public Map<String, Object> getSearchUrl() {
        HashMap<String, Object> resultMap = new HashMap<String, Object>();
        String url = null;
        if (Config.getInstance() != null) {
            url = (String)Config.getInstance().getValue("online.help.search.url");
        }
        if (StringUtils.isBlank(url)) {
            url = DEFAULT_SEARCH_URL;
        }
        resultMap.put("url", url);
        return resultMap;
    }

    public String getHelp(String family, String id, String lang) throws Exception {
        List<String> languages = Collections.singletonList(lang);
        return this.getHelp(family, id, languages);
    }

    public String getHelp(String family, String id, List<String> languages) throws Exception {
        String lang;
        this._fileReloader.updateFile("context://WEB-INF/param/help.xml", this);
        String result = null;
        Iterator<String> iterator = languages.iterator();
        while (iterator.hasNext() && (result = this._getHelp(family, id, lang = iterator.next())) == null) {
        }
        if (result == null) {
            result = this._getHelp(family, id, "en");
        }
        if (result == null) {
            result = this._getAnyLanguageHelp(family, id);
        }
        if (StringUtils.isBlank(result)) {
            return null;
        }
        return result;
    }

    private String _getHelp(String family, String id, String lang) {
        String url = null;
        HelpLink helpLink = this._links.get(HelpLink.getUniqueId(family, id));
        if (helpLink != null) {
            url = helpLink.getUrl(lang);
        }
        if (StringUtils.isNotBlank(url)) {
            return url;
        }
        helpLink = this._helpEP.getHelpLink(family, id);
        if (helpLink != null) {
            url = helpLink.getUrl(lang);
        }
        return url;
    }

    private String _getAnyLanguageHelp(String family, String id) {
        String url = null;
        HelpLink helpLink = this._links.get(HelpLink.getUniqueId(family, id));
        if (helpLink != null) {
            url = this._getAnyLanguageHelp(helpLink);
        }
        if (StringUtils.isNotBlank(url)) {
            return url;
        }
        helpLink = this._helpEP.getHelpLink(family, id);
        if (helpLink != null) {
            url = this._getAnyLanguageHelp(helpLink);
        }
        return url;
    }

    private String _getAnyLanguageHelp(HelpLink helpLink) {
        Map<String, String> urls;
        if (helpLink != null && (urls = helpLink.getUrls()) != null && !urls.isEmpty()) {
            return urls.values().iterator().next();
        }
        return null;
    }

    @Override
    public void updateFile(String sourceUrl, InputStream is) throws Exception {
        if (is != null) {
            Configuration cfg = new DefaultConfigurationBuilder().build(is);
            this._links = this.parseConfigFile(cfg, "WEB-INF", "help");
        } else {
            this._links = new HashMap<String, HelpLink>();
        }
    }

    @Override
    public String getId(String sourceUrl) {
        return HelpManager.class.getName();
    }

    public Map<String, HelpLink> parseConfigFile(Configuration configuration, String pluginName, String featureName) {
        Configuration[] linkConfigurations;
        HashMap<String, HelpLink> links = new HashMap<String, HelpLink>();
        for (Configuration linkConfiguration : linkConfigurations = configuration.getChildren("link")) {
            HelpLink link = this._addLink(linkConfiguration, pluginName, featureName);
            if (link == null) continue;
            String id = link.getUniqueId();
            if (links.containsKey(id)) {
                this.getLogger().warn("There is already a help key for this plugin.feature : {}.{}", (Object)pluginName, (Object)featureName);
                continue;
            }
            links.put(id, link);
        }
        return links;
    }

    private HelpLink _addLink(Configuration linkConfiguration, String pluginName, String featureName) {
        String family = null;
        String id = null;
        try {
            family = linkConfiguration.getAttribute("family");
            id = linkConfiguration.getAttribute("id");
            Configuration[] languages = linkConfiguration.getChildren();
            HashMap<String, String> urls = new HashMap<String, String>();
            for (Configuration language : languages) {
                String lang = language.getName();
                String url = language.getValue("");
                urls.put(lang, url);
            }
            return new HelpLink(family, id, urls);
        }
        catch (ConfigurationException e) {
            this.getLogger().warn("The plugin '{}.{}' has an help extension but has an incorrect configuration (for family '{}' and feature '{}'", new Object[]{pluginName, featureName, StringUtils.defaultIfBlank((CharSequence)family, (CharSequence)"<unknown>"), StringUtils.defaultIfBlank((CharSequence)id, (CharSequence)"<unknown>"), e});
            return null;
        }
    }
}

