/*
 * Decompiled with CFR 0.152.
 */
package org.ametys.plugins.core.ui.help;

import com.fasterxml.jackson.core.JsonGenerator;
import com.fasterxml.jackson.databind.SerializerProvider;
import com.fasterxml.jackson.databind.ser.std.StdSerializer;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.List;
import java.util.Locale;
import org.ametys.plugins.core.ui.help.HelpLink;
import org.ametys.plugins.core.ui.help.HelpManager;
import org.ametys.runtime.plugin.component.LogEnabled;
import org.apache.avalon.framework.component.Component;
import org.apache.avalon.framework.context.Context;
import org.apache.avalon.framework.context.ContextException;
import org.apache.avalon.framework.context.Contextualizable;
import org.apache.avalon.framework.service.ServiceException;
import org.apache.avalon.framework.service.ServiceManager;
import org.apache.avalon.framework.service.Serviceable;
import org.apache.cocoon.components.ContextHelper;
import org.apache.cocoon.environment.Request;
import org.slf4j.Logger;

public class HelpSerializer
extends StdSerializer<HelpLink>
implements Component,
Serviceable,
LogEnabled,
Contextualizable {
    public static final String ROLE = HelpSerializer.class.getName();
    private Logger _logger;
    private HelpManager _helpManager;
    private Context _context;

    public HelpSerializer() {
        super(HelpLink.class);
    }

    public void serialize(HelpLink value, JsonGenerator gen, SerializerProvider provider) throws IOException {
        if (value != null) {
            Request request = ContextHelper.getRequest((Context)this._context);
            List<String> languages = this._getLanguages(request);
            try {
                String msg = this._helpManager.getHelp(value.getFamily(), value.getId(), languages);
                if (msg == null) {
                    gen.writeNull();
                } else {
                    gen.writeString(msg);
                }
            }
            catch (Exception e) {
                this._logger.warn("Impossible to serialize help link for point : '{}' and id : '{}'", new Object[]{value.getFamily(), value.getId(), e});
            }
        }
    }

    @Override
    public void setLogger(Logger logger) {
        this._logger = logger;
    }

    public void service(ServiceManager manager) throws ServiceException {
        this._helpManager = (HelpManager)manager.lookup(HelpManager.ROLE);
    }

    public void contextualize(Context context) throws ContextException {
        this._context = context;
    }

    private List<String> _getLanguages(Request request) {
        ArrayList<String> languages = new ArrayList<String>();
        if (request != null) {
            Enumeration locales = request.getLocales();
            while (locales.hasMoreElements()) {
                Locale locale = (Locale)locales.nextElement();
                String lang = locale.getLanguage();
                if (languages.contains(lang)) continue;
                languages.add(lang);
            }
        }
        return languages;
    }
}

