/*
 * Decompiled with CFR 0.152.
 */
package org.ametys.plugins.core.ui.minimize.js;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.List;
import org.ametys.core.minimize.js.MinimizeJSManager;
import org.ametys.plugins.core.ui.minimize.AbstractMinimizeSourceMapReader;
import org.ametys.plugins.core.ui.minimize.HashCache;
import org.apache.avalon.framework.service.ServiceException;
import org.apache.avalon.framework.service.ServiceManager;
import org.apache.cocoon.ProcessingException;
import org.apache.commons.io.IOUtils;
import org.apache.excalibur.source.Source;
import org.xml.sax.SAXException;

public class MinimizeJSSourceMapReader
extends AbstractMinimizeSourceMapReader {
    private MinimizeJSManager _jSMinimizeManager;

    @Override
    public void service(ServiceManager smanager) throws ServiceException {
        super.service(smanager);
        this._jSMinimizeManager = (MinimizeJSManager)this.manager.lookup(MinimizeJSManager.ROLE);
    }

    public void generate() throws IOException, SAXException, ProcessingException {
        List<HashCache.UriData> filesForHash;
        Source sourceMap = this._sourceMapCache.get(this.source + ".js.map");
        if (sourceMap == null && (filesForHash = this._hashCache.getFilesForHash(this.source, true)) != null) {
            this._jSMinimizeManager.minimizeAndAggregateURIs(filesForHash, this.source + ".js", true);
            sourceMap = this._sourceMapCache.get(this.source + ".js.map");
        }
        if (sourceMap == null) {
            throw new IllegalStateException("There is no source map for minimized hash file '" + this.source + ".js'");
        }
        IOUtils.copy((InputStream)sourceMap.getInputStream(), (OutputStream)this.out);
        this.out.close();
    }
}

