/*
 * Decompiled with CFR 0.152.
 */
package org.ametys.plugins.core.ui.resources;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.Serializable;
import java.net.MalformedURLException;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import org.ametys.core.resources.AbstractResourceHandler;
import org.apache.avalon.framework.component.Component;
import org.apache.avalon.framework.parameters.Parameters;
import org.apache.cocoon.ProcessingException;
import org.apache.cocoon.ResourceNotFoundException;
import org.apache.cocoon.components.source.SourceUtil;
import org.apache.commons.io.FilenameUtils;
import org.apache.commons.io.IOUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.tuple.Pair;
import org.apache.excalibur.source.Source;
import org.apache.excalibur.source.SourceException;
import org.apache.excalibur.source.SourceValidity;
import org.apache.excalibur.source.impl.validity.TimeStampValidity;

public abstract class AbstractCompiledResourceHandler
extends AbstractResourceHandler
implements Component {
    private static Map<String, Pair<List<String>, Long>> _dependenciesCache = new ConcurrentHashMap<String, Pair<List<String>, Long>>();

    public abstract String compileResource(Source var1, Map<String, Object> var2) throws IOException, ProcessingException;

    protected abstract List<String> getDependenciesList(Source var1);

    protected abstract Source getCompiledSource(String var1, Map<String, Object> var2) throws MalformedURLException, IOException;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean isSupported(String source) {
        if (!super.isSupported(source)) {
            return false;
        }
        Source src = null;
        try {
            src = this._resolver.resolveURI(source);
            if (src.exists()) {
                boolean bl = false;
                return bl;
            }
        }
        catch (IOException iOException) {
        }
        finally {
            this._resolver.release(src);
        }
        return true;
    }

    @Override
    public Source setup(String location, Map objectModel, Parameters par, Map<String, Object> additionalParameters) throws IOException, ProcessingException {
        try {
            Source source = this.getCompiledSource(location, additionalParameters);
            if (!source.exists()) {
                throw new ResourceNotFoundException("Resource not found for URI : " + location);
            }
            return source;
        }
        catch (SourceException e) {
            throw SourceUtil.handle((String)("Error during resolving of '" + location + "'."), (SourceException)e);
        }
    }

    @Override
    public void generateResource(Source source, OutputStream out, Map objectModel, Parameters parameters, Map<String, Object> additionalParameters) throws IOException, ProcessingException {
        try (ByteArrayOutputStream os = new ByteArrayOutputStream();){
            String compiledResource = this.compileResource(source, additionalParameters);
            IOUtils.write((String)compiledResource, (OutputStream)out, (String)"UTF-8");
        }
    }

    @Override
    public Serializable getKey(Source source, Map objectModel, Parameters parameters, Map<String, Object> additionalParameters) {
        return this._getDependenciesKeys(source, source.getURI(), FilenameUtils.normalize((String)source.getURI()), source.getLastModified(), new HashMap<String, String>());
    }

    @Override
    public SourceValidity getValidity(Source source, Map objectModel, Parameters parameters, Map<String, Object> additionalParameters) {
        Long lastModified = this._getCalculatedLastModified(source, source.getURI(), source.getLastModified(), new HashMap<String, String>());
        return lastModified != null ? new TimeStampValidity(lastModified.longValue()) : null;
    }

    private Long _getCalculatedLastModified(Source inputSource, String sourceUri, long lastModified, HashMap<String, String> knowDependencies) {
        long result = lastModified;
        List<String> dependencies = this._getDependencies(inputSource, sourceUri, lastModified);
        for (String dependency : dependencies) {
            if (dependency == null || StringUtils.startsWith((CharSequence)dependency, (CharSequence)"http://") || StringUtils.startsWith((CharSequence)dependency, (CharSequence)"https://")) continue;
            try {
                HashMap params;
                String uriToResolve = this._getDependencyURI(sourceUri, dependency);
                Source dependencySource = this._resolver.resolveURI(uriToResolve, null, params = new HashMap());
                String fsURI = FilenameUtils.normalize((String)dependencySource.getURI());
                if (knowDependencies.containsKey(fsURI)) continue;
                knowDependencies.put(fsURI, sourceUri);
                Long calculatedLastModified = this._getCalculatedLastModified(dependencySource, uriToResolve, dependencySource.getLastModified(), knowDependencies);
                if (calculatedLastModified == null || calculatedLastModified <= result) continue;
                result = calculatedLastModified;
            }
            catch (Exception e) {
                this.getLogger().warn("Unable to resolve the following uri : '" + dependency + "' while calculating dependencies for " + inputSource.getURI(), (Throwable)e);
                return null;
            }
        }
        return result;
    }

    private String _getDependenciesKeys(Source inputSource, String sourceUri, String fileURI, long lastModified, HashMap<String, String> knowDependencies) {
        String result = fileURI;
        List<String> dependencies = this._getDependencies(inputSource, sourceUri, lastModified);
        for (String dependency : dependencies) {
            if (dependency == null || StringUtils.startsWith((CharSequence)dependency, (CharSequence)"http://") || StringUtils.startsWith((CharSequence)dependency, (CharSequence)"https://")) continue;
            try {
                String uriToResolve = this._getDependencyURI(sourceUri, dependency);
                HashMap params = new HashMap();
                Source dependencySource = this._resolver.resolveURI(uriToResolve, null, params);
                String fileDependencyURI = FilenameUtils.normalize((String)dependencySource.getURI());
                if (knowDependencies.containsKey(fileDependencyURI)) {
                    this.getLogger().warn("A loop import was detected in a SASS file : '" + sourceUri + "' tried to import '" + fileDependencyURI + "' but it was already previously imported by '" + knowDependencies.get(fileDependencyURI) + "'.");
                    continue;
                }
                knowDependencies.put(fileDependencyURI, sourceUri);
                String dependenciesKeys = this._getDependenciesKeys(dependencySource, uriToResolve, fileDependencyURI, dependencySource.getLastModified(), knowDependencies);
                if (dependenciesKeys == null) continue;
                result = result + "*" + dependenciesKeys;
            }
            catch (Exception e) {
                this.getLogger().warn("Unable to resolve the following uri : '" + dependency + "' while calculating dependencies for " + inputSource.getURI(), (Throwable)e);
                return null;
            }
        }
        return result;
    }

    private String _getDependencyURI(String sourceUri, String dependency) throws URISyntaxException {
        URI uri = new URI(dependency);
        String uriToResolve = uri.isAbsolute() ? dependency : FilenameUtils.getFullPath((String)sourceUri) + dependency;
        String schema = StringUtils.contains((CharSequence)uriToResolve, (CharSequence)"://") ? uriToResolve.substring(0, uriToResolve.indexOf("://") + 3) : "";
        uriToResolve = schema + FilenameUtils.normalize((String)StringUtils.removeStart((String)uriToResolve, (String)schema));
        return uriToResolve;
    }

    private List<String> _getDependencies(Source inputSource, String sourceUri, long lastModified) {
        List dependencies;
        Pair<List<String>, Long> cachedDependencies = _dependenciesCache.get(sourceUri);
        if (cachedDependencies == null || !((Long)cachedDependencies.getRight()).equals(lastModified)) {
            dependencies = this.getDependenciesList(inputSource);
            _dependenciesCache.put(sourceUri, (Pair<List<String>, Long>)Pair.of(dependencies, (Object)lastModified));
        } else {
            dependencies = (List)cachedDependencies.getLeft();
        }
        return dependencies;
    }
}

