/*
 * Decompiled with CFR 0.152.
 */
package org.ametys.plugins.core.ui.resources.css;

import java.util.Arrays;
import java.util.Map;
import java.util.function.Function;
import java.util.stream.Collectors;
import org.ametys.core.util.LambdaUtils;
import org.ametys.plugins.core.ui.resources.css.SupportedContextResourceUri;
import org.apache.avalon.framework.configuration.Configurable;
import org.apache.avalon.framework.configuration.Configuration;
import org.apache.avalon.framework.configuration.ConfigurationException;
import org.apache.commons.lang3.StringUtils;

public class ConfigurableSupportedContextResourceUri
implements SupportedContextResourceUri,
Configurable {
    private Map<String, String> _supportedContext;

    public void configure(Configuration configuration) throws ConfigurationException {
        Function<Configuration, String> confToContextAttribute = LambdaUtils.wrap(conf -> "context:/" + conf.getAttribute("context"));
        Function<Configuration, String> confToValue = LambdaUtils.wrap(conf -> conf.getAttribute("url"));
        this._supportedContext = Arrays.stream(configuration.getChildren("supportedContext")).filter(conf -> StringUtils.isNotEmpty((CharSequence)conf.getAttribute("context", null))).filter(conf -> StringUtils.isNotEmpty((CharSequence)conf.getAttribute("url", null))).collect(Collectors.toMap(confToContextAttribute, confToValue));
    }

    @Override
    public String resolve(String uri) {
        if (StringUtils.isEmpty((CharSequence)uri)) {
            return null;
        }
        return this._supportedContext.entrySet().stream().filter(supported -> uri.startsWith((String)supported.getKey())).findFirst().map(supported -> uri.replace((CharSequence)supported.getKey(), (CharSequence)supported.getValue())).orElse(null);
    }

    @Override
    public String resolvePath(String path) {
        if (StringUtils.isEmpty((CharSequence)path)) {
            return null;
        }
        return this._supportedContext.entrySet().stream().filter(supported -> path.startsWith((String)supported.getValue())).findFirst().map(supported -> path.replace((CharSequence)supported.getValue(), (CharSequence)supported.getKey())).orElse(null);
    }
}

