/*
 * Decompiled with CFR 0.152.
 */
package org.ametys.plugins.core.ui.resources.css;

import java.net.URISyntaxException;
import java.util.Objects;
import java.util.function.Function;
import org.ametys.plugins.core.ui.resources.css.JSASSResourceURI;
import org.ametys.plugins.core.ui.resources.css.SupportedContextResourceUri;
import org.ametys.plugins.core.ui.resources.css.SupportedContextResourceUriExtensionPoint;
import org.apache.avalon.framework.service.ServiceException;
import org.apache.avalon.framework.service.ServiceManager;
import org.apache.avalon.framework.service.Serviceable;
import org.apache.commons.lang3.StringUtils;

public class ContextJSASSResourceURI
implements JSASSResourceURI,
Serviceable {
    private SupportedContextResourceUriExtensionPoint _supportedContextResourceUri;

    public void service(ServiceManager manager) throws ServiceException {
        this._supportedContextResourceUri = (SupportedContextResourceUriExtensionPoint)manager.lookup(SupportedContextResourceUriExtensionPoint.ROLE);
    }

    @Override
    public String resolve(String uri) throws URISyntaxException {
        if (!StringUtils.startsWith((CharSequence)uri, (CharSequence)"context://")) {
            return null;
        }
        Function<SupportedContextResourceUri, String> resolveUri = ext -> ext.resolve(uri);
        String resolvedUri = this._supportedContextResourceUri.getExtensionsIds().stream().map(this::getExtension).map(resolveUri).filter(Objects::nonNull).findFirst().orElseThrow(() -> new URISyntaxException(uri, "No supported context:// for this uri, a SupportedContextResourceUri extension is required"));
        return resolvedUri;
    }

    @Override
    public String resolvePath(String path) {
        Function<SupportedContextResourceUri, String> resolvePath = ext -> ext.resolvePath(path);
        String resolvedUri = this._supportedContextResourceUri.getExtensionsIds().stream().map(this::getExtension).map(resolvePath).filter(Objects::nonNull).findFirst().orElse(null);
        return resolvedUri;
    }

    private SupportedContextResourceUri getExtension(String id) {
        return (SupportedContextResourceUri)this._supportedContextResourceUri.getExtension(id);
    }
}

