/*
 * Decompiled with CFR 0.152.
 */
package org.ametys.plugins.core.ui.resources.css;

import java.io.IOException;
import java.io.InputStream;
import java.net.URI;
import java.net.URISyntaxException;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.ametys.core.resources.ProxiedContextPathProvider;
import org.ametys.plugins.core.ui.minimize.HashCache;
import org.ametys.plugins.core.ui.resources.ResourceDependenciesList;
import org.ametys.plugins.core.ui.util.RequestAttributesHelper;
import org.ametys.runtime.plugin.component.AbstractLogEnabled;
import org.apache.avalon.framework.service.ServiceException;
import org.apache.avalon.framework.service.ServiceManager;
import org.apache.avalon.framework.service.Serviceable;
import org.apache.commons.io.FilenameUtils;
import org.apache.commons.io.IOUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.tuple.Pair;
import org.apache.excalibur.source.Source;
import org.apache.excalibur.source.SourceResolver;

public class CssDependenciesList
extends AbstractLogEnabled
implements ResourceDependenciesList,
Serviceable {
    private static final Pattern __IMPORT_WITHOUT_MEDIA_PATTERN = Pattern.compile("^@import\\b\\s*(?:(?:url)?\\(?\\s*[\"']?)([^)\"']*)[\"']?\\)?\\s*;?$", 10);
    private static final Pattern __EXTERNAL_URL = Pattern.compile("^(http[s]?://[^/]+)(/.*)?$");
    protected RequestAttributesHelper _requestAttributesHelper;
    private Map<String, Pair<List<String>, Long>> _dependenciesCache = new ConcurrentHashMap<String, Pair<List<String>, Long>>();
    private SourceResolver _sourceResolver;
    private ProxiedContextPathProvider _proxiedContextPathProvider;

    public void service(ServiceManager manager) throws ServiceException {
        this._sourceResolver = (SourceResolver)manager.lookup(SourceResolver.ROLE);
        this._requestAttributesHelper = (RequestAttributesHelper)manager.lookup(RequestAttributesHelper.ROLE);
        this._proxiedContextPathProvider = (ProxiedContextPathProvider)manager.lookup(ProxiedContextPathProvider.ROLE);
    }

    @Override
    public boolean isSupported(String uri) {
        return StringUtils.endsWith((CharSequence)uri, (CharSequence)".css");
    }

    @Override
    public int getPriority() {
        return 100;
    }

    @Override
    public Set<HashCache.UriData> getDependenciesList(String uri, Map<String, String> data) {
        return this._getFileDependencies(uri, data.getOrDefault("media", null), true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Set<HashCache.UriData> _getFileDependencies(String cssUri, String media, boolean firstLevel) throws IllegalArgumentException {
        LinkedHashSet<HashCache.UriData> dependencies = new LinkedHashSet<HashCache.UriData>();
        Source fileSource = null;
        HashMap<String, Object> resolveParameters = new HashMap<String, Object>();
        try {
            fileSource = this._getFileSource(cssUri, resolveParameters);
            long fileLastModified = resolveParameters.get("lastModified") != null ? (Long)resolveParameters.get("lastModified") : -1L;
            HashCache.UriData fileInfos = new HashCache.UriData(cssUri, firstLevel);
            fileInfos.setLastModified(fileLastModified);
            fileInfos.setMedia(media);
            dependencies.add(fileInfos);
            Long validity = Optional.ofNullable(this._dependenciesCache.get(cssUri)).map(Pair::getRight).orElse(null);
            if (validity == null || validity != fileLastModified) {
                ArrayList<String> dependenciesCache = new ArrayList<String>();
                for (HashCache.UriData cssDependency : this._getCssFileDependencies(cssUri, fileSource)) {
                    if (dependenciesCache.contains(cssDependency.getUri())) continue;
                    dependenciesCache.add(cssDependency.getUri());
                    dependencies.add(cssDependency);
                }
                this._dependenciesCache.put(cssUri, (Pair<List<String>, Long>)Pair.of(dependenciesCache, (Object)fileLastModified));
            } else {
                Pair<List<String>, Long> dependenciesFromCache = this._dependenciesCache.get(cssUri);
                if (dependenciesFromCache != null) {
                    for (String dependencyCached : (List)dependenciesFromCache.getLeft()) {
                        dependencies.addAll(this._getFileDependencies(dependencyCached, null, false));
                    }
                }
            }
        }
        finally {
            this._sourceResolver.release(fileSource);
        }
        return dependencies;
    }

    private Source _getFileSource(String cssUri, Map<String, Object> resolveParameters) {
        try {
            String uriToResolve = cssUri;
            URI uri = new URI(cssUri);
            if (!uri.isAbsolute()) {
                uriToResolve = "cocoon:/" + uriToResolve;
            }
            this._requestAttributesHelper.removeRequestAttributes();
            return this._sourceResolver.resolveURI(uriToResolve, null, resolveParameters);
        }
        catch (Exception e) {
            throw new IllegalArgumentException("Unable to resolve the dependencies of specified uri", e);
        }
    }

    private List<HashCache.UriData> _getCssFileDependencies(String uri, Source cssSource) throws IllegalArgumentException {
        String fileContent;
        ArrayList<HashCache.UriData> cssDependencies = new ArrayList<HashCache.UriData>();
        try (InputStream is = cssSource.getInputStream();){
            fileContent = IOUtils.toString((InputStream)is, (Charset)StandardCharsets.UTF_8);
        }
        catch (IOException e) {
            this.getLogger().error("Unable to retrieve css file dependencies for '" + uri + "'", (Throwable)e);
            return Collections.EMPTY_LIST;
        }
        String contextPath = this._proxiedContextPathProvider.getContextPath();
        Matcher urlMatcher = __IMPORT_WITHOUT_MEDIA_PATTERN.matcher(fileContent);
        while (urlMatcher.find()) {
            String cssUrl = urlMatcher.group(1);
            Matcher externalMatcher = __EXTERNAL_URL.matcher(cssUrl);
            if (externalMatcher.find()) continue;
            try {
                cssUrl = StringUtils.removeStart((String)cssUrl, (String)contextPath);
                URI cssUri = new URI(cssUrl);
                if (!cssUri.isAbsolute() && !cssUrl.startsWith("/")) {
                    cssUri = new URI(FilenameUtils.getFullPath((String)uri) + cssUrl);
                }
                cssDependencies.addAll(this._getFileDependencies(cssUri.normalize().toString(), null, false));
            }
            catch (URISyntaxException e) {
                this.getLogger().warn("Invalid URI in a file, could not calculate dependancies for file : " + uri, (Throwable)e);
            }
        }
        return cssDependencies;
    }
}

