/*
 * Decompiled with CFR 0.152.
 */
package org.ametys.plugins.core.user;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.stream.Collectors;
import org.ametys.core.user.User;
import org.ametys.core.user.UserIdentity;
import org.ametys.core.user.UserManager;
import org.ametys.core.user.directory.NotUniqueUserException;
import org.ametys.core.user.directory.UserDirectoryFactory;
import org.ametys.core.user.population.UserPopulationDAO;
import org.apache.avalon.framework.component.Component;
import org.apache.avalon.framework.context.Context;
import org.apache.avalon.framework.context.ContextException;
import org.apache.avalon.framework.context.Contextualizable;
import org.apache.avalon.framework.service.ServiceException;
import org.apache.avalon.framework.service.ServiceManager;
import org.apache.avalon.framework.service.Serviceable;
import org.apache.cocoon.components.ContextHelper;
import org.apache.cocoon.environment.Request;
import org.apache.cocoon.xml.AttributesImpl;
import org.apache.cocoon.xml.XMLUtils;
import org.xml.sax.Attributes;
import org.xml.sax.ContentHandler;
import org.xml.sax.SAXException;

public class UserHelper
implements Component,
Serviceable,
Contextualizable {
    public static final String ROLE = UserHelper.class.getName();
    private static final String __USER_CACHE_REQUEST_ATTR = UserHelper.class.getName() + "$userCache";
    private static final String __USER_BY_EMAIL_CACHE_REQUEST_ATTR = UserHelper.class.getName() + "$userByEmailCache";
    private UserPopulationDAO _userPopulationDAO;
    private UserDirectoryFactory _userDirectoryFactory;
    private UserManager _userManager;
    private Context _context;

    public void service(ServiceManager smanager) throws ServiceException {
        this._userManager = (UserManager)smanager.lookup(UserManager.ROLE);
        this._userPopulationDAO = (UserPopulationDAO)smanager.lookup(UserPopulationDAO.ROLE);
        this._userDirectoryFactory = (UserDirectoryFactory)smanager.lookup(UserDirectoryFactory.ROLE);
    }

    public void contextualize(Context context) throws ContextException {
        this._context = context;
    }

    public String getUserFullName(UserIdentity userIdentity) {
        User user = this.getUser(userIdentity);
        return user != null ? user.getFullName() : null;
    }

    public String getUserSortableName(UserIdentity userIdentity) {
        User user = this.getUser(userIdentity);
        return user != null ? user.getSortableName() : null;
    }

    public List<Map<String, Object>> userIdentities2json(Collection<UserIdentity> users) {
        return users.stream().map(identity -> this.getUser((UserIdentity)identity)).filter(Objects::nonNull).map(user -> this.user2json((User)user)).collect(Collectors.toList());
    }

    public List<Map<String, Object>> users2json(Collection<User> users) {
        return this.users2json(users, false);
    }

    public List<Map<String, Object>> users2json(Collection<User> users, boolean full) {
        ArrayList<Map<String, Object>> userList = new ArrayList<Map<String, Object>>();
        HashSet<User> distinctUsers = new HashSet<User>(users);
        for (User user : distinctUsers) {
            userList.add(this.user2json(user, full));
        }
        return userList;
    }

    public Map<String, Object> user2json(UserIdentity userIdentity) {
        return this.user2json(userIdentity, false);
    }

    public Map<String, Object> user2json(UserIdentity userIdentity, boolean full) {
        User user = this.getUser(userIdentity);
        if (user != null) {
            return this.user2json(user, full);
        }
        return Collections.EMPTY_MAP;
    }

    public Map<String, Object> user2json(User user) {
        return this._user2json(user, false);
    }

    public Map<String, Object> user2json(User user, boolean full) {
        return this._user2json(user, full);
    }

    private Map<String, Object> _user2json(User user, boolean full) {
        HashMap<String, Object> userInfos = new HashMap<String, Object>();
        userInfos.put("login", user.getIdentity().getLogin());
        String populationId = user.getIdentity().getPopulationId();
        userInfos.put("populationId", populationId);
        userInfos.put("fullname", user.getFullName());
        userInfos.put("sortablename", user.getSortableName());
        if (full) {
            String udModelId = user.getUserDirectory() != null ? user.getUserDirectory().getUserDirectoryModelId() : "";
            userInfos.put("populationLabel", this._userPopulationDAO.getUserPopulation(populationId).getLabel());
            userInfos.put("directory", this._userDirectoryFactory.hasExtension(udModelId) ? this._userDirectoryFactory.getExtension(udModelId).getLabel() : "");
            userInfos.put("lastname", user.getLastName());
            userInfos.put("firstname", user.getFirstName());
            userInfos.put("email", user.getEmail());
        }
        return userInfos;
    }

    public UserIdentity json2userIdentity(Map<String, ? extends Object> json) {
        return Optional.ofNullable(json).filter(u -> !u.isEmpty() && u.get("login") != null && u.get("populationId") != null).map(u -> new UserIdentity((String)u.get("login"), (String)u.get("populationId"))).orElse(null);
    }

    public User getUser(UserIdentity userIdentity) {
        if (userIdentity == null) {
            return null;
        }
        Request request = this._getRequest();
        if (request != null) {
            Map userCache;
            User user;
            if (request.getAttribute(__USER_CACHE_REQUEST_ATTR) == null) {
                request.setAttribute(__USER_CACHE_REQUEST_ATTR, new HashMap());
            }
            if ((user = (User)(userCache = (Map)request.getAttribute(__USER_CACHE_REQUEST_ATTR)).get(userIdentity)) != null) {
                return user;
            }
            user = this._userManager.getUser(userIdentity.getPopulationId(), userIdentity.getLogin());
            if (user != null) {
                userCache.put(userIdentity, user);
            }
            return user;
        }
        return this._userManager.getUser(userIdentity.getPopulationId(), userIdentity.getLogin());
    }

    public User getUserByEmail(String populationId, String email) {
        if (email == null) {
            return null;
        }
        try {
            Request request = this._getRequest();
            if (request != null) {
                Map userCache;
                User user;
                if (request.getAttribute(__USER_BY_EMAIL_CACHE_REQUEST_ATTR) == null) {
                    request.setAttribute(__USER_BY_EMAIL_CACHE_REQUEST_ATTR, new HashMap());
                }
                if ((user = (User)(userCache = (Map)request.getAttribute(__USER_BY_EMAIL_CACHE_REQUEST_ATTR)).get(email + "#" + populationId)) != null) {
                    return user;
                }
                user = this._userManager.getUserByEmail(populationId, email);
                if (user != null) {
                    userCache.put(email + "#" + populationId, user);
                }
                return user;
            }
            return this._userManager.getUserByEmail(populationId, email);
        }
        catch (NotUniqueUserException e) {
            return null;
        }
    }

    private Request _getRequest() {
        try {
            return ContextHelper.getRequest((Context)this._context);
        }
        catch (Exception e) {
            return null;
        }
    }

    public void saxUserIdentity(UserIdentity userIdentity, ContentHandler handler) throws SAXException {
        this.saxUserIdentity(userIdentity, handler, "user");
    }

    public void saxUserIdentity(UserIdentity userIdentity, ContentHandler handler, String tagName) throws SAXException {
        User user = this.getUser(userIdentity);
        if (user != null) {
            this.saxUser(user, handler, tagName);
        }
    }

    public void saxUser(User user, ContentHandler handler) throws SAXException {
        this.saxUser(user, handler, "user");
    }

    public void saxUser(User user, ContentHandler handler, String tagName) throws SAXException {
        AttributesImpl attr = new AttributesImpl();
        attr.addCDATAAttribute("login", user.getIdentity().getLogin());
        attr.addCDATAAttribute("population", user.getIdentity().getPopulationId());
        XMLUtils.startElement((ContentHandler)handler, (String)tagName, (Attributes)attr);
        XMLUtils.createElement((ContentHandler)handler, (String)"lastname", (String)user.getLastName());
        XMLUtils.createElement((ContentHandler)handler, (String)"firstname", (String)user.getFirstName());
        XMLUtils.createElement((ContentHandler)handler, (String)"email", (String)user.getEmail());
        XMLUtils.createElement((ContentHandler)handler, (String)"fullname", (String)user.getFullName());
        XMLUtils.createElement((ContentHandler)handler, (String)"sortablename", (String)user.getSortableName());
        this._userPopulationDAO.getUserPopulation(user.getIdentity().getPopulationId()).getLabel().toSAX(handler, "populationLabel");
        XMLUtils.endElement((ContentHandler)handler, (String)tagName);
    }
}

