/*
 * Decompiled with CFR 0.152.
 */
package org.ametys.plugins.core.userpref;

import java.io.IOException;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import org.ametys.core.user.UserIdentity;
import org.ametys.core.userpref.UserPreference;
import org.ametys.core.userpref.UserPreferencesException;
import org.ametys.core.userpref.UserPreferencesExtensionPoint;
import org.ametys.core.userpref.UserPreferencesManager;
import org.ametys.core.util.cocoon.AbstractCurrentUserProviderServiceableGenerator;
import org.ametys.runtime.i18n.I18nizableText;
import org.ametys.runtime.parameter.Enumerator;
import org.ametys.runtime.parameter.ParameterHelper;
import org.ametys.runtime.parameter.Validator;
import org.apache.avalon.framework.service.ServiceException;
import org.apache.avalon.framework.service.ServiceManager;
import org.apache.cocoon.ProcessingException;
import org.apache.cocoon.environment.ObjectModelHelper;
import org.apache.cocoon.environment.Request;
import org.apache.cocoon.xml.AttributesImpl;
import org.apache.cocoon.xml.XMLUtils;
import org.apache.commons.lang.StringUtils;
import org.xml.sax.Attributes;
import org.xml.sax.ContentHandler;
import org.xml.sax.SAXException;

public class UserPreferencesGenerator
extends AbstractCurrentUserProviderServiceableGenerator {
    protected UserPreferencesExtensionPoint _userPrefEP;
    protected UserPreferencesManager _userPrefManager;

    @Override
    public void service(ServiceManager serviceManager) throws ServiceException {
        super.service(serviceManager);
        this._userPrefEP = (UserPreferencesExtensionPoint)serviceManager.lookup(UserPreferencesExtensionPoint.ROLE);
        this._userPrefManager = (UserPreferencesManager)((Object)serviceManager.lookup(UserPreferencesManager.ROLE));
    }

    public void generate() throws IOException, SAXException, ProcessingException {
        Request request = ObjectModelHelper.getRequest((Map)this.objectModel);
        String storageContext = this.parameters.getParameter("prefContext", request.getParameter("prefContext"));
        boolean excludePrivate = this.parameters.getParameterAsBoolean("excludePrivate", false);
        Map<String, String> contextVars = this.getContextVars(request);
        UserIdentity user = this.getUser();
        if (StringUtils.isBlank((String)storageContext)) {
            throw new ProcessingException("Preferences context can't be blank");
        }
        try {
            this.contentHandler.startDocument();
            if (user != null) {
                AttributesImpl atts = new AttributesImpl();
                atts.addCDATAAttribute("username", user.getLogin());
                atts.addCDATAAttribute("userpopulation", user.getPopulationId());
                atts.addCDATAAttribute("context", storageContext);
                XMLUtils.startElement((ContentHandler)this.contentHandler, (String)"UserPreferences", (Attributes)atts);
                this._saxPreferences(storageContext, contextVars, user, excludePrivate);
                XMLUtils.endElement((ContentHandler)this.contentHandler, (String)"UserPreferences");
            } else {
                XMLUtils.createElement((ContentHandler)this.contentHandler, (String)"UserPreferences");
            }
            this.contentHandler.endDocument();
        }
        catch (UserPreferencesException e) {
            this.getLogger().error("Cannot get user preferences.", (Throwable)e);
            throw new ProcessingException("Cannot get user preferences.", (Throwable)e);
        }
    }

    protected UserIdentity getUser() {
        String login = this.parameters.getParameter("username", "");
        String populationId = this.parameters.getParameter("populationId", "");
        UserIdentity user = StringUtils.isEmpty((String)login) || StringUtils.isEmpty((String)populationId) ? this._currentUserProvider.getUser() : new UserIdentity(login, populationId);
        return user;
    }

    protected Map<String, String> getContextVars(Request request) {
        return Collections.emptyMap();
    }

    protected void _saxPreferences(String storageContext, Map<String, String> contextVars, UserIdentity user, boolean excludePrivate) throws ProcessingException, SAXException, UserPreferencesException {
        Map<I18nizableText, List<UserPreference>> groups = this._userPrefEP.getCategorizedPreferences(contextVars);
        Map<String, String> prefValues = this._userPrefManager.getUnTypedUserPrefs(user, storageContext, contextVars);
        XMLUtils.startElement((ContentHandler)this.contentHandler, (String)"groups");
        for (Map.Entry<I18nizableText, List<UserPreference>> groupEntry : groups.entrySet()) {
            I18nizableText groupLabel = groupEntry.getKey();
            List<UserPreference> groupPrefs = groupEntry.getValue();
            XMLUtils.startElement((ContentHandler)this.contentHandler, (String)"group");
            groupLabel.toSAX(this.contentHandler, "label");
            XMLUtils.startElement((ContentHandler)this.contentHandler, (String)"preferences");
            for (UserPreference preference : groupPrefs) {
                if (excludePrivate && preference.isPrivate()) continue;
                this._saxPreference(preference, prefValues.get(preference.getId()), contextVars);
            }
            XMLUtils.endElement((ContentHandler)this.contentHandler, (String)"preferences");
            XMLUtils.endElement((ContentHandler)this.contentHandler, (String)"group");
        }
        XMLUtils.endElement((ContentHandler)this.contentHandler, (String)"groups");
    }

    protected void _saxPreference(UserPreference preference, Object value, Map<String, String> contextVars) throws SAXException, ProcessingException {
        Validator validator;
        Enumerator enumerator;
        Map<String, I18nizableText> widgetParameters;
        Object defaultValue;
        AttributesImpl attr = new AttributesImpl();
        attr.addCDATAAttribute("id", preference.getId());
        attr.addCDATAAttribute("plugin", preference.getPluginName());
        attr.addCDATAAttribute("order", Integer.toString(preference.getOrder()));
        attr.addCDATAAttribute("type", ParameterHelper.typeToString((ParameterHelper.ParameterType)((Object)preference.getType())));
        attr.addCDATAAttribute("multiple", Boolean.toString(preference.isMultiple()));
        attr.addCDATAAttribute("private", Boolean.toString(preference.isPrivate()));
        XMLUtils.startElement((ContentHandler)this.contentHandler, (String)"preference", (Attributes)attr);
        if (preference.getLabel() != null) {
            preference.getLabel().toSAX(this.contentHandler, "label");
        }
        if (preference.getDescription() != null) {
            preference.getDescription().toSAX(this.contentHandler, "description");
        }
        if ((defaultValue = preference.getDefaultValue()) != null) {
            XMLUtils.createElement((ContentHandler)this.contentHandler, (String)"defaultValue", (String)ParameterHelper.valueToString(defaultValue));
        }
        if (value != null) {
            XMLUtils.createElement((ContentHandler)this.contentHandler, (String)"value", (String)ParameterHelper.valueToString(value));
        } else if (defaultValue != null) {
            XMLUtils.createElement((ContentHandler)this.contentHandler, (String)"value", (String)ParameterHelper.valueToString(defaultValue));
        }
        if (preference.getWidget() != null) {
            XMLUtils.createElement((ContentHandler)this.contentHandler, (String)"widget", (String)preference.getWidget());
        }
        if ((widgetParameters = preference.getWidgetParameters()) != null && !widgetParameters.isEmpty()) {
            XMLUtils.startElement((ContentHandler)this.contentHandler, (String)"widget-params");
            for (String paramName : widgetParameters.keySet()) {
                XMLUtils.startElement((ContentHandler)this.contentHandler, (String)paramName);
                widgetParameters.get(paramName).toSAX(this.contentHandler);
                XMLUtils.endElement((ContentHandler)this.contentHandler, (String)paramName);
            }
            XMLUtils.endElement((ContentHandler)this.contentHandler, (String)"widget-params");
        }
        if ((enumerator = preference.getEnumerator()) != null) {
            ParameterHelper.toSAXEnumerator(this.contentHandler, enumerator);
        }
        if ((validator = preference.getValidator()) != null) {
            ParameterHelper.toSAXValidator(this.contentHandler, validator);
        }
        XMLUtils.endElement((ContentHandler)this.contentHandler, (String)"preference");
    }
}

