/*
 * Decompiled with CFR 0.152.
 */
package org.ametys.plugins.core.userpref;

import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.ametys.core.user.UserIdentity;
import org.ametys.core.userpref.UserPreference;
import org.ametys.core.userpref.UserPreferencesException;
import org.ametys.core.userpref.UserPreferencesExtensionPoint;
import org.ametys.core.userpref.UserPreferencesManager;
import org.ametys.core.util.cocoon.AbstractCurrentUserProviderServiceableGenerator;
import org.ametys.runtime.parameter.ParameterHelper;
import org.apache.avalon.framework.service.ServiceException;
import org.apache.avalon.framework.service.ServiceManager;
import org.apache.cocoon.ProcessingException;
import org.apache.cocoon.environment.ObjectModelHelper;
import org.apache.cocoon.environment.Request;
import org.apache.cocoon.xml.AttributesImpl;
import org.apache.cocoon.xml.XMLUtils;
import org.apache.commons.lang.StringUtils;
import org.xml.sax.Attributes;
import org.xml.sax.ContentHandler;
import org.xml.sax.SAXException;

public class UserPreferencesValuesGenerator
extends AbstractCurrentUserProviderServiceableGenerator {
    protected UserPreferencesManager _userPrefManager;
    protected UserPreferencesExtensionPoint _userPrefEP;

    @Override
    public void service(ServiceManager serviceManager) throws ServiceException {
        super.service(serviceManager);
        this._userPrefEP = (UserPreferencesExtensionPoint)serviceManager.lookup(UserPreferencesExtensionPoint.ROLE);
        this._userPrefManager = (UserPreferencesManager)((Object)serviceManager.lookup(UserPreferencesManager.ROLE));
    }

    public void generate() throws IOException, SAXException, ProcessingException {
        Request request = ObjectModelHelper.getRequest((Map)this.objectModel);
        String storageContext = request.getParameter("prefContext");
        if (storageContext == null) {
            storageContext = this.parameters.getParameter("prefContext", null);
        }
        UserIdentity user = this.getUser();
        Map<String, String> contextVars = this.getContextVars(request);
        this.contentHandler.startDocument();
        AttributesImpl attrs = new AttributesImpl();
        attrs.addCDATAAttribute("prefContext", storageContext);
        XMLUtils.startElement((ContentHandler)this.contentHandler, (String)"userprefs", (Attributes)attrs);
        try {
            Map<String, String> prefValues = this._userPrefManager.getUnTypedUserPrefs(user, storageContext, contextVars);
            Map<String, UserPreference> userPrefsDefinitions = this._userPrefEP.getUserPreferences(contextVars);
            Map jsParameters = (Map)this.objectModel.get("parent-context");
            ArrayList<String> userprefs = null;
            if (jsParameters != null) {
                userprefs = (List)jsParameters.get("userprefs");
            }
            if (userprefs == null || userprefs.size() == 0) {
                userprefs = new ArrayList<String>(userPrefsDefinitions.keySet());
            }
            for (String userpref : userprefs) {
                Object defaultValue;
                if (prefValues.containsKey(userpref)) {
                    XMLUtils.createElement((ContentHandler)this.contentHandler, (String)userpref, (String)prefValues.get(userpref));
                    continue;
                }
                UserPreference userPref = userPrefsDefinitions.get(userpref);
                if (userPref == null || (defaultValue = userPref.getDefaultValue()) == null) continue;
                XMLUtils.createElement((ContentHandler)this.contentHandler, (String)userpref, (String)ParameterHelper.valueToString(defaultValue));
            }
        }
        catch (UserPreferencesException e) {
            this.getLogger().error("Cannot get user preferences.", (Throwable)e);
            throw new ProcessingException("Cannot get user preferences.", (Throwable)e);
        }
        XMLUtils.endElement((ContentHandler)this.contentHandler, (String)"userprefs");
        this.contentHandler.endDocument();
    }

    protected UserIdentity getUser() {
        String login = this.parameters.getParameter("username", "");
        String populationId = this.parameters.getParameter("populationId", "");
        UserIdentity user = StringUtils.isEmpty((String)login) || StringUtils.isEmpty((String)populationId) ? this._currentUserProvider.getUser() : new UserIdentity(login, populationId);
        return user;
    }

    protected Map<String, String> getContextVars(Request request) {
        HashMap<String, String> contextVars = new HashMap<String, String>();
        contextVars.put("workspace", (String)request.getAttribute("workspaceName"));
        return contextVars;
    }
}

