/*
 * Decompiled with CFR 0.152.
 */
package org.ametys.runtime.model;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import org.ametys.runtime.config.DisableCondition;
import org.ametys.runtime.config.DisableConditions;
import org.ametys.runtime.i18n.I18nizableText;
import org.ametys.runtime.model.AbstractModelItem;
import org.ametys.runtime.model.Enumerator;
import org.ametys.runtime.model.type.ElementType;
import org.ametys.runtime.parameter.Validator;
import org.apache.cocoon.ProcessingException;

public class ElementDefinition<T>
extends AbstractModelItem {
    private String _pluginName;
    private ElementType<T> _type;
    private String _widget;
    private Map<String, I18nizableText> _widgetParams;
    private Enumerator<T> _enumerator;
    private Validator _validator;
    private T _defaultValue;
    private boolean _isMultiple;
    private DisableConditions _disableConditions;

    public String getPluginName() {
        return this._pluginName;
    }

    public void setPluginName(String pluginName) {
        this._pluginName = pluginName;
    }

    public ElementType<T> getType() {
        return this._type;
    }

    public void setType(ElementType<T> type) {
        this._type = type;
    }

    public String getWidget() {
        return this._widget;
    }

    public void setWidget(String widget) {
        this._widget = widget;
    }

    public Map<String, I18nizableText> getWidgetParameters() {
        return this._widgetParams;
    }

    public void setWidgetParameters(Map<String, I18nizableText> params) {
        this._widgetParams = params;
    }

    public Enumerator<T> getEnumerator() {
        return this._enumerator;
    }

    public void setEnumerator(Enumerator<T> enumerator) {
        this._enumerator = enumerator;
    }

    public Validator getValidator() {
        return this._validator;
    }

    public void setValidator(Validator validator) {
        this._validator = validator;
    }

    public T getDefaultValue() {
        return this._defaultValue;
    }

    public void setDefaultValue(T defaultValue) {
        this._defaultValue = defaultValue;
    }

    public boolean isMultiple() {
        return this._isMultiple;
    }

    public void setMultiple(boolean isMultiple) {
        this._isMultiple = isMultiple;
    }

    public DisableConditions getDisableConditions() {
        return this._disableConditions;
    }

    public void setDisableConditions(DisableConditions disableConditions) {
        this._disableConditions = disableConditions;
    }

    @Override
    public Map<String, Object> toJSON() throws ProcessingException {
        Map<String, Object> result = super.toJSON();
        result.put("plugin", this.getPluginName());
        result.put("multiple", this.isMultiple());
        if (this.getType() != null) {
            result.put("type", this.getType().getId());
            result.put("default-value", this.getType().valueToJSONForClient(this.getDefaultValue()));
        }
        if (this.getValidator() != null) {
            result.put("validation", this.getValidator().getConfiguration());
        }
        if (this.getEnumerator() != null) {
            ArrayList enumeration = new ArrayList();
            try {
                Map<T, I18nizableText> entries = this.getEnumerator().getTypedEntries();
                for (Map.Entry<T, I18nizableText> entry : entries.entrySet()) {
                    HashMap<String, Object> option = new HashMap<String, Object>();
                    option.put("value", this.getType().valueToJSONForClient(entry.getKey()));
                    option.put("label", entry.getValue());
                    enumeration.add(option);
                }
            }
            catch (Exception e) {
                throw new ProcessingException("Unable to enumerate entries with enumerator: " + this.getEnumerator(), (Throwable)e);
            }
            result.put("enumeration", enumeration);
            result.put("enumerationConfig", this.getEnumerator().getConfiguration());
        }
        result.put("widget", this.getWidget());
        Map<String, I18nizableText> widgetParameters = this.getWidgetParameters();
        if (widgetParameters != null && !widgetParameters.isEmpty()) {
            result.put("widget-params", widgetParameters);
        }
        if (this.getDisableConditions() != null) {
            result.put("disableCondition", this._disableConditionstoJSON(this.getDisableConditions()));
        }
        return result;
    }

    private Map<String, Object> _disableConditionstoJSON(DisableConditions disableConditions) {
        HashMap<String, Object> map = new HashMap<String, Object>();
        ArrayList<Map<String, String>> disableConditionList = new ArrayList<Map<String, String>>();
        map.put("condition", disableConditionList);
        for (DisableCondition disableCondition : disableConditions.getConditions()) {
            Map<String, String> disableConditionAsMap = ElementDefinition._disableConditiontoJSON(disableCondition);
            disableConditionList.add(disableConditionAsMap);
        }
        ArrayList<Map<String, Object>> disableConditionsList = new ArrayList<Map<String, Object>>();
        map.put("conditions", disableConditionsList);
        for (DisableConditions subDisableConditions : disableConditions.getSubConditions()) {
            Map<String, Object> disableConditionsAsMap = this._disableConditionstoJSON(subDisableConditions);
            disableConditionsList.add(disableConditionsAsMap);
        }
        map.put("type", disableConditions.getAssociationType().toString().toLowerCase());
        return map;
    }

    private static Map<String, String> _disableConditiontoJSON(DisableCondition disableCondition) {
        HashMap<String, String> map = new HashMap<String, String>();
        map.put("id", disableCondition.getId());
        map.put("operator", disableCondition.getOperator().toString().toLowerCase());
        map.put("value", disableCondition.getValue());
        return map;
    }
}

