/*
 * Decompiled with CFR 0.152.
 */
package org.ametys.runtime.model;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import org.ametys.runtime.model.AbstractModelItem;
import org.ametys.runtime.model.ElementDefinition;
import org.ametys.runtime.model.ModelItem;
import org.ametys.runtime.model.ModelItemContainer;
import org.ametys.runtime.model.UndefinedItemPathException;
import org.ametys.runtime.model.type.ElementType;
import org.apache.cocoon.ProcessingException;
import org.apache.commons.lang3.StringUtils;

public class ModelItemGroup
extends AbstractModelItem
implements ModelItemContainer {
    private static final String __TYPE = "composite";
    private List<ModelItem> _children = new ArrayList<ModelItem>();
    private ElementDefinition<Boolean> _switcher;

    @Override
    public ModelItem getModelItem(String itemPath) throws UndefinedItemPathException {
        Object[] pathSegments = StringUtils.split((String)itemPath, (String)"/");
        ModelItem child = this.getChild(pathSegments[0]);
        if (child == null) {
            throw new UndefinedItemPathException("The item '" + pathSegments[0] + "' is not defined in the group '" + this.getName() + "' in model '" + this.getModel() + "'.");
        }
        if (pathSegments.length == 1) {
            return child;
        }
        if (child instanceof ModelItemContainer) {
            String subDataPath = StringUtils.join((Object[])pathSegments, (String)"/", (int)1, (int)pathSegments.length);
            return ((ModelItemGroup)child).getModelItem(subDataPath);
        }
        throw new UndefinedItemPathException("The item '" + (String)pathSegments[0] + "' in the group '" + this.getName() + "' in model '" + this.getModel() + "' is not an item cotainer. It can't be followed by other items in the path.");
    }

    public Collection<ModelItem> getModelItems() {
        return this.getChildren();
    }

    public ModelItem getChild(String childName) {
        for (ModelItem child : this.getChildren()) {
            if (!child.getName().equals(childName)) continue;
            return child;
        }
        return null;
    }

    public List<ModelItem> getChildren() {
        return this.getChildren(true);
    }

    public List<ModelItem> getChildren(boolean withSwitch) {
        if (withSwitch || this._switcher == null) {
            return Collections.unmodifiableList(this._children);
        }
        ArrayList<ModelItem> childrenWithoutSwitcher = new ArrayList<ModelItem>(this._children);
        childrenWithoutSwitcher.remove(this._switcher);
        return childrenWithoutSwitcher;
    }

    public void addChild(ModelItem child) {
        this.addChild(child, false);
    }

    public void addChild(ModelItem child, boolean isGroupSwitch) {
        this._children.add(child);
        child.setParent(this);
        if (isGroupSwitch) {
            if (this._switcher == null) {
                ElementType type;
                if (child instanceof ElementDefinition && "boolean".equals((type = ((ElementDefinition)child).getType()).getId())) {
                    this._switcher = (ElementDefinition)child;
                }
                if (this._switcher == null) {
                    throw new RuntimeException("The group '" + this.getLabel() + "' has a switch '" + child + "' that is not valid because it is not a boolean.");
                }
            } else {
                throw new RuntimeException("At least two group-switches have been defined for the configuration group '" + this.getLabel() + "'. These parameters are '" + this._switcher + "' and '" + child + "'.");
            }
        }
    }

    public ElementDefinition<Boolean> getSwitcher() {
        return this._switcher;
    }

    @Override
    public Map<String, Object> toJSON() throws ProcessingException {
        return this.toJSON(true);
    }

    public Map<String, Object> toJSON(boolean includeChildren) throws ProcessingException {
        Map<String, Object> result = super.toJSON();
        result.put("type", __TYPE);
        ElementDefinition<Boolean> switcher = this.getSwitcher();
        if (switcher != null) {
            HashMap<String, Object> switcherToJSON = new HashMap<String, Object>();
            switcherToJSON.put("id", switcher.getName());
            switcherToJSON.put("label", switcher.getLabel());
            if (switcher.getType() != null) {
                switcherToJSON.put("default-value", switcher.getType().valueToJSONForClient(switcher.getDefaultValue()));
            }
            result.put("switcher", switcherToJSON);
        }
        List<ModelItem> children = this.getChildren(false);
        if (includeChildren && !children.isEmpty()) {
            LinkedHashMap<String, Map<String, Object>> elements = new LinkedHashMap<String, Map<String, Object>>();
            for (ModelItem child : children) {
                String name = child.getName();
                if (name == null) continue;
                elements.put(name, child.toJSON());
            }
            result.put("elements", elements);
        }
        return result;
    }
}

