/*
 * Decompiled with CFR 0.152.
 */
package org.ametys.runtime.model;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.ametys.runtime.i18n.I18nizableText;
import org.ametys.runtime.model.ElementDefinition;
import org.ametys.runtime.model.Model;
import org.ametys.runtime.model.ModelItem;
import org.ametys.runtime.model.ModelItemGroup;
import org.ametys.runtime.model.ModelViewItemGroup;
import org.ametys.runtime.model.ViewElement;
import org.ametys.runtime.model.ViewHelper;
import org.ametys.runtime.model.ViewItem;
import org.ametys.runtime.model.ViewItemContainer;
import org.ametys.runtime.util.ModifiableLabelable;
import org.apache.cocoon.ProcessingException;

public class View
implements ViewItemContainer,
ModifiableLabelable {
    private String _name;
    private I18nizableText _label;
    private I18nizableText _description;
    private String _iconGlyph;
    private String _iconDecorator;
    private String _smallIcon;
    private String _mediumIcon;
    private String _largeIcon;
    private List<ViewItem> _items = new ArrayList<ViewItem>();

    public View() {
    }

    public View(Model model, String ... itemPaths) {
        this(model, true, itemPaths);
    }

    public View(Model model, boolean recursive, String ... itemPaths) {
        for (String itemPath : itemPaths) {
            if (!model.hasModelItem(itemPath)) {
                throw new IllegalArgumentException("Item " + itemPath + "not found in " + model.getClass() + " model: " + model.toString());
            }
            ModelItem definition = model.getModelItem(itemPath);
            this.addViewItem(this._getViewItemFromDefinition(definition, recursive));
        }
    }

    private ViewItem _getViewItemFromDefinition(ModelItem definition, Boolean recursive) {
        if (definition instanceof ModelItemGroup) {
            ModelViewItemGroup modelViewItemGroup = new ModelViewItemGroup();
            modelViewItemGroup.setDefinition((ModelItemGroup)definition);
            if (recursive.booleanValue()) {
                List<ModelItem> children = ((ModelItemGroup)definition).getChildren();
                for (ModelItem child : children) {
                    modelViewItemGroup.addViewItem(this._getViewItemFromDefinition(child, recursive));
                }
            }
            return modelViewItemGroup;
        }
        ViewElement viewElement = new ViewElement();
        viewElement.setDefinition((ElementDefinition)definition);
        return viewElement;
    }

    @Override
    public String getName() {
        return this._name;
    }

    @Override
    public void setName(String name) {
        this._name = name;
    }

    @Override
    public I18nizableText getLabel() {
        return this._label;
    }

    @Override
    public void setLabel(I18nizableText label) {
        this._label = label;
    }

    @Override
    public I18nizableText getDescription() {
        return this._description;
    }

    @Override
    public void setDescription(I18nizableText description) {
        this._description = description;
    }

    public String getIconGlyph() {
        return this._iconGlyph;
    }

    public void setIconGlyph(String iconGlyph) {
        this._iconGlyph = iconGlyph;
    }

    public String getIconDecorator() {
        return this._iconDecorator;
    }

    public void setIconDecorator(String iconDecorator) {
        this._iconDecorator = iconDecorator;
    }

    public String getSmallIcon() {
        return this._smallIcon;
    }

    public void setSmallIcon(String smallIcon) {
        this._smallIcon = smallIcon;
    }

    public String getMediumIcon() {
        return this._mediumIcon;
    }

    public void setMediumIcon(String mediumIcon) {
        this._mediumIcon = mediumIcon;
    }

    public String getLargeIcon() {
        return this._largeIcon;
    }

    public void setLargeIcon(String largeIcon) {
        this._largeIcon = largeIcon;
    }

    @Override
    public List<ViewItem> getViewItems() {
        return Collections.unmodifiableList(this._items);
    }

    @Override
    public boolean hasViewItem(String itemName) {
        return ViewHelper.hasViewItem(this, itemName);
    }

    @Override
    public void addViewItem(ViewItem item) {
        this._items.add(item);
    }

    public Map<String, Object> toJSON() throws ProcessingException {
        HashMap<String, Object> result = new HashMap<String, Object>();
        result.put("name", this.getName());
        result.put("label", this.getLabel());
        result.put("description", this.getDescription());
        result.put("icon-glyph", this.getIconGlyph());
        result.put("icon-decorator", this.getIconDecorator());
        result.put("small-icon-path", this.getSmallIcon());
        result.put("medium-icon-path", this.getMediumIcon());
        result.put("large-icon-path", this.getLargeIcon());
        ArrayList<Map<String, Object>> groups = new ArrayList<Map<String, Object>>();
        for (ViewItem item : this.getViewItems()) {
            if (item instanceof ViewElement) {
                result.putAll(item.toJSON());
                continue;
            }
            groups.add(item.toJSON());
        }
        if (!groups.isEmpty()) {
            result.put("groups", groups);
        }
        return result;
    }

    public void includeView(View viewToInclude) {
        ViewHelper.addViewContainerItems(this, viewToInclude, this);
    }
}

