/*
 * Decompiled with CFR 0.152.
 */
package org.ametys.runtime.model;

import org.ametys.runtime.model.SimpleViewItemGroup;
import org.ametys.runtime.model.View;
import org.ametys.runtime.model.ViewItem;
import org.ametys.runtime.model.ViewItemContainer;

public final class ViewHelper {
    private ViewHelper() {
    }

    public static boolean hasViewItem(ViewItemContainer container, String itemName) {
        if (itemName == null) {
            return false;
        }
        for (ViewItem item : container.getViewItems()) {
            if (itemName.equals(item.getName())) {
                return true;
            }
            if (!(item instanceof SimpleViewItemGroup) || !((ViewItemContainer)((Object)item)).hasViewItem(itemName)) continue;
            return true;
        }
        return false;
    }

    public static void addViewContainerItems(ViewItemContainer currentContainer, ViewItemContainer containerToInclude, View referenceView) {
        for (ViewItem itemToCopy : containerToInclude.getViewItems()) {
            if (itemToCopy instanceof SimpleViewItemGroup) {
                SimpleViewItemGroup groupToCopy = (SimpleViewItemGroup)itemToCopy;
                SimpleViewItemGroup group = new SimpleViewItemGroup();
                group.copyGroupItem(groupToCopy, referenceView);
                if (group.getViewItems().isEmpty()) continue;
                currentContainer.addViewItem(group);
                continue;
            }
            String itemName = itemToCopy.getName();
            if (currentContainer.hasViewItem(itemName) || referenceView.hasViewItem(itemName)) continue;
            currentContainer.addViewItem(itemToCopy);
        }
    }
}

