/*
 * Decompiled with CFR 0.152.
 */
package org.ametys.runtime.parameter;

import java.util.HashMap;
import java.util.Map;
import org.ametys.plugins.core.ui.util.ConfigurationHelper;
import org.ametys.runtime.i18n.I18nizableText;
import org.ametys.runtime.parameter.DefaultValidator;
import org.ametys.runtime.parameter.Enumerator;
import org.ametys.runtime.parameter.Parameter;
import org.ametys.runtime.parameter.StaticEnumerator;
import org.ametys.runtime.parameter.Validator;
import org.ametys.runtime.plugin.component.ThreadSafeComponentManager;
import org.apache.avalon.framework.component.ComponentException;
import org.apache.avalon.framework.configuration.Configuration;
import org.apache.avalon.framework.configuration.ConfigurationException;
import org.apache.avalon.framework.service.ServiceManager;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Deprecated
public abstract class AbstractParameterParser<P extends Parameter<T>, T extends Enum<T>> {
    private static final Logger __LOGGER = LoggerFactory.getLogger(AbstractParameterParser.class);
    protected ThreadSafeComponentManager<Enumerator> _enumeratorManager;
    protected ThreadSafeComponentManager<Validator> _validatorManager;
    private final Map<P, String> _validatorsToLookup = new HashMap<P, String>();
    private final Map<P, String> _enumeratorsToLookup = new HashMap<P, String>();

    public AbstractParameterParser(ThreadSafeComponentManager<Enumerator> enumeratorManager, ThreadSafeComponentManager<Validator> validatorManager) {
        this._enumeratorManager = enumeratorManager;
        this._validatorManager = validatorManager;
    }

    public P parseParameter(ServiceManager manager, String pluginName, Configuration parameterConfig) throws ConfigurationException {
        P parameter = this._createParameter(parameterConfig);
        String parameterId = this._parseId(parameterConfig);
        ((Parameter)parameter).setId(parameterId);
        ((Parameter)parameter).setPluginName(pluginName);
        ((Parameter)parameter).setLabel(this._parseI18nizableText(parameterConfig, pluginName, "label"));
        ((Parameter)parameter).setDescription(this._parseI18nizableText(parameterConfig, pluginName, "description"));
        ((Parameter)parameter).setType(this._parseType(parameterConfig));
        ((Parameter)parameter).setWidget(this._parseWidget(parameterConfig));
        ((Parameter)parameter).setWidgetParameters(this._parseWidgetParameters(parameterConfig, pluginName));
        this._parseAndSetEnumerator(pluginName, parameter, parameterId, parameterConfig);
        this._parseAndSetValidator(pluginName, parameter, parameterId, parameterConfig);
        ((Parameter)parameter).setDefaultValue(this._parseDefaultValue(parameterConfig, parameter));
        this._additionalParsing(manager, pluginName, parameterConfig, parameterId, parameter);
        return parameter;
    }

    public void lookupComponents() throws Exception {
        Parameter parameter;
        this._validatorManager.initialize();
        this._enumeratorManager.initialize();
        for (Map.Entry<P, String> entry : this._validatorsToLookup.entrySet()) {
            parameter = (Parameter)entry.getKey();
            String validatorRole = entry.getValue();
            try {
                parameter.setValidator(this._validatorManager.lookup(validatorRole));
            }
            catch (ComponentException e) {
                throw new Exception("Unable to lookup validator role: '" + validatorRole + "' for parameter: " + parameter, e);
            }
        }
        for (Map.Entry<P, String> entry : this._enumeratorsToLookup.entrySet()) {
            parameter = (Parameter)entry.getKey();
            String enumeratorRole = entry.getValue();
            try {
                parameter.setEnumerator(this._enumeratorManager.lookup(enumeratorRole));
            }
            catch (ComponentException e) {
                throw new Exception("Unable to lookup enumerator role: '" + enumeratorRole + "' for parameter: " + parameter, e);
            }
        }
    }

    protected abstract P _createParameter(Configuration var1) throws ConfigurationException;

    protected abstract String _parseId(Configuration var1) throws ConfigurationException;

    protected I18nizableText _parseI18nizableText(Configuration config, String pluginName, String name) throws ConfigurationException {
        return I18nizableText.parseI18nizableText(config.getChild(name), "plugin." + pluginName);
    }

    protected abstract T _parseType(Configuration var1) throws ConfigurationException;

    protected String _parseWidget(Configuration parameterConfig) throws ConfigurationException {
        return parameterConfig.getChild("widget").getValue(null);
    }

    protected Map<String, I18nizableText> _parseWidgetParameters(Configuration parameterConfig, String pluginName) throws ConfigurationException {
        HashMap<String, I18nizableText> widgetParams = new HashMap<String, I18nizableText>();
        Configuration widgetParamsConfig = parameterConfig.getChild("widget-params", false);
        if (widgetParamsConfig != null) {
            Map<String, Object> parsedParams = ConfigurationHelper.parsePluginParameters(widgetParamsConfig, pluginName, __LOGGER);
            for (Map.Entry<String, Object> param : parsedParams.entrySet()) {
                String paramName = param.getKey();
                Object value = param.getValue();
                if (value instanceof I18nizableText) {
                    widgetParams.put(paramName, (I18nizableText)value);
                    continue;
                }
                if (value instanceof String) {
                    widgetParams.put(paramName, new I18nizableText((String)value));
                    continue;
                }
                __LOGGER.warn("Widget parameter '{}' at location {} is of type [{}] which is not supported. It will be ignored.", new Object[]{paramName, parameterConfig.getLocation(), value.getClass()});
            }
        }
        return widgetParams;
    }

    protected void _parseAndSetEnumerator(String pluginName, P parameter, String parameterId, Configuration parameterConfig) throws ConfigurationException {
        Configuration enumeratorConfig = parameterConfig.getChild("enumeration", false);
        if (enumeratorConfig != null) {
            Configuration customEnumerator = enumeratorConfig.getChild("custom-enumerator", false);
            if (customEnumerator != null) {
                String enumeratorClassName = customEnumerator.getAttribute("class");
                try {
                    Class<?> enumeratorClass = Class.forName(enumeratorClassName);
                    this._enumeratorManager.addComponent(pluginName, null, parameterId, enumeratorClass, parameterConfig);
                }
                catch (Exception e) {
                    throw new ConfigurationException("Unable to instantiate enumerator for class: " + enumeratorClassName, (Throwable)e);
                }
                this._enumeratorsToLookup.put(parameter, parameterId);
            } else {
                StaticEnumerator staticEnumerator = new StaticEnumerator();
                for (Configuration entryConfig : enumeratorConfig.getChildren("entry")) {
                    String value = entryConfig.getChild("value").getValue("");
                    I18nizableText label = null;
                    if (entryConfig.getChild("label", false) != null) {
                        label = this._parseI18nizableText(entryConfig, pluginName, "label");
                    }
                    staticEnumerator.add(label, value);
                }
                ((Parameter)parameter).setEnumerator(staticEnumerator);
            }
        }
    }

    protected void _parseAndSetValidator(String pluginName, P parameter, String parameterId, Configuration parameterConfig) throws ConfigurationException {
        Configuration validatorConfig = parameterConfig.getChild("validation", false);
        if (validatorConfig != null) {
            String validatorClassName = (String)StringUtils.defaultIfBlank((CharSequence)validatorConfig.getChild("custom-validator").getAttribute("class", ""), (CharSequence)DefaultValidator.class.getName());
            try {
                Class<?> validatorClass = Class.forName(validatorClassName);
                this._validatorManager.addComponent(pluginName, null, parameterId, validatorClass, parameterConfig);
            }
            catch (Exception e) {
                throw new ConfigurationException("Unable to instantiate validator for class: " + validatorClassName, (Throwable)e);
            }
            this._validatorsToLookup.put(parameter, parameterId);
        }
    }

    protected abstract Object _parseDefaultValue(Configuration var1, P var2) throws ConfigurationException;

    protected void _additionalParsing(ServiceManager manager, String pluginName, Configuration parameterConfig, String parameterId, P parameter) throws ConfigurationException {
    }
}

