/*
 * Decompiled with CFR 0.152.
 */
package org.ametys.runtime.parameter;

import java.io.InputStream;
import java.time.LocalDateTime;
import java.time.ZonedDateTime;
import java.time.chrono.IsoChronology;
import java.time.format.DateTimeFormatter;
import java.time.format.ResolverStyle;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.Map;
import org.ametys.core.util.DateUtils;
import org.ametys.runtime.i18n.I18nizableText;
import org.ametys.runtime.model.ElementDefinition;
import org.ametys.runtime.parameter.Enumerator;
import org.ametys.runtime.parameter.Parameter;
import org.ametys.runtime.parameter.Validator;
import org.apache.cocoon.ProcessingException;
import org.apache.cocoon.xml.AttributesImpl;
import org.apache.cocoon.xml.XMLUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.xml.sax.Attributes;
import org.xml.sax.ContentHandler;
import org.xml.sax.SAXException;

@Deprecated
public final class ParameterHelper {
    private static DateTimeFormatter __ISO_OFFSET_DATE_TIME = DateTimeFormatter.ofPattern("yyyy-MM-dd'T'HH:mm:ss.SSSXXX").withResolverStyle(ResolverStyle.STRICT).withChronology(IsoChronology.INSTANCE);
    private static Logger _logger = LoggerFactory.getLogger(ParameterHelper.class);

    private ParameterHelper() {
    }

    public static DateTimeFormatter getISODateTimeFormatter() {
        return __ISO_OFFSET_DATE_TIME;
    }

    public static String typeToString(ParameterType type) {
        return type.name().toLowerCase();
    }

    public static ParameterType stringToType(String type) {
        try {
            return ParameterType.valueOf(type.toUpperCase());
        }
        catch (IllegalArgumentException e) {
            throw new IllegalArgumentException("The type '" + type + "' is unknown for config parameters");
        }
    }

    public static Object castValue(String value, ParameterType type) {
        block12: {
            if (value == null) {
                return null;
            }
            try {
                if (type == ParameterType.BOOLEAN) {
                    return new Boolean(value);
                }
                if (type == ParameterType.STRING) {
                    return value;
                }
                if (type == ParameterType.PASSWORD) {
                    return value;
                }
                if (type == ParameterType.DATASOURCE) {
                    return value;
                }
                if (type == ParameterType.LONG) {
                    return new Long(value);
                }
                if (type == ParameterType.DOUBLE) {
                    return new Double(value);
                }
                if (type == ParameterType.DATE) {
                    LocalDateTime ldt = LocalDateTime.parse(value, DateTimeFormatter.ISO_DATE_TIME);
                    return DateUtils.asDate(ldt);
                }
                if (type == ParameterType.BINARY) {
                    return null;
                }
            }
            catch (Exception nfe) {
                if (value.length() != 0) {
                    _logger.error("Cannot cast value '" + value + "' into type '" + ParameterHelper.typeToString(type) + "'. Null object will be used.", (Throwable)nfe);
                }
                if (!_logger.isDebugEnabled()) break block12;
                _logger.debug("Failed to cast empty string to type '" + ParameterHelper.typeToString(type) + "'. Null object will be used.", (Throwable)nfe);
            }
        }
        return null;
    }

    public static String valueToString(Object value) {
        if (value == null) {
            return null;
        }
        if (value instanceof Date) {
            ZonedDateTime zdt = DateUtils.asZonedDateTime((Date)value, null);
            return zdt.format(ParameterHelper.getISODateTimeFormatter());
        }
        if (value instanceof InputStream) {
            throw new IllegalArgumentException("The object to convert is an input stream");
        }
        return value.toString();
    }

    public static void toSAXParameter(ContentHandler handler, Parameter parameter, Object value) throws SAXException, ProcessingException {
        AttributesImpl parameterAttr = new AttributesImpl();
        parameterAttr.addAttribute("", "plugin", "plugin", "CDATA", parameter.getPluginName());
        XMLUtils.startElement((ContentHandler)handler, (String)parameter.getId(), (Attributes)parameterAttr);
        ParameterHelper.toSAXParameterInternal(handler, parameter, value);
        XMLUtils.endElement((ContentHandler)handler, (String)parameter.getId());
    }

    public static void toSAXParameterInternal(ContentHandler handler, Parameter parameter, Object value) throws SAXException, ProcessingException {
        Enumerator enumerator;
        Map<String, I18nizableText> widgetParameters;
        parameter.getLabel().toSAX(handler, "label");
        parameter.getDescription().toSAX(handler, "description");
        XMLUtils.createElement((ContentHandler)handler, (String)"type", (String)ParameterHelper.typeToString((ParameterType)((Object)parameter.getType())));
        Object defaultValue = parameter.getDefaultValue();
        if (defaultValue != null) {
            XMLUtils.createElement((ContentHandler)handler, (String)"default-value", (String)ParameterHelper.valueToString(defaultValue));
        }
        if (value != null) {
            XMLUtils.createElement((ContentHandler)handler, (String)"value", (String)ParameterHelper.valueToString(value));
        }
        if (parameter.getWidget() != null) {
            XMLUtils.createElement((ContentHandler)handler, (String)"widget", (String)parameter.getWidget());
        }
        if ((widgetParameters = parameter.getWidgetParameters()).size() > 0) {
            XMLUtils.startElement((ContentHandler)handler, (String)"widget-params");
            for (String paramName : widgetParameters.keySet()) {
                XMLUtils.startElement((ContentHandler)handler, (String)paramName);
                widgetParameters.get(paramName).toSAX(handler);
                XMLUtils.endElement((ContentHandler)handler, (String)paramName);
            }
            XMLUtils.endElement((ContentHandler)handler, (String)"widget-params");
        }
        if ((enumerator = parameter.getEnumerator()) != null) {
            ParameterHelper.toSAXEnumerator(handler, enumerator);
        }
        Validator validator = parameter.getValidator();
        ParameterHelper.toSAXValidator(handler, validator);
    }

    public static void toSAXEnumerator(ContentHandler handler, Enumerator enumerator) throws SAXException, ProcessingException {
        XMLUtils.startElement((ContentHandler)handler, (String)"enumeration");
        try {
            for (Map.Entry<Object, I18nizableText> entry : enumerator.getEntries().entrySet()) {
                String valueAsString = ParameterHelper.valueToString(entry.getKey());
                I18nizableText label = entry.getValue();
                AttributesImpl attrs = new AttributesImpl();
                attrs.addCDATAAttribute("value", valueAsString);
                XMLUtils.startElement((ContentHandler)handler, (String)"option", (Attributes)attrs);
                if (label != null) {
                    label.toSAX(handler);
                } else {
                    XMLUtils.data((ContentHandler)handler, (String)valueAsString);
                }
                XMLUtils.endElement((ContentHandler)handler, (String)"option");
            }
        }
        catch (Exception e) {
            throw new ProcessingException("Unable to enumerate entries with enumerator: " + enumerator, (Throwable)e);
        }
        XMLUtils.endElement((ContentHandler)handler, (String)"enumeration");
    }

    public static void toSAXValidator(ContentHandler handler, Validator validator) throws SAXException {
        if (validator != null) {
            XMLUtils.startElement((ContentHandler)handler, (String)"validation");
            Map<String, Object> configuration = validator.getConfiguration();
            for (Map.Entry<String, Object> entry : configuration.entrySet()) {
                ParameterHelper._saxConfigurationObject(handler, entry.getKey(), entry.getValue());
            }
            XMLUtils.endElement((ContentHandler)handler, (String)"validation");
        }
    }

    private static void _saxConfigurationObject(ContentHandler handler, String name, Object value) throws SAXException {
        if (value instanceof I18nizableText) {
            ((I18nizableText)value).toSAX(handler, name);
        } else if (value instanceof Collection) {
            for (Object item : (Collection)value) {
                if (item == null) continue;
                ParameterHelper._saxConfigurationObject(handler, name, item);
            }
        } else if (value instanceof Map) {
            XMLUtils.startElement((ContentHandler)handler, (String)name);
            for (Map.Entry subEntry : ((Map)value).entrySet()) {
                ParameterHelper._saxConfigurationObject(handler, (String)subEntry.getKey(), subEntry.getValue());
            }
            XMLUtils.endElement((ContentHandler)handler, (String)name);
        } else if (value instanceof Object[]) {
            for (Object item : (Object[])value) {
                if (item == null) continue;
                ParameterHelper._saxConfigurationObject(handler, name, item);
            }
        } else {
            XMLUtils.createElement((ContentHandler)handler, (String)name, (String)String.valueOf(value));
        }
    }

    public static Map<String, Object> toJSON(Parameter parameter) throws ProcessingException {
        ElementDefinition definition = new ElementDefinition();
        definition.setName(parameter.getId());
        definition.setLabel(parameter.getLabel());
        definition.setDescription(parameter.getDescription());
        definition.setPluginName(parameter.getPluginName());
        definition.setValidator(parameter.getValidator());
        definition.setWidget(parameter.getWidget());
        definition.setWidgetParameters(parameter.getWidgetParameters());
        Map<String, Object> result = definition.toJSON();
        result.put("type", ((Enum)parameter.getType()).name());
        if (parameter.getDefaultValue() != null) {
            result.put("default-value", parameter.getDefaultValue());
        }
        if (parameter.getEnumerator() != null) {
            Enumerator enumerator = parameter.getEnumerator();
            ArrayList enumeration = new ArrayList();
            try {
                Map<Object, I18nizableText> entries = enumerator.getEntries();
                for (Object entryKey : entries.keySet()) {
                    HashMap<String, Object> option = new HashMap<String, Object>();
                    option.put("value", ParameterHelper.valueToString(entryKey));
                    option.put("label", entries.get(entryKey));
                    enumeration.add(option);
                }
            }
            catch (Exception e) {
                throw new ProcessingException("Unable to enumerate entries with enumerator: " + enumerator, (Throwable)e);
            }
            result.put("enumeration", enumeration);
            result.put("enumerationConfig", enumerator.getConfiguration());
        }
        return result;
    }

    @Deprecated
    public static enum ParameterType {
        BOOLEAN,
        STRING,
        PASSWORD,
        LONG,
        DOUBLE,
        DATE,
        BINARY,
        DATASOURCE;

    }
}

