/*
 * Decompiled with CFR 0.152.
 */
package org.ametys.runtime.plugins.admin.configuration;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.ametys.core.cocoon.ActionResultGenerator;
import org.ametys.core.util.JSONUtils;
import org.ametys.runtime.config.ConfigManager;
import org.ametys.runtime.config.ConfigParameterCheckerDescriptor;
import org.ametys.runtime.model.DefinitionAndValue;
import org.ametys.runtime.model.checker.ItemChecker;
import org.apache.avalon.framework.parameters.Parameters;
import org.apache.avalon.framework.service.ServiceException;
import org.apache.avalon.framework.service.ServiceManager;
import org.apache.cocoon.acting.ServiceableAction;
import org.apache.cocoon.environment.ObjectModelHelper;
import org.apache.cocoon.environment.Redirector;
import org.apache.cocoon.environment.Request;
import org.apache.cocoon.environment.SourceResolver;

public class CheckConfigAction
extends ServiceableAction {
    private JSONUtils _jsonUtils;

    public void service(ServiceManager serviceManager) throws ServiceException {
        this._jsonUtils = (JSONUtils)serviceManager.lookup(JSONUtils.ROLE);
    }

    public Map act(Redirector redirector, SourceResolver resolver, Map objectModel, String source, Parameters parameters) throws Exception {
        HashMap<String, String> result = new HashMap<String, String>();
        Map<String, DefinitionAndValue> oldDefinitionAndValues = ConfigManager.getInstance().getOldDefinitionAndValues();
        Request request = ObjectModelHelper.getRequest((Map)objectModel);
        String fieldCheckersInfoJSON = request.getParameter("fieldCheckersInfo");
        Map<String, Object> fieldCheckersInfo = this._jsonUtils.convertJsonToMap(fieldCheckersInfoJSON);
        Map<String, Object> valuesByParameterChecker = this._getValuesByParamCheckerId(fieldCheckersInfo, oldDefinitionAndValues);
        for (String fieldCheckerId : valuesByParameterChecker.keySet()) {
            ItemChecker fieldChecker = (ItemChecker)((Map)valuesByParameterChecker.get(fieldCheckerId)).get("checker");
            List values = (List)((Map)valuesByParameterChecker.get(fieldCheckerId)).get("values");
            try {
                fieldChecker.check(values);
            }
            catch (Throwable t) {
                this.getLogger().error("The test '" + fieldCheckerId + "' failed : \n" + t.getMessage(), t);
                String msg = t.getMessage() != null ? t.getMessage() : "Unknown error";
                result.put(fieldCheckerId, msg);
            }
        }
        request.setAttribute(ActionResultGenerator.MAP_REQUEST_ATTR, result);
        return result;
    }

    private Map<String, Object> _getValuesByParamCheckerId(Map<String, Object> paramCheckersInfo, Map<String, DefinitionAndValue> oldDefinitionAndValues) {
        HashMap<String, Object> result = new HashMap<String, Object>();
        ConfigManager configManager = ConfigManager.getInstance();
        for (String paramCheckerId : paramCheckersInfo.keySet()) {
            HashMap<String, Object> valuesByParamCheckerId = new HashMap<String, Object>();
            ConfigParameterCheckerDescriptor parameterCheckerDescriptor = configManager.getParameterChecker(paramCheckerId);
            if (parameterCheckerDescriptor == null) {
                throw new IllegalArgumentException("The parameter checker '" + paramCheckerId + "' was not found.");
            }
            ItemChecker parameterChecker = parameterCheckerDescriptor.getParameterChecker();
            valuesByParamCheckerId.put("checker", parameterChecker);
            List paramNames = (List)((Map)paramCheckersInfo.get(paramCheckerId)).get("testParamsNames");
            List paramRawValues = (List)((Map)paramCheckersInfo.get(paramCheckerId)).get("rawTestValues");
            ArrayList<String> values = new ArrayList<String>();
            for (int i = 0; i < paramNames.size(); ++i) {
                String parameterName = (String)paramNames.get(i);
                Object value = paramRawValues.get(i);
                String resolvedValue = configManager.resolveValueForParameterChecker(parameterName, value, oldDefinitionAndValues);
                values.add(resolvedValue);
            }
            valuesByParamCheckerId.put("values", values);
            result.put(paramCheckerId, valuesByParamCheckerId);
        }
        return result;
    }
}

