/*
 * Decompiled with CFR 0.152.
 */
package org.ametys.runtime.plugins.admin.jvmstatus;

import java.io.IOException;
import java.lang.management.ManagementFactory;
import java.lang.management.ThreadInfo;
import java.util.HashMap;
import java.util.Map;
import org.apache.avalon.framework.parameters.Parameters;
import org.apache.cocoon.ProcessingException;
import org.apache.cocoon.environment.ObjectModelHelper;
import org.apache.cocoon.environment.Response;
import org.apache.cocoon.environment.SourceResolver;
import org.apache.cocoon.reading.AbstractReader;
import org.xml.sax.SAXException;

public class ThreadLogReader
extends AbstractReader {
    protected Response _response;

    public String getMimeType() {
        return "text/plain";
    }

    public void setup(SourceResolver pResolver, Map pObjectModel, String pSrc, Parameters pPar) throws ProcessingException, SAXException, IOException {
        super.setup(pResolver, pObjectModel, pSrc, pPar);
        this._response = ObjectModelHelper.getResponse((Map)pObjectModel);
    }

    public void generate() throws IOException, SAXException, ProcessingException {
        if (this.getLogger().isInfoEnabled()) {
            this.getLogger().info("Administrator is download deadlocked threads'report");
        }
        this._response.setHeader("Content-Disposition", "attachment");
        long[] deadlockedThreadsIds = ManagementFactory.getThreadMXBean().findMonitorDeadlockedThreads();
        if (deadlockedThreadsIds == null) {
            if (this.getLogger().isInfoEnabled()) {
                this.getLogger().info("Report is empty");
            }
            this.out.write("No thread in deadlock.\n".getBytes("UTF-8"));
        } else {
            ThreadInfo[] deadlockedThread;
            if (this.getLogger().isInfoEnabled()) {
                this.getLogger().info("Report contains " + deadlockedThreadsIds.length + " deadlocked threads");
            }
            this.out.write((deadlockedThreadsIds.length + " threads in deadlock.\n").getBytes("UTF-8"));
            Map<Thread, StackTraceElement[]> threads = Thread.getAllStackTraces();
            HashMap<Long, StackTraceElement[]> stackTraces = new HashMap<Long, StackTraceElement[]>();
            for (Thread thread : threads.keySet()) {
                long id = thread.getId();
                stackTraces.put(id, threads.get(thread));
            }
            for (ThreadInfo info : deadlockedThread = ManagementFactory.getThreadMXBean().getThreadInfo(deadlockedThreadsIds)) {
                StackTraceElement[] stes;
                this.out.write("\n".getBytes("UTF-8"));
                this.out.write(("THREAD '" + info.getThreadId() + "' - '" + info.getThreadName() + "'\n").getBytes("UTF-8"));
                this.out.write(("locked on monitor " + info.getLockName() + " by thread '" + info.getLockOwnerId() + "' - '" + info.getLockOwnerName() + "'\n").getBytes("UTF-8"));
                for (StackTraceElement ste : stes = (StackTraceElement[])stackTraces.get(info.getThreadId())) {
                    String line = "at " + ste.getClassName() + "." + ste.getMethodName() + " (" + ste.getFileName() + ":" + ste.getLineNumber() + ")\n";
                    this.out.write(line.getBytes("UTF-8"));
                }
            }
        }
    }
}

