/*
 * Decompiled with CFR 0.152.
 */
package org.ametys.runtime.plugins.admin.jvmstatus.monitoring.alerts;

import java.util.Map;
import org.ametys.runtime.i18n.I18nizableText;
import org.ametys.runtime.plugins.admin.jvmstatus.monitoring.SampleManager;

public interface AlertSampleManager
extends SampleManager {
    public Map<String, Threshold> getThresholdValues();

    public static class Threshold {
        private Operator _operator;
        private String _dsName;
        private Object _value;
        private I18nizableText _mailSubject;
        private I18nizableText _mailBody;

        public Threshold(Operator operator, String datasourceName, Object value, I18nizableText mailSubject, I18nizableText mailBody) {
            this._operator = operator;
            this._dsName = datasourceName;
            this._value = value;
            this._mailSubject = mailSubject;
            this._mailBody = mailBody;
        }

        public String getDatasourceName() {
            return this._dsName;
        }

        public Object getValue() {
            return this._value;
        }

        public I18nizableText getMailSubject() {
            return this._mailSubject;
        }

        public I18nizableText getMailBody() {
            return this._mailBody;
        }

        public boolean isExceeded(Object comparedTo) {
            if (this._value == null) {
                return false;
            }
            if (this._value instanceof Long) {
                Long longComparedTo;
                if (comparedTo instanceof Long) {
                    longComparedTo = (Long)comparedTo;
                } else if (comparedTo instanceof Integer) {
                    longComparedTo = new Long(((Integer)comparedTo).intValue());
                } else {
                    return false;
                }
                if (this._operator.equals((Object)Operator.GEQ)) {
                    return longComparedTo >= (Long)this._value;
                }
                if (this._operator.equals((Object)Operator.LEQ)) {
                    return longComparedTo <= (Long)this._value;
                }
            }
            if (this._value instanceof Double) {
                Double doubleComparedTo;
                if (comparedTo instanceof Double) {
                    doubleComparedTo = (Double)comparedTo;
                } else if (comparedTo instanceof Float) {
                    doubleComparedTo = new Double(((Float)comparedTo).floatValue());
                } else {
                    return false;
                }
                if (this._operator.equals((Object)Operator.GEQ)) {
                    return doubleComparedTo >= (Double)this._value;
                }
                if (this._operator.equals((Object)Operator.LEQ)) {
                    return doubleComparedTo <= (Double)this._value;
                }
            }
            return false;
        }

        public static enum Operator {
            LEQ,
            GEQ;

        }
    }
}

