/*
 * Decompiled with CFR 0.152.
 */
package org.ametys.runtime.plugins.admin.jvmstatus.monitoring.sample;

import java.util.HashMap;
import java.util.Map;
import org.ametys.runtime.plugins.admin.jvmstatus.monitoring.sample.DiskIOMonitor;
import org.hyperic.sigar.FileSystem;
import org.hyperic.sigar.FileSystemUsage;
import org.hyperic.sigar.Sigar;
import org.hyperic.sigar.SigarException;
import org.hyperic.sigar.SigarProxy;
import org.hyperic.sigar.SigarProxyCache;

public class SigarDiskIOMonitor
implements DiskIOMonitor {
    private final Sigar _sigar = new Sigar();
    private final SigarProxy _proxy = SigarProxyCache.newInstance((Sigar)this._sigar);
    private long _reads;
    private long _readBytes;
    private long _writes;
    private long _writeBytes;

    public SigarDiskIOMonitor() {
        this.refresh();
    }

    @Override
    public void refresh() {
        FileSystem[] fsList;
        this._reads = 0L;
        this._readBytes = 0L;
        this._writes = 0L;
        this._writeBytes = 0L;
        try {
            fsList = this._proxy.getFileSystemList();
        }
        catch (SigarException e) {
            return;
        }
        for (FileSystem fs : fsList) {
            if (fs.getType() != 2) continue;
            try {
                FileSystemUsage usage = this._sigar.getFileSystemUsage(fs.getDirName());
                this._reads += usage.getDiskReads();
                this._readBytes += usage.getDiskReadBytes();
                this._writes += usage.getDiskWrites();
                this._writeBytes += usage.getDiskWriteBytes();
            }
            catch (SigarException e) {
                // empty catch block
            }
        }
    }

    @Override
    public double getReads() {
        return this._reads;
    }

    @Override
    public double getReadBytes() {
        return this._readBytes;
    }

    @Override
    public double getWrites() {
        return this._writes;
    }

    @Override
    public double getWriteBytes() {
        return this._writeBytes;
    }

    @Override
    public Map<String, Double> toMap() {
        HashMap<String, Double> map = new HashMap<String, Double>();
        map.put("reads", this.getReads());
        map.put("read_bytes", this.getReadBytes());
        map.put("writes", this.getWrites());
        map.put("write_bytes", this.getWriteBytes());
        return map;
    }
}

