/*
 * Decompiled with CFR 0.152.
 */
package org.ametys.runtime.plugins.admin.logs;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.ametys.core.util.DateUtils;
import org.apache.cocoon.ProcessingException;
import org.apache.cocoon.generation.ServiceableGenerator;
import org.apache.cocoon.xml.XMLUtils;
import org.apache.excalibur.source.Source;
import org.apache.excalibur.source.SourceException;
import org.apache.excalibur.source.TraversableSource;
import org.xml.sax.ContentHandler;
import org.xml.sax.SAXException;

public class LogsGenerator
extends ServiceableGenerator {
    private static final Pattern __DATED_LOG_FILENAME = Pattern.compile("(.*)[-_]\\d{4}[-_]\\d{2}[-_]\\d{2}.*\\.log");

    public void generate() throws IOException, SAXException, ProcessingException {
        this.contentHandler.startDocument();
        XMLUtils.startElement((ContentHandler)this.contentHandler, (String)"logs");
        this._logs();
        XMLUtils.endElement((ContentHandler)this.contentHandler, (String)"logs");
        this.contentHandler.endDocument();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void _logs() throws IOException, SAXException {
        TraversableSource logsDirectorySource = (TraversableSource)this.resolver.resolveURI("ametys-home://logs");
        try {
            Map<String, List<TraversableSource>> logs = this._prepareLogs(logsDirectorySource);
            for (String logname : logs.keySet()) {
                List<TraversableSource> logSources = logs.get(logname);
                for (TraversableSource logSource : logSources) {
                    XMLUtils.startElement((ContentHandler)this.contentHandler, (String)"log");
                    XMLUtils.createElement((ContentHandler)this.contentHandler, (String)"name", (String)logname);
                    XMLUtils.createElement((ContentHandler)this.contentHandler, (String)"location", (String)logSource.getURI().substring(logSource.getURI().lastIndexOf(47) + 1));
                    XMLUtils.createElement((ContentHandler)this.contentHandler, (String)"lastModified", (String)DateUtils.dateToString(new Date(logSource.getLastModified())));
                    XMLUtils.createElement((ContentHandler)this.contentHandler, (String)"size", (String)Long.toString(logSource.getContentLength()));
                    XMLUtils.endElement((ContentHandler)this.contentHandler, (String)"log");
                }
            }
        }
        finally {
            this.resolver.release((Source)logsDirectorySource);
        }
    }

    private Map<String, List<TraversableSource>> _prepareLogs(TraversableSource logsDirectorySource) throws SourceException {
        HashMap<String, List<TraversableSource>> logs = new HashMap<String, List<TraversableSource>>();
        if (logsDirectorySource.exists()) {
            Collection logFiles = logsDirectorySource.getChildren();
            for (TraversableSource logSource : logFiles) {
                String name;
                String canonicalName;
                if (logSource.isCollection() || (canonicalName = this._getCanonicalName(name = logSource.getName())) == null) continue;
                ArrayList<TraversableSource> underLogs = (ArrayList<TraversableSource>)logs.get(canonicalName);
                if (underLogs == null) {
                    underLogs = new ArrayList<TraversableSource>();
                    logs.put(canonicalName, underLogs);
                }
                underLogs.add(logSource);
            }
        }
        return logs;
    }

    private String _getCanonicalName(String name) {
        Matcher matcher = __DATED_LOG_FILENAME.matcher(name);
        if (matcher.matches()) {
            return matcher.group(1);
        }
        if (name.endsWith(".log")) {
            return name;
        }
        return null;
    }
}

