/*
 * Decompiled with CFR 0.152.
 */
package org.ametys.workspaces.repository;

import javax.jcr.Node;
import javax.jcr.Property;
import javax.jcr.RepositoryException;
import javax.jcr.Value;
import org.apache.commons.lang3.ArrayUtils;
import org.apache.commons.lang3.StringUtils;

public final class ConsoleHelper {
    private ConsoleHelper() {
    }

    public static void setProperty(Node node, String name, Object values) throws RepositoryException {
        if (values instanceof String[]) {
            node.setProperty(name, (String[])values);
        } else if (values instanceof Value[]) {
            node.setProperty(name, (Value[])values);
        } else if (values instanceof Long) {
            node.setProperty(name, ((Long)values).longValue());
        } else if (values instanceof Double) {
            node.setProperty(name, ((Double)values).doubleValue());
        } else {
            System.out.println(values.getClass().toString() + " is not recognized");
            node.setProperty(name, (String[])values);
        }
    }

    public static boolean convertSingleToMultipleProperty(Node node, String propertyName) throws RepositoryException {
        Property property;
        boolean needSave = false;
        if (node.hasProperty(propertyName) && !(property = node.getProperty(propertyName)).getDefinition().isMultiple()) {
            Value value = property.getValue();
            if (value.getType() == 1) {
                String valueAsStr = value.getString();
                property.remove();
                if (!StringUtils.isEmpty((CharSequence)valueAsStr)) {
                    String[] strArray = value.getString().split(",");
                    node.setProperty(propertyName, strArray);
                } else {
                    node.setProperty(propertyName, new String[0]);
                }
            } else {
                Value[] values = (Value[])ArrayUtils.toArray((Object[])new Value[]{value});
                node.setProperty(propertyName, values);
            }
            needSave = true;
        }
        return needSave;
    }
}

