/*
 * Decompiled with CFR 0.152.
 */
package org.ametys.workspaces.repository.maintenance;

import java.util.Map;
import javax.jcr.RepositoryException;
import org.ametys.core.util.DateUtils;
import org.ametys.plugins.repositoryapp.RepositoryProvider;
import org.ametys.runtime.plugin.component.LogEnabled;
import org.ametys.workspaces.repository.maintenance.TaskProgress;
import org.apache.commons.lang.StringUtils;
import org.apache.jackrabbit.core.config.RepositoryConfig;
import org.slf4j.Logger;

public abstract class AbstractMaintenanceTask
implements LogEnabled {
    protected TaskProgress _progress;
    protected RepositoryConfig _repositoryConfig;
    protected RepositoryProvider _repositoryProvider;
    protected Logger _logger;
    private boolean _isFinished;

    public void execute(RepositoryConfig repositoryConfig) throws RepositoryException {
        this._repositoryConfig = repositoryConfig;
        long startTime = System.currentTimeMillis();
        this.setLogger();
        this._logger.info("Executing task.");
        try {
            this.initialize();
            this.setRunning();
            this.apply();
            this.setFinished();
        }
        catch (Exception e) {
            this.setInErrorState(e);
            throw e;
        }
        finally {
            this.close();
            this._logger.info("End of the task.");
            long elapsedTime = System.currentTimeMillis() - startTime;
            this._logger.info("Done in " + this._getFormattedDuration(elapsedTime));
        }
    }

    protected void initialize() throws RepositoryException {
    }

    protected abstract void setLogger();

    public void setLogger(Logger logger) {
        this._logger = logger;
    }

    protected abstract void apply() throws RepositoryException;

    protected void close() throws RepositoryException {
    }

    public Map<String, Object> getProgressInfo() {
        if (this._progress != null) {
            return this._progress.getProgressInfo();
        }
        return null;
    }

    public boolean isFinished() {
        return this._isFinished;
    }

    private synchronized void setRunning() {
        if (this._progress != null) {
            this._progress.setRunning();
        }
    }

    private synchronized void setFinished() {
        if (this._progress != null) {
            this._progress.setFinished();
        }
        this._isFinished = true;
    }

    private synchronized void setInErrorState(Exception e) {
        this._logger.error(e.getLocalizedMessage(), (Throwable)e);
        if (this._progress != null) {
            this._progress.setInErrorState(e);
        }
        this._isFinished = true;
    }

    protected String _getFormattedDuration(long elapsedTime) {
        String formatted = DateUtils.formatDuration((long)elapsedTime);
        return StringUtils.defaultIfEmpty((String)formatted, (String)"0s");
    }
}

