/*
 * Decompiled with CFR 0.152.
 */
package org.ametys.workspaces.repository.maintenance;

import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Iterator;
import javax.jcr.Credentials;
import javax.jcr.Node;
import javax.jcr.RepositoryException;
import javax.jcr.Session;
import javax.jcr.SimpleCredentials;
import javax.sql.DataSource;
import org.ametys.workspaces.repository.maintenance.AbstractMaintenanceTask;
import org.ametys.workspaces.repository.maintenance.TaskProgress;
import org.apache.jackrabbit.api.management.MarkEventListener;
import org.apache.jackrabbit.core.RepositoryContext;
import org.apache.jackrabbit.core.config.RepositoryConfig;
import org.apache.jackrabbit.core.data.DataIdentifier;
import org.apache.jackrabbit.core.data.DataStore;
import org.apache.jackrabbit.core.data.DataStoreException;
import org.apache.jackrabbit.core.data.FileDataStore;
import org.apache.jackrabbit.core.data.db.DbDataStore;
import org.apache.jackrabbit.core.data.db.DerbyDataStore;
import org.apache.jackrabbit.core.gc.GarbageCollector;
import org.apache.jackrabbit.core.persistence.IterablePersistenceManager;
import org.apache.jackrabbit.core.persistence.PersistenceManager;
import org.apache.jackrabbit.core.util.db.ConnectionFactory;
import org.apache.jackrabbit.core.util.db.ConnectionHelper;
import org.apache.jackrabbit.core.version.InternalVersionManagerImpl;
import org.slf4j.LoggerFactory;

public class DataStoreGarbageCollectorTask
extends AbstractMaintenanceTask
implements MarkEventListener {
    private static final int SYSTEM_GC_CALLS = 3;
    protected RepositoryContext _repositoryContext;
    protected Session _session;
    private GarbageCollector _garbageCollector;
    private IterablePersistenceManager[] _pmList;
    private int _scannedNodesCount;

    @Override
    protected void initialize() throws RepositoryException {
        int i;
        this._repositoryContext = RepositoryContext.create((RepositoryConfig)this._repositoryConfig);
        this._session = this._repositoryContext.getRepository().login((Credentials)new SimpleCredentials("__MAINTENANCE_TASK__", "".toCharArray()));
        this._garbageCollector = this._repositoryContext.getRepository().createDataStoreGarbageCollector();
        ArrayList<PersistenceManager> pmList = new ArrayList<PersistenceManager>();
        InternalVersionManagerImpl vm = this._repositoryContext.getInternalVersionManager();
        pmList.add(vm.getPersistenceManager());
        String[] wspNames = this._repositoryContext.getWorkspaceManager().getWorkspaceNames();
        for (i = 0; i < wspNames.length; ++i) {
            pmList.add(this.getPM(wspNames[i]));
        }
        this._pmList = new IterablePersistenceManager[pmList.size()];
        for (i = 0; i < pmList.size(); ++i) {
            IterablePersistenceManager[] pm = (IterablePersistenceManager[])pmList.get(i);
            if (!(pm instanceof IterablePersistenceManager)) {
                this._pmList = null;
                break;
            }
            this._pmList[i] = (IterablePersistenceManager)pm;
        }
        int count = 0;
        try {
            for (IterablePersistenceManager pm : this._pmList) {
                count += pm.getAllNodeIds(null, 0).size();
            }
            float total = 1.4285715f * (float)count;
            this._progress = new TaskProgress(Math.max(total, 1.0f));
        }
        catch (Exception e) {
            this._progress = new TaskProgress(0.0f);
            this._progress.setInErrorState(e);
            this._logger.error(e.getLocalizedMessage(), (Throwable)e);
        }
    }

    @Override
    protected void setLogger() {
        this.setLogger(LoggerFactory.getLogger(DataStoreGarbageCollectorTask.class));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected void apply() throws RepositoryException {
        for (int i = 0; i < 3; ++i) {
            System.gc();
        }
        long startSize = this._reportDataStoreInfo(this._garbageCollector.getDataStore());
        if (this._garbageCollector.getDataStore() instanceof FileDataStore) {
            try {
                Thread.sleep(2000L);
            }
            catch (InterruptedException e) {
                this._logger.error(e.getLocalizedMessage(), (Throwable)e);
                throw new RuntimeException(e);
            }
        }
        this._garbageCollector.setMarkEventListener((MarkEventListener)this);
        this._garbageCollector.setPersistenceManagerScan(true);
        try {
            this._scannedNodesCount = 0;
            this._logger.info("Scanning the repository nodes...");
            this._garbageCollector.mark();
            this._logger.info(this._scannedNodesCount + " nodes scanned.");
            this._logger.info("Deleting unused items... Please be patient.");
            int deleted = this._garbageCollector.sweep();
            this._logger.info(deleted + " unused items deleted.");
            if (this._progress != null) {
                this._progress.progressRelativePercentage(50);
            }
            this._logger.info("Finalizing the process...");
            if (this._garbageCollector.getDataStore() instanceof DerbyDataStore) {
                this._logger.info("Reclaiming unused space, this may take several minutes depending on the size of the data store.");
                this._logger.info("Please be patient.");
                DbDataStore ds = (DbDataStore)this._garbageCollector.getDataStore();
                this._derbyCompressTable(ds);
            }
        }
        finally {
            this._garbageCollector.close();
        }
        long finalSize = this._reportDataStoreInfo(this._garbageCollector.getDataStore());
        long freedSize = startSize - finalSize;
        this._logger.info("Size of cleared data : " + Math.round(freedSize / 1024L) + "Ko");
        this._logger.info("The total released space on your disk can be different depending on the type of the data store used by your repository.");
    }

    @Override
    protected void close() {
        if (this._session != null) {
            this._session.logout();
        }
        if (this._repositoryContext != null && this._repositoryContext.getRepository() != null) {
            this._repositoryContext.getRepository().shutdown();
        }
        if (this._progress != null) {
            this._progress.progressRelativePercentage(100);
        }
    }

    private long _reportDataStoreInfo(DataStore ds) throws DataStoreException {
        long count = 0L;
        long total = 0L;
        Iterator it = ds.getAllIdentifiers();
        while (it.hasNext()) {
            ++count;
            DataIdentifier id = (DataIdentifier)it.next();
            total += ds.getRecord(id).getLength();
        }
        StringBuilder sb = new StringBuilder();
        sb.append("Datastore item count : ").append(count).append(" ");
        sb.append("[total size : ").append(Math.round(total / 1024L)).append("Ko]");
        this._logger.info(sb.toString());
        return total;
    }

    private void _derbyCompressTable(DbDataStore ds) throws RepositoryException {
        DataSource dataSource = null;
        try {
            ConnectionFactory cf = this._repositoryConfig.getConnectionFactory();
            dataSource = ds.getDataSourceName() == null || "".equals(ds.getDataSourceName()) ? cf.getDataSource(ds.getDriver(), ds.getUrl(), ds.getUser(), ds.getPassword()) : cf.getDataSource(ds.getDataSourceName());
        }
        catch (SQLException e) {
            this._logger.error(e.getLocalizedMessage(), (Throwable)e);
            throw new RuntimeException(e);
        }
        if (dataSource != null) {
            ConnectionHelper conHelper = new ConnectionHelper(dataSource, false);
            String sql = "CALL SYSCS_UTIL.SYSCS_COMPRESS_TABLE(CURRENT SCHEMA, ?, 0)";
            String prefix = ds.getTablePrefix();
            String schemaObjPrefix = ds.getSchemaObjectPrefix();
            String table = prefix + schemaObjPrefix + "DATASTORE";
            try {
                conHelper.query(sql, new Object[]{table});
            }
            catch (SQLException e) {
                this._logger.error(e.getLocalizedMessage(), (Throwable)e);
                throw new RuntimeException(e);
            }
        } else {
            this._logger.error("Unable to compress the Derby datastore, unused space has not been freed up.");
        }
    }

    public void beforeScanning(Node n) throws RepositoryException {
        ++this._scannedNodesCount;
        if (this._progress != null) {
            this._progress.progress();
        }
    }

    protected PersistenceManager getPM(String workspaceName) throws RepositoryException {
        try {
            Object workspaceInfo = DataStoreGarbageCollectorTask.findAndInvokeMethod(this._repositoryContext.getRepository(), "getWorkspaceInfo", new Object[]{workspaceName});
            return (PersistenceManager)DataStoreGarbageCollectorTask.findAndInvokeMethod(workspaceInfo, "getPersistenceManager", null);
        }
        catch (Exception e) {
            throw new RepositoryException((Throwable)e);
        }
    }

    private static Object findAndInvokeMethod(Object obj, String name, Object[] parameters) throws IllegalArgumentException, IllegalAccessException, InvocationTargetException {
        Method m = null;
        Method[] ms = obj.getClass().getDeclaredMethods();
        for (int i = 0; i < ms.length; ++i) {
            Method x = ms[i];
            if (!x.getName().equals(name)) continue;
            m = x;
            m.setAccessible(true);
            return m.invoke(obj, parameters);
        }
        return null;
    }
}

