/*
 * Decompiled with CFR 0.152.
 */
package org.ametys.workspaces.repository.maintenance;

import java.io.File;
import java.io.IOException;
import javax.jcr.RepositoryException;
import org.ametys.workspaces.repository.maintenance.AbstractMaintenanceTask;
import org.ametys.workspaces.repository.maintenance.TaskProgress;
import org.apache.commons.io.FileUtils;
import org.apache.jackrabbit.core.RepositoryImpl;
import org.apache.jackrabbit.core.config.RepositoryConfig;
import org.slf4j.LoggerFactory;

public class ReindexingTask
extends AbstractMaintenanceTask {
    private static final String _INDEX_FOLDER_RELATIVE_PATH = "repository" + File.separator + "index";
    private static final String _WORKSPACES_FOLDER_RELATIVE_PATH = "workspaces";
    protected RepositoryImpl _repository;
    private String[] _workspaceFolders;

    @Override
    protected void initialize() throws RepositoryException {
        File file = new File(this._repositoryConfig.getHomeDir() + File.separator + _WORKSPACES_FOLDER_RELATIVE_PATH);
        this._workspaceFolders = file.list((f, name) -> f.isDirectory());
        this._progress = new TaskProgress(1.6666666f * (float)(this._workspaceFolders.length + 1));
    }

    @Override
    protected void setLogger() {
        this.setLogger(LoggerFactory.getLogger(ReindexingTask.class));
    }

    @Override
    protected void apply() throws RepositoryException {
        try {
            this.deleteIndexFolder(_INDEX_FOLDER_RELATIVE_PATH);
            this._logger.info("Successfully deleted root repository index folder");
        }
        catch (IOException e) {
            this._logger.error(e.getLocalizedMessage(), (Throwable)e);
        }
        for (String folder : this._workspaceFolders) {
            try {
                this.deleteIndexFolder(_WORKSPACES_FOLDER_RELATIVE_PATH + File.separator + folder + File.separator + "index");
                this._logger.info("Successfully deleted index folder of workspace '" + folder + "'");
            }
            catch (IOException e) {
                this._logger.error(e.getLocalizedMessage(), (Throwable)e);
            }
        }
        this._logger.info("Starting repository to launch the re-indexing process");
        this._repository = RepositoryImpl.create((RepositoryConfig)this._repositoryConfig);
        this._logger.info("Repository restarted successfully, reindexing process has ended.");
        this.setProgressTo(90);
        this._logger.info("Shuting down repository");
        this._repository.shutdown();
        this._repository = null;
        this.setProgressTo(100);
    }

    @Override
    protected void close() {
        if (this._repository != null) {
            this._repository.shutdown();
        }
    }

    private void deleteIndexFolder(String relativePath) throws IOException {
        File dir = new File(this._repositoryConfig.getHomeDir() + File.separator + relativePath);
        FileUtils.deleteDirectory((File)dir);
        if (this._progress != null) {
            this._progress.progress();
        }
    }

    private void setProgressTo(int percentage) {
        if (this._progress != null) {
            this._progress.progressTotalPercentage(percentage);
        }
    }
}

